/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.ui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.server.LensServices;

@Path(value="/")
public class StaticFileResource {
    public static final Log LOG = LogFactory.getLog(StaticFileResource.class);
    private static final LoadingCache<String, String> contentCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, String>(){
        String baseDir = null;

        public String load(String filePath) throws Exception {
            if (this.baseDir == null) {
                this.baseDir = LensServices.get().getHiveConf().get("lens.server..ui.static.dir", "webapp/lens-server/static");
            }
            return StaticFileResource.loadFile(this.baseDir, filePath);
        }
    });

    private static String loadFile(String baseDir, String filePath) throws IOException {
        return Files.toString((File)new File(baseDir, filePath), (Charset)Charset.forName("UTF-8"));
    }

    @GET
    @Path(value="/{filePath:.*}")
    public Response getStaticResource(@PathParam(value="filePath") String filePath) {
        try {
            HiveConf conf = LensServices.get().getHiveConf();
            if (conf.getBoolean("lens.server.ui.enable.caching", true)) {
                return Response.ok((Object)contentCache.get((Object)filePath), (String)this.getMediaType(filePath)).build();
            }
            String baseDir = conf.get("lens.server..ui.static.dir", "webapp/lens-server/static");
            return Response.ok((Object)StaticFileResource.loadFile(baseDir, filePath), (String)this.getMediaType(filePath)).build();
        }
        catch (Exception e) {
            if (e.getCause() instanceof FileNotFoundException || e instanceof FileNotFoundException) {
                throw new NotFoundException("Not Found: " + filePath);
            }
            throw new WebApplicationException("Server error: " + e.getCause(), (Throwable)e);
        }
    }

    private String getMediaType(String filePath) {
        if (filePath == null) {
            return null;
        }
        if (filePath.endsWith(".html")) {
            return "text/html";
        }
        if (filePath.endsWith(".js")) {
            return "application/javascript";
        }
        if (filePath.endsWith(".css")) {
            return "text/css";
        }
        return null;
    }
}

