/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.query.InMemoryQueryResult;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.PersistentQueryResult;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.QuerySubmitResult;
import org.apache.lens.api.query.ResultColumn;
import org.apache.lens.api.query.ResultRow;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.query.QueryExecutionService;
import org.apache.lens.server.ui.SessionUIResource;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="/queryuiapi")
public class QueryServiceUIResource {
    public static final Log LOG = LogFactory.getLog(QueryServiceUIResource.class);
    private QueryExecutionService queryServer;

    private void checkQuery(String query) {
        if (StringUtils.isBlank((String)query)) {
            throw new BadRequestException("Invalid query");
        }
    }

    private void checkSessionHandle(LensSessionHandle sessionHandle) {
        if (sessionHandle == null) {
            throw new BadRequestException("Invalid session handle");
        }
    }

    public QueryServiceUIResource() {
        LOG.info((Object)"Query UI Service");
        this.queryServer = (QueryExecutionService)LensServices.get().getService("query");
    }

    private QueryHandle getQueryHandle(String queryHandle) {
        try {
            return QueryHandle.fromString((String)queryHandle);
        }
        catch (Exception e) {
            throw new BadRequestException("Invalid query handle: " + queryHandle, (Throwable)e);
        }
    }

    @GET
    @Path(value="queries")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public List<QueryHandle> getAllQueries(@QueryParam(value="publicId") UUID publicId, @DefaultValue(value="") @QueryParam(value="state") String state, @DefaultValue(value="") @QueryParam(value="user") String user, @DefaultValue(value="") @QueryParam(value="queryName") String queryName, @DefaultValue(value="-1") @QueryParam(value="fromDate") long fromDate, @DefaultValue(value="-1") @QueryParam(value="toDate") long toDate) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        try {
            return this.queryServer.getAllQueries(sessionHandle, state, user, queryName, fromDate, toDate == -1L ? Long.MAX_VALUE : toDate);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="queries")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public QuerySubmitResult query(@FormDataParam(value="publicId") UUID publicId, @FormDataParam(value="query") String query, @DefaultValue(value="") @FormDataParam(value="queryName") String queryName) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        this.checkQuery(query);
        try {
            LensConf conf = new LensConf();
            return this.queryServer.executeAsync(sessionHandle, query, conf, queryName);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public LensQuery getStatus(@QueryParam(value="publicId") UUID publicId, @PathParam(value="queryHandle") String queryHandle) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        try {
            return this.queryServer.getQuery(sessionHandle, this.getQueryHandle(queryHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}/resultset")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public ResultRow getResultSet(@QueryParam(value="publicId") UUID publicId, @PathParam(value="queryHandle") String queryHandle, @QueryParam(value="pageNumber") int pageNumber, @QueryParam(value="fetchsize") int fetchSize) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        ArrayList<Object> rows = new ArrayList<Object>();
        LOG.info((Object)("FetchResultSet for queryHandle:" + queryHandle));
        try {
            QueryResultSetMetadata resultSetMetadata = this.queryServer.getResultSetMetadata(sessionHandle, this.getQueryHandle(queryHandle));
            List metaColumns = resultSetMetadata.getColumns();
            ArrayList<String> metaResultColumns = new ArrayList<String>();
            for (ResultColumn column : metaColumns) {
                metaResultColumns.add(column.getName());
            }
            rows.add(new ResultRow(metaResultColumns));
            QueryResult result = this.queryServer.fetchResultSet(sessionHandle, this.getQueryHandle(queryHandle), (long)((pageNumber - 1) * fetchSize), fetchSize);
            if (result instanceof InMemoryQueryResult) {
                InMemoryQueryResult inMemoryQueryResult = (InMemoryQueryResult)result;
                List tableRows = inMemoryQueryResult.getRows();
                rows.addAll(tableRows);
            } else if (result instanceof PersistentQueryResult) {
                PersistentQueryResult persistentQueryResult = (PersistentQueryResult)result;
                rows.add("PersistentResultSet");
            }
            return new ResultRow(rows);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="queries/{queryHandle}")
    @Produces(value={"application/json", "application/xml", "text/plain"})
    public APIResult cancelQuery(@QueryParam(value="sessionid") UUID publicId, @PathParam(value="queryHandle") String queryHandle) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        try {
            boolean ret = this.queryServer.cancelQuery(sessionHandle, this.getQueryHandle(queryHandle));
            if (ret) {
                return new APIResult(APIResult.Status.SUCCEEDED, "Cancel on the query " + queryHandle + " is successful");
            }
            return new APIResult(APIResult.Status.FAILED, "Cancel on the query " + queryHandle + " failed");
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="queries/{queryHandle}/httpresultset")
    @Produces(value={"application/octet-stream"})
    public Response getHttpResultSet(@QueryParam(value="sessionid") UUID publicId, @PathParam(value="queryHandle") String queryHandle) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        try {
            return this.queryServer.getHttpResultSet(sessionHandle, this.getQueryHandle(queryHandle));
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }
}

