/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.ui;

import java.util.List;
import java.util.UUID;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.metastore.XBaseCube;
import org.apache.lens.api.metastore.XDimAttribute;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XExprColumn;
import org.apache.lens.api.metastore.XMeasure;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.metastore.CubeMetastoreService;
import org.apache.lens.server.ui.SessionUIResource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="metastoreapi")
public class MetastoreUIResource {
    public static final Log LOG = LogFactory.getLog(MetastoreUIResource.class);

    public CubeMetastoreService getSvc() {
        return (CubeMetastoreService)LensServices.get().getService("metastore");
    }

    private void checkSessionHandle(LensSessionHandle sessionHandle) {
        if (sessionHandle == null) {
            throw new BadRequestException("Invalid session handle");
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "Metastore is up";
    }

    @GET
    @Path(value="tables")
    @Produces(value={"text/html", "application/json", "application/xml"})
    public String getAllTables(@QueryParam(value="publicId") UUID publicId) {
        List dimTables;
        List cubes;
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        JSONArray tableList = new JSONArray();
        try {
            cubes = this.getSvc().getAllCubeNames(sessionHandle);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
        if (cubes != null) {
            for (String cube : cubes) {
                try {
                    tableList.put((Object)new JSONObject().put("name", (Object)cube).put("type", (Object)"cube"));
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
            }
        }
        try {
            dimTables = this.getSvc().getAllDimensionNames(sessionHandle);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
        if (dimTables != null) {
            for (String dimTable : dimTables) {
                try {
                    tableList.put((Object)new JSONObject().put("name", (Object)dimTable).put("type", (Object)"dimtable"));
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
            }
        }
        try {
            List nativeTables = this.getSvc().getAllNativeTableNames(sessionHandle, "all", null);
            for (String nativeTable : nativeTables) {
                tableList.put((Object)new JSONObject().put("name", (Object)nativeTable).put("type", (Object)"native"));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return tableList.toString();
    }

    @GET
    @Path(value="tables/{name}")
    @Produces(value={"text/html", "application/json", "application/xml"})
    public String getDescription(@QueryParam(value="publicId") UUID publicId, @QueryParam(value="type") String type, @PathParam(value="name") String name) {
        JSONArray attribList;
        block21: {
            LensSessionHandle sessionHandle;
            block20: {
                XBaseCube cube;
                sessionHandle = SessionUIResource.openSessions.get(publicId);
                this.checkSessionHandle(sessionHandle);
                attribList = new JSONArray();
                if (!type.equals("cube")) break block20;
                try {
                    cube = (XBaseCube)this.getSvc().getCube(sessionHandle, name);
                }
                catch (LensException e) {
                    throw new WebApplicationException((Throwable)e);
                }
                if (cube.getMeasures() != null) {
                    for (XMeasure measure : cube.getMeasures().getMeasure()) {
                        try {
                            attribList.put((Object)new JSONObject().put("name", (Object)measure.getName()).put("type", (Object)measure.getType()));
                        }
                        catch (JSONException j) {
                            LOG.error((Object)j);
                        }
                    }
                }
                if (cube.getDimAttributes() == null) break block21;
                for (XDimAttribute dim : cube.getDimAttributes().getDimAttribute()) {
                    try {
                        attribList.put((Object)new JSONObject().put("name", (Object)dim.getName()).put("type", (Object)dim.getType()));
                    }
                    catch (JSONException j) {
                        LOG.error((Object)j);
                    }
                }
                break block21;
            }
            if (type.equals("dimtable")) {
                XDimension table;
                try {
                    table = this.getSvc().getDimension(sessionHandle, name);
                }
                catch (LensException e) {
                    throw new WebApplicationException((Throwable)e);
                }
                if (table.getAttributes() != null) {
                    for (XDimAttribute col : table.getAttributes().getDimAttribute()) {
                        try {
                            attribList.put((Object)new JSONObject().put("name", (Object)col.getName()).put("type", (Object)col.getType()));
                        }
                        catch (JSONException j) {
                            LOG.error((Object)j);
                        }
                    }
                }
                if (table.getExpressions() != null) {
                    for (XExprColumn expr : table.getExpressions().getExpression()) {
                        try {
                            attribList.put((Object)new JSONObject().put("name", (Object)expr.getName()).put("type", (Object)"expression").put("expression", (Object)expr.getExpr()));
                        }
                        catch (JSONException j) {
                            LOG.error((Object)j);
                        }
                    }
                }
            }
        }
        return attribList.toString();
    }

    @GET
    @Path(value="searchablefields")
    @Produces(value={"text/html", "application/json", "application/xml"})
    public String getFilterResults(@QueryParam(value="publicId") UUID publicId, @QueryParam(value="keyword") String keyword) {
        LensSessionHandle sessionHandle = SessionUIResource.openSessions.get(publicId);
        this.checkSessionHandle(sessionHandle);
        JSONArray tableList = null;
        JSONArray searchResultList = new JSONArray();
        try {
            tableList = new JSONArray(this.getAllTables(publicId));
        }
        catch (JSONException j) {
            LOG.error((Object)j);
        }
        for (int item = 0; item < tableList.length(); ++item) {
            String coltype;
            String colname;
            String name = null;
            String type = null;
            try {
                name = tableList.getJSONObject(item).getString("name");
                type = tableList.getJSONObject(item).getString("type");
            }
            catch (JSONException j) {
                LOG.error((Object)j);
            }
            if (type.equals("cube")) {
                JSONArray cubeAttribList = null;
                JSONArray cubeSearchResultList = new JSONArray();
                try {
                    cubeAttribList = new JSONArray(this.getDescription(publicId, "cube", name));
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
                for (int col = 0; col < cubeAttribList.length(); ++col) {
                    colname = null;
                    coltype = null;
                    try {
                        colname = cubeAttribList.getJSONObject(col).getString("name");
                        coltype = cubeAttribList.getJSONObject(col).getString("type");
                    }
                    catch (JSONException j) {
                        LOG.error((Object)j);
                    }
                    if (!colname.contains(keyword)) continue;
                    try {
                        cubeSearchResultList.put((Object)new JSONObject().put("name", (Object)colname).put("type", (Object)coltype));
                        continue;
                    }
                    catch (JSONException j) {
                        LOG.error((Object)j);
                    }
                }
                if (cubeSearchResultList.length() > 0) {
                    try {
                        searchResultList.put((Object)new JSONObject().put("name", (Object)name).put("type", (Object)type).put("columns", (Object)cubeSearchResultList));
                    }
                    catch (JSONException j) {
                        LOG.error((Object)j);
                    }
                    continue;
                }
                if (!name.contains(keyword)) continue;
                try {
                    searchResultList.put((Object)new JSONObject().put("name", (Object)name).put("type", (Object)type).put("columns", (Object)cubeSearchResultList));
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
                continue;
            }
            if (!type.equals("dimtable")) continue;
            JSONArray dimAttribList = null;
            JSONArray dimSearchResultList = new JSONArray();
            try {
                dimAttribList = new JSONArray(this.getDescription(publicId, "dimtable", name));
            }
            catch (JSONException j) {
                LOG.error((Object)j);
            }
            for (int col = 0; col < dimAttribList.length(); ++col) {
                colname = null;
                coltype = null;
                try {
                    colname = dimAttribList.getJSONObject(col).getString("name");
                    coltype = dimAttribList.getJSONObject(col).getString("type");
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
                if (!colname.contains(keyword)) continue;
                try {
                    dimSearchResultList.put((Object)new JSONObject().put("name", (Object)colname).put("type", (Object)coltype));
                    continue;
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
            }
            if (dimSearchResultList.length() > 0) {
                try {
                    searchResultList.put((Object)new JSONObject().put("name", (Object)name).put("type", (Object)type).put("columns", (Object)dimSearchResultList));
                }
                catch (JSONException j) {
                    LOG.error((Object)j);
                }
                continue;
            }
            if (!name.contains(keyword)) continue;
            try {
                searchResultList.put((Object)new JSONObject().put("name", (Object)name).put("type", (Object)type).put("columns", (Object)dimSearchResultList));
                continue;
            }
            catch (JSONException j) {
                LOG.error((Object)j);
            }
        }
        return searchResultList.toString();
    }
}

