/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats.store.log;

import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lens.api.LensException;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.LensEvent;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.stats.store.log.PartitionEvent;
import org.apache.log4j.FileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsLogFileScannerTask
extends TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsLogFileScannerTask.class);
    public static final String LOG_SCANNER_ERRORS = "log-scanner-errors";
    private Map<String, String> scanSet = new ConcurrentHashMap<String, String>();
    private LensEventService service;
    private Map<String, String> classSet = new ConcurrentHashMap<String, String>();

    @Override
    public void run() {
        try {
            for (Map.Entry<String, String> entry : this.scanSet.entrySet()) {
                File f = new File(entry.getValue()).getAbsoluteFile();
                String fileName = f.getAbsolutePath();
                File[] latestLogFiles = this.getLatestLogFile(fileName);
                HashMap<String, String> partMap = this.getPartMap(fileName, latestLogFiles);
                String eventName = entry.getKey();
                PartitionEvent event = new PartitionEvent(eventName, partMap, this.classSet.get(eventName));
                try {
                    this.service.notifyEvent((LensEvent)event);
                }
                catch (LensException e) {
                    LOG.warn("Unable to Notify partition event" + event.getEventName() + " with map  " + event.getPartMap());
                }
            }
        }
        catch (Exception exc) {
            MetricsService svc = (MetricsService)LensServices.get().getService("metrics");
            svc.incrCounter(StatisticsLogFileScannerTask.class, LOG_SCANNER_ERRORS);
            LOG.error("Unknown error in log file scanner ", (Throwable)exc);
        }
    }

    private HashMap<String, String> getPartMap(String fileName, File[] latestLogFiles) {
        HashMap<String, String> partMap = new HashMap<String, String>();
        for (File f : latestLogFiles) {
            partMap.put(f.getPath().replace(fileName + '.', ""), f.getAbsolutePath());
        }
        return partMap;
    }

    private File[] getLatestLogFile(String value) {
        File f = new File(value);
        final String fileNamePattern = f.getName();
        File parent = f.getParentFile();
        return parent.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String name) {
                return !new File(name).isHidden() && !name.equals(fileNamePattern) && name.contains(fileNamePattern);
            }
        });
    }

    public void addLogFile(String event) {
        if (this.scanSet.containsKey(event)) {
            return;
        }
        String appenderName = event.substring(event.lastIndexOf(".") + 1, event.length());
        org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger((String)event);
        if (log.getAppender(appenderName) == null) {
            LOG.error("Unable to find statistics log appender for  " + event + " with appender name " + appenderName);
            return;
        }
        String location = ((FileAppender)log.getAppender(appenderName)).getFile();
        this.scanSet.put(appenderName, location);
        this.classSet.put(appenderName, event);
    }

    public void setService(LensEventService service) {
        this.service = service;
    }
}

