/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats.store.log;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.LensEventListener;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.stats.event.LoggableLensStatistics;
import org.apache.lens.server.stats.store.StatisticsStore;
import org.apache.lens.server.stats.store.log.PartitionEvent;
import org.apache.lens.server.stats.store.log.StatisticsLogPartitionHandler;
import org.apache.lens.server.stats.store.log.StatisticsLogRollupHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogStatisticsStore
extends StatisticsStore<LoggableLensStatistics> {
    private static final Logger LOG = LoggerFactory.getLogger(LogStatisticsStore.class);
    public static final String LOG_STORE_ERRORS = "log-store-errors";
    private final ObjectMapper mapper = new ObjectMapper();
    private StatisticsLogPartitionHandler handler;
    private StatisticsLogRollupHandler rollupHandler;

    public LogStatisticsStore() {
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Override
    public void initialize(Configuration conf) {
        LOG.info("Creating new Partition handler");
        this.handler = new StatisticsLogPartitionHandler();
        this.handler.initialize(conf);
        LOG.info("Creating new rollup handler");
        this.rollupHandler = new StatisticsLogRollupHandler();
        this.rollupHandler.initialize(conf);
    }

    public void process(LoggableLensStatistics event) {
        try {
            Class<?> eventClass = ((Object)((Object)event)).getClass();
            String representation = null;
            try {
                representation = this.mapper.writeValueAsString((Object)event);
            }
            catch (JsonProcessingException ignored) {
                // empty catch block
            }
            if (representation != null) {
                this.rollupHandler.addToScanTask(eventClass.getName());
                LoggerFactory.getLogger(eventClass).info(representation);
            }
        }
        catch (Exception exc) {
            MetricsService metricsService = (MetricsService)LensServices.get().getService("metrics");
            metricsService.incrCounter(LogStatisticsStore.class, LOG_STORE_ERRORS);
            LOG.error("Unknown error ", (Throwable)exc);
        }
    }

    @Override
    public void start(LensEventService service) {
        super.start(service);
        if (service != null) {
            service.addListenerForType((LensEventListener)this, LoggableLensStatistics.class);
            service.addListenerForType((LensEventListener)this.handler, PartitionEvent.class);
            this.rollupHandler.start(service);
        } else {
            LOG.warn("Not starting Log Statistics store as event service is not configured");
        }
    }

    @Override
    public void stop(LensEventService service) {
        super.stop(service);
        if (service != null) {
            service.removeListenerForType((LensEventListener)this, LoggableLensStatistics.class);
            service.removeListenerForType((LensEventListener)this.handler, PartitionEvent.class);
            this.rollupHandler.stop();
        } else {
            LOG.warn("Not stopping Log Statistics store as event service is not configured");
        }
    }
}

