/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.stats;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.AbstractService;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.stats.store.StatisticsStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsService
extends AbstractService {
    private static final Logger LOG = LoggerFactory.getLogger(StatisticsService.class);
    public static final String STATS_SVC_NAME = "stats";
    private StatisticsStore store;

    public StatisticsService(String name) {
        super(STATS_SVC_NAME);
    }

    public synchronized void init(HiveConf hiveConf) {
        super.init(hiveConf);
        String storeClassName = hiveConf.get("lens.server.statistics.store.class");
        if (storeClassName == null) {
            LOG.warn("Statistics service configured with no Stores defined");
            return;
        }
        Class<?> klass = null;
        try {
            klass = Class.forName(storeClassName);
            this.store = (StatisticsStore)((Object)klass.newInstance());
            LOG.info("Initializing Statistics Store  " + klass.getName());
            this.store.initialize((Configuration)hiveConf);
        }
        catch (Exception e) {
            LOG.error("Unable to initalize the statistics store", (Throwable)e);
        }
    }

    public synchronized void start() {
        if (this.store != null) {
            this.store.start((LensEventService)LensServices.get().getService("event"));
        } else {
            LOG.warn("Unable to start the LogStore.");
        }
        super.start();
    }

    public synchronized void stop() {
        if (this.store != null) {
            this.store.stop((LensEventService)LensServices.get().getService("event"));
        } else {
            LOG.warn("Not starting the LogStore as it was not started.");
        }
        super.stop();
    }
}

