/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.session;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.NotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.cli.session.HiveSessionImpl;
import org.apache.hive.service.cli.thrift.TProtocolVersion;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.cube.metadata.CubeMetastoreClient;
import org.apache.lens.server.util.UtilityMethods;

public class LensSessionImpl
extends HiveSessionImpl {
    public static final Log LOG = LogFactory.getLog(LensSessionImpl.class);
    private LensSessionPersistInfo persistInfo = new LensSessionPersistInfo();
    private long lastAccessTime = System.currentTimeMillis();
    private long sessionTimeout;
    private Configuration conf = LensSessionImpl.createDefaultConf();
    public static Map<String, String> DEFAULT_HIVE_SESSION_CONF = LensSessionImpl.getHiveSessionConf();

    private void initPersistInfo(SessionHandle sessionHandle, String username, String password, Map<String, String> sessionConf) {
        this.persistInfo.setSessionHandle(new LensSessionHandle(sessionHandle.getHandleIdentifier().getPublicId(), sessionHandle.getHandleIdentifier().getSecretId()));
        this.persistInfo.setUsername(username);
        this.persistInfo.setPassword(password);
        this.persistInfo.setLastAccessTime(this.lastAccessTime);
        this.persistInfo.setSessionConf(sessionConf);
    }

    public static Configuration createDefaultConf() {
        Configuration conf = new Configuration(false);
        conf.addResource("lenssession-default.xml");
        conf.addResource("lens-site.xml");
        return conf;
    }

    public static Map<String, String> getHiveSessionConf() {
        Configuration defaultConf = LensSessionImpl.createDefaultConf();
        return defaultConf.getValByRegex("hive.*");
    }

    public LensSessionImpl(TProtocolVersion protocol, String username, String password, HiveConf serverConf, Map<String, String> sessionConf, String ipAddress) {
        super(protocol, username, password, serverConf, sessionConf, ipAddress);
        this.initPersistInfo(this.getSessionHandle(), username, password, sessionConf);
        this.sessionTimeout = 1000L * serverConf.getLong("lens.server.session.timeout.seconds", 86400L);
        if (sessionConf != null) {
            for (Map.Entry<String, String> entry : sessionConf.entrySet()) {
                this.conf.set(entry.getKey(), entry.getValue());
            }
        }
    }

    public Configuration getSessionConf() {
        return this.conf;
    }

    public LensSessionImpl(SessionHandle sessionHandle, TProtocolVersion protocol, String username, String password, HiveConf serverConf, Map<String, String> sessionConf, String ipAddress) {
        super(sessionHandle, protocol, username, password, serverConf, sessionConf, ipAddress);
        this.initPersistInfo(this.getSessionHandle(), username, password, sessionConf);
        this.sessionTimeout = 1000L * serverConf.getLong("lens.server.session.timeout.seconds", 86400L);
    }

    public CubeMetastoreClient getCubeMetastoreClient() throws LensException {
        try {
            return CubeMetastoreClient.getInstance((HiveConf)this.getHiveConf());
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
    }

    public synchronized void acquire() {
        try {
            super.acquire();
        }
        catch (HiveSQLException e) {
            throw new NotFoundException("Could not acquire the session", (Throwable)e);
        }
    }

    public synchronized void release() {
        this.lastAccessTime = System.currentTimeMillis();
        super.release();
    }

    public boolean isActive() {
        long inactiveAge = System.currentTimeMillis() - this.lastAccessTime;
        return inactiveAge < this.sessionTimeout;
    }

    public void setConfig(String key, String value) {
        this.persistInfo.getConfig().put(key, value);
    }

    public void removeResource(String type, String path) {
        Iterator<ResourceEntry> itr = this.persistInfo.getResources().iterator();
        while (itr.hasNext()) {
            ResourceEntry res = itr.next();
            if (!res.getType().equals(type) || !res.getLocation().equals(path)) continue;
            itr.remove();
        }
    }

    public void addResource(String type, String path) {
        this.persistInfo.getResources().add(new ResourceEntry(type, path));
    }

    protected List<ResourceEntry> getResources() {
        return this.persistInfo.getResources();
    }

    protected Map<String, String> getConfig() {
        return this.persistInfo.getConfig();
    }

    public void setCurrentDatabase(String currentDatabase) {
        this.persistInfo.setDatabase(currentDatabase);
        this.getSessionState().setCurrentDatabase(currentDatabase);
    }

    public String getCurrentDatabase() {
        return this.getSessionState().getCurrentDatabase();
    }

    public String toString() {
        return this.getSessionHandle().getHandleIdentifier().toString();
    }

    public String getLoggedInUser() {
        return this.getHiveConf().get("lens.session.loggedin.user");
    }

    public String getClusterUser() {
        return this.getUserName();
    }

    public LensSessionPersistInfo getLensSessionPersistInfo() {
        return this.persistInfo;
    }

    void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public static class LensSessionPersistInfo
    implements Externalizable {
        private List<ResourceEntry> resources = new ArrayList<ResourceEntry>();
        private Map<String, String> config = new HashMap<String, String>();
        private LensSessionHandle sessionHandle;
        private String database;
        private String username;
        private String password;
        private long lastAccessTime;

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public List<ResourceEntry> getResources() {
            return this.resources;
        }

        public void setResources(List<ResourceEntry> resources) {
            this.resources = resources;
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public void setConfig(Map<String, String> config) {
            this.config = config;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public LensSessionHandle getSessionHandle() {
            return this.sessionHandle;
        }

        public void setSessionHandle(LensSessionHandle sessionHandle) {
            this.sessionHandle = sessionHandle;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public void setLastAccessTime(long accessTime) {
            this.lastAccessTime = accessTime;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void setSessionConf(Map<String, String> sessionConf) {
            UtilityMethods.mergeMaps(this.config, sessionConf, true);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.sessionHandle.toString());
            out.writeUTF(this.database == null ? "default" : this.database);
            out.writeUTF(this.username == null ? "" : this.username);
            out.writeUTF(this.password == null ? "" : this.password);
            out.writeInt(this.resources.size());
            for (ResourceEntry resource : this.resources) {
                out.writeUTF(resource.getType());
                out.writeUTF(resource.getLocation());
            }
            out.writeInt(this.config.size());
            for (String key : this.config.keySet()) {
                out.writeUTF(key);
                out.writeUTF(this.config.get(key));
            }
            out.writeLong(this.lastAccessTime);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.sessionHandle = LensSessionHandle.valueOf((String)in.readUTF());
            this.database = in.readUTF();
            this.username = in.readUTF();
            this.password = in.readUTF();
            int resSize = in.readInt();
            this.resources.clear();
            for (int i = 0; i < resSize; ++i) {
                String type = in.readUTF();
                String location = in.readUTF();
                this.resources.add(new ResourceEntry(type, location));
            }
            this.config.clear();
            int cfgSize = in.readInt();
            for (int i = 0; i < cfgSize; ++i) {
                String key = in.readUTF();
                String val = in.readUTF();
                this.config.put(key, val);
            }
            this.lastAccessTime = in.readLong();
        }
    }

    public static class ResourceEntry {
        final String type;
        final String location;
        transient int restoreCount;

        public ResourceEntry(String type, String location) {
            if (type == null || location == null) {
                throw new NullPointerException("ResourceEntry type or location cannot be null");
            }
            this.type = type;
            this.location = location;
        }

        public String getLocation() {
            return this.location;
        }

        public String getType() {
            return this.type;
        }

        public void restoredResource() {
            ++this.restoreCount;
        }

        public int getRestoreCount() {
            return this.restoreCount;
        }

        public String toString() {
            return "type=" + this.type + " path=" + this.location;
        }
    }
}

