/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.lens.api.LensException;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.driver.InMemoryResultSet;
import org.apache.lens.server.api.driver.LensResultSet;
import org.apache.lens.server.api.driver.PersistentResultSet;
import org.apache.lens.server.api.events.AsyncEventListener;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.api.query.InMemoryOutputFormatter;
import org.apache.lens.server.api.query.PersistedOutputFormatter;
import org.apache.lens.server.api.query.QueryContext;
import org.apache.lens.server.api.query.QueryExecuted;
import org.apache.lens.server.api.query.QueryOutputFormatter;
import org.apache.lens.server.query.QueryExecutionServiceImpl;

public class ResultFormatter
extends AsyncEventListener<QueryExecuted> {
    public static final Log LOG = LogFactory.getLog(ResultFormatter.class);
    QueryExecutionServiceImpl queryService;

    public ResultFormatter(QueryExecutionServiceImpl queryService) {
        this.queryService = queryService;
    }

    public void process(QueryExecuted event) {
        this.formatOutput(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatOutput(QueryExecuted event) {
        block15: {
            QueryHandle queryHandle = event.getQueryHandle();
            QueryContext ctx = this.queryService.getQueryContext(queryHandle);
            try {
                if (!ctx.isPersistent()) {
                    LOG.info((Object)("No result formatting required for query " + queryHandle));
                    return;
                }
                if (!ctx.isResultAvailableInDriver()) break block15;
                LOG.info((Object)("Result formatter for " + queryHandle));
                LensResultSet resultSet = this.queryService.getDriverResultset(queryHandle);
                boolean isPersistedInDriver = resultSet instanceof PersistentResultSet;
                if (isPersistedInDriver) {
                    Path persistedDirectory = new Path(ctx.getHdfsoutPath());
                    FileSystem fs = persistedDirectory.getFileSystem(ctx.getConf());
                    long size = fs.getContentSummary(persistedDirectory).getLength();
                    long threshold = ctx.getConf().getLong("lens.query.result.size.format.threshold", 0x280000000L);
                    LOG.info((Object)(" size :" + size + " threshold:" + threshold));
                    if (size > threshold) {
                        LOG.warn((Object)("Persisted result size more than the threshold, size:" + size + " and threshold:" + threshold + "; Skipping formatter"));
                        this.queryService.setSuccessState(ctx);
                        return;
                    }
                }
                this.createAndSetFormatter(ctx, isPersistedInDriver);
                QueryOutputFormatter formatter = ctx.getQueryOutputFormatter();
                try {
                    formatter.init(ctx, resultSet.getMetadata());
                    if (ctx.getConf().getBoolean("lens.query.output.write.header", false)) {
                        formatter.writeHeader();
                    }
                    if (isPersistedInDriver) {
                        LOG.info((Object)("Result formatter for " + queryHandle + " in persistent result"));
                        Path persistedDirectory = new Path(ctx.getHdfsoutPath());
                        ((PersistedOutputFormatter)formatter).addRowsFromPersistedPath(persistedDirectory);
                    } else {
                        LOG.info((Object)("Result formatter for " + queryHandle + " in inmemory result"));
                        InMemoryResultSet inmemory = (InMemoryResultSet)resultSet;
                        while (inmemory.hasNext()) {
                            ((InMemoryOutputFormatter)formatter).writeRow(inmemory.next());
                        }
                    }
                    if (ctx.getConf().getBoolean("lens.query.output.write.footer", false)) {
                        formatter.writeFooter();
                    }
                    formatter.commit();
                }
                finally {
                    formatter.close();
                }
                this.queryService.setSuccessState(ctx);
                LOG.info((Object)("Result formatter has completed. Final path:" + formatter.getFinalOutputPath()));
            }
            catch (Exception e) {
                MetricsService metricsService = (MetricsService)LensServices.get().getService("metrics");
                metricsService.incrCounter(ResultFormatter.class, "formatting-errors");
                LOG.warn((Object)("Exception while formatting result for " + queryHandle), (Throwable)e);
                try {
                    this.queryService.setFailedStatus(ctx, "Result formatting failed!", e.getLocalizedMessage());
                }
                catch (LensException e1) {
                    LOG.error((Object)("Exception while setting failure for " + queryHandle), (Throwable)e1);
                }
            }
        }
    }

    void createAndSetFormatter(QueryContext ctx, boolean isPersistedInDriver) throws LensException {
        if (ctx.getQueryOutputFormatter() == null && ctx.isPersistent()) {
            QueryOutputFormatter formatter;
            try {
                formatter = isPersistedInDriver ? (QueryOutputFormatter)ReflectionUtils.newInstance((Class)ctx.getConf().getClass("lens.query.output.formatter", Class.forName("org.apache.lens.lib.query.FilePersistentFormatter"), PersistedOutputFormatter.class), (Configuration)ctx.getConf()) : (QueryOutputFormatter)ReflectionUtils.newInstance((Class)ctx.getConf().getClass("lens.query.output.formatter", Class.forName("org.apache.lens.lib.query.FileSerdeFormatter"), InMemoryOutputFormatter.class), (Configuration)ctx.getConf());
            }
            catch (ClassNotFoundException e) {
                throw new LensException((Throwable)e);
            }
            LOG.info((Object)("Created result formatter:" + formatter.getClass().getCanonicalName()));
            ctx.setQueryOutputFormatter(formatter);
        }
    }
}

