/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import org.apache.lens.api.LensException;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.api.events.AsyncEventListener;
import org.apache.lens.server.api.events.LensEvent;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.api.query.QueryContext;
import org.apache.lens.server.api.query.QueryEnded;
import org.apache.lens.server.query.QueryExecutionServiceImpl;
import org.apache.lens.server.stats.event.query.QueryDriverStatistics;
import org.apache.lens.server.stats.event.query.QueryExecutionStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionStatisticsGenerator
extends AsyncEventListener<QueryEnded> {
    private static final Logger LOG = LoggerFactory.getLogger(QueryExecutionStatisticsGenerator.class);
    private final QueryExecutionServiceImpl queryService;
    private final LensEventService eventService;

    public QueryExecutionStatisticsGenerator(QueryExecutionServiceImpl queryService, LensEventService eventService) {
        this.queryService = queryService;
        this.eventService = eventService;
    }

    public void process(QueryEnded ended) {
        if (ended.getCurrentValue() == QueryStatus.Status.CLOSED) {
            return;
        }
        QueryHandle handle = ended.getQueryHandle();
        QueryExecutionStatistics event = new QueryExecutionStatistics(System.currentTimeMillis());
        QueryContext ctx = this.queryService.getQueryContext(handle);
        if (ctx == null) {
            LOG.warn("Could not find the context for " + handle + " for event:" + ended.getCurrentValue() + ". No stat generated");
            return;
        }
        event.setEndTime(ctx.getEndTime());
        event.setStartTime(ctx.getLaunchTime());
        event.setStatus(ctx.getStatus());
        event.setCause(ended.getCause() != null ? ended.getCause() : "");
        event.setResult(ctx.getResultSetPath());
        event.setUserQuery(ctx.getUserQuery());
        event.setSessionId(ctx.getLensSessionIdentifier());
        event.setHandle(ctx.getQueryHandle().toString());
        event.setSubmitter(ctx.getSubmittedUser());
        event.setClusterUser(ctx.getClusterUser());
        event.setSubmissionTime(ctx.getSubmissionTime());
        QueryDriverStatistics driverStats = new QueryDriverStatistics();
        driverStats.setDriverQuery(ctx.getSelectedDriverQuery());
        driverStats.setStartTime(ctx.getDriverStatus().getDriverStartTime());
        driverStats.setEndTime(ctx.getDriverStatus().getDriverStartTime());
        event.setDriverStats(driverStats);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying Statistics " + (Object)((Object)event));
            }
            this.eventService.notifyEvent((LensEvent)event);
        }
        catch (LensException e) {
            LOG.warn("Unable to notify Execution statistics", (Throwable)e);
        }
    }
}

