/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.Type;
import org.apache.hive.service.cli.TypeDescriptor;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.query.LensPreparedQuery;
import org.apache.lens.api.query.LensQuery;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryHandleWithResultSet;
import org.apache.lens.api.query.QueryPlan;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QueryResult;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.api.query.SubmitOp;
import org.apache.lens.driver.cube.RewriteUtil;
import org.apache.lens.driver.hive.HiveDriver;
import org.apache.lens.server.LensService;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.driver.DriverEvent;
import org.apache.lens.server.api.driver.DriverSelector;
import org.apache.lens.server.api.driver.DriverSessionStarted;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.driver.LensResultSet;
import org.apache.lens.server.api.driver.LensResultSetMetadata;
import org.apache.lens.server.api.driver.MinQueryCostSelector;
import org.apache.lens.server.api.driver.PersistentResultSet;
import org.apache.lens.server.api.driver.QueryCompletionListener;
import org.apache.lens.server.api.events.LensEvent;
import org.apache.lens.server.api.events.LensEventListener;
import org.apache.lens.server.api.events.LensEventService;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.api.query.AbstractQueryContext;
import org.apache.lens.server.api.query.DriverSelectorQueryContext;
import org.apache.lens.server.api.query.ExplainQueryContext;
import org.apache.lens.server.api.query.FinishedLensQuery;
import org.apache.lens.server.api.query.PreparedQueryContext;
import org.apache.lens.server.api.query.QueryAccepted;
import org.apache.lens.server.api.query.QueryAcceptor;
import org.apache.lens.server.api.query.QueryCancelled;
import org.apache.lens.server.api.query.QueryClosed;
import org.apache.lens.server.api.query.QueryContext;
import org.apache.lens.server.api.query.QueryEnded;
import org.apache.lens.server.api.query.QueryExecuted;
import org.apache.lens.server.api.query.QueryExecutionService;
import org.apache.lens.server.api.query.QueryFailed;
import org.apache.lens.server.api.query.QueryLaunched;
import org.apache.lens.server.api.query.QueryQueued;
import org.apache.lens.server.api.query.QueryRejected;
import org.apache.lens.server.api.query.QueryRunning;
import org.apache.lens.server.api.query.QuerySuccess;
import org.apache.lens.server.api.query.StatusChange;
import org.apache.lens.server.query.LensPersistentResult;
import org.apache.lens.server.query.LensServerDAO;
import org.apache.lens.server.query.QueryEndNotifier;
import org.apache.lens.server.query.QueryExecutionStatisticsGenerator;
import org.apache.lens.server.query.ResultFormatter;
import org.apache.lens.server.session.LensSessionImpl;
import org.apache.lens.server.stats.StatisticsService;
import org.apache.lens.server.util.UtilityMethods;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;

public class QueryExecutionServiceImpl
extends LensService
implements QueryExecutionService {
    public static final Log LOG = LogFactory.getLog(QueryExecutionServiceImpl.class);
    public static final String PREPARED_QUERIES_COUNTER = "prepared-queries";
    public static final String QUERY_SUBMITTER_COUNTER = "query-submitter-errors";
    public static final String STATUS_UPDATE_COUNTER = "status-update-errors";
    public static final String QUERY_PURGER_COUNTER = "query-purger-errors";
    public static final String PREPARED_QUERY_PURGER_COUNTER = "prepared-query-purger-errors";
    private static long millisInWeek = 604800000L;
    public static final String NAME = "query";
    private static final ObjectMapper mapper = new ObjectMapper();
    private PriorityBlockingQueue<QueryContext> acceptedQueries = new PriorityBlockingQueue();
    private List<QueryContext> launchedQueries = new ArrayList<QueryContext>();
    private DelayQueue<FinishedQuery> finishedQueries = new DelayQueue();
    private DelayQueue<PreparedQueryContext> preparedQueryQueue = new DelayQueue();
    private Map<QueryPrepareHandle, PreparedQueryContext> preparedQueries = new HashMap<QueryPrepareHandle, PreparedQueryContext>();
    private ConcurrentMap<QueryHandle, QueryContext> allQueries = new ConcurrentHashMap<QueryHandle, QueryContext>();
    private Configuration conf;
    private final QuerySubmitter querySubmitterRunnable = new QuerySubmitter();
    protected final Thread querySubmitter = new Thread((Runnable)this.querySubmitterRunnable, "QuerySubmitter");
    private final Thread statusPoller = new Thread((Runnable)new StatusPoller(), "StatusPoller");
    private final Thread queryPurger = new Thread((Runnable)new QueryPurger(), "QueryPurger");
    private final Thread prepareQueryPurger = new Thread((Runnable)new PreparedQueryPurger(), "PrepareQueryPurger");
    private List<QueryAcceptor> queryAcceptors = new ArrayList<QueryAcceptor>();
    private final Map<String, LensDriver> drivers = new HashMap<String, LensDriver>();
    private DriverSelector driverSelector;
    private Map<QueryHandle, LensResultSet> resultSets = new HashMap<QueryHandle, LensResultSet>();
    private LensEventService eventService;
    private MetricsService metricsService;
    private StatisticsService statisticsService;
    private int maxFinishedQueries;
    LensServerDAO lensServerDao;
    final LensEventListener<DriverEvent> driverEventListener = new LensEventListener<DriverEvent>(){

        public void onEvent(DriverEvent event) {
            if (event instanceof DriverSessionStarted) {
                LOG.info((Object)("New driver event by driver " + event.getDriver()));
                QueryExecutionServiceImpl.this.handleDriverSessionStart(event);
            }
        }
    };

    public QueryExecutionServiceImpl(CLIService cliService) throws LensException {
        super(NAME, cliService);
    }

    private void initializeQueryAcceptorsAndListeners() {
        if (this.conf.getBoolean("lens.server.query.state.logger.enabled", true)) {
            this.getEventService().addListenerForType((LensEventListener)new QueryStatusLogger(), StatusChange.class);
            LOG.info((Object)"Registered query state logger");
        }
        this.getEventService().addListenerForType((LensEventListener)new ResultFormatter(this), QueryExecuted.class);
        this.getEventService().addListenerForType((LensEventListener)new QueryExecutionStatisticsGenerator(this, this.getEventService()), QueryEnded.class);
        this.getEventService().addListenerForType((LensEventListener)new QueryEndNotifier(this, this.getCliService().getHiveConf()), QueryEnded.class);
        LOG.info((Object)"Registered query result formatter");
    }

    private void loadDriversAndSelector() throws LensException {
        this.conf.get("lens.server.drivers");
        String[] driverClasses = this.conf.getStrings("lens.server.drivers");
        if (driverClasses != null) {
            for (String driverClass : driverClasses) {
                try {
                    Class<?> clazz = Class.forName(driverClass);
                    LensDriver driver = (LensDriver)clazz.newInstance();
                    driver.configure(this.conf);
                    if (driver instanceof HiveDriver) {
                        driver.registerDriverEventListener(this.driverEventListener);
                    }
                    this.drivers.put(driverClass, driver);
                    LOG.info((Object)("Driver for " + driverClass + " is loaded"));
                }
                catch (Exception e) {
                    LOG.warn((Object)("Could not load the driver:" + driverClass), (Throwable)e);
                    throw new LensException("Could not load driver " + driverClass, (Throwable)e);
                }
            }
        } else {
            throw new LensException("No drivers specified");
        }
        this.driverSelector = new MinQueryCostSelector();
    }

    protected LensEventService getEventService() {
        if (this.eventService == null) {
            this.eventService = (LensEventService)LensServices.get().getService("event");
            if (this.eventService == null) {
                throw new NullPointerException("Could not get event service");
            }
        }
        return this.eventService;
    }

    private synchronized MetricsService getMetrics() {
        if (this.metricsService == null) {
            this.metricsService = (MetricsService)LensServices.get().getService("metrics");
            if (this.metricsService == null) {
                throw new NullPointerException("Could not get metrics service");
            }
        }
        return this.metricsService;
    }

    private synchronized StatisticsService getStatisticsService() {
        if (this.statisticsService == null) {
            this.statisticsService = (StatisticsService)((Object)LensServices.get().getService("stats"));
            if (this.statisticsService == null) {
                throw new NullPointerException("Could not get statistics service");
            }
        }
        return this.statisticsService;
    }

    private void incrCounter(String counter) {
        this.getMetrics().incrCounter(QueryExecutionService.class, counter);
    }

    private void decrCounter(String counter) {
        this.getMetrics().decrCounter(QueryExecutionService.class, counter);
    }

    public void pauseQuerySubmitter() {
        this.querySubmitterRunnable.pausedForTest = true;
    }

    void setFailedStatus(QueryContext ctx, String statusMsg, String reason) throws LensException {
        QueryStatus before = ctx.getStatus();
        ctx.setStatus(new QueryStatus(0.0, QueryStatus.Status.FAILED, statusMsg, false, null, reason));
        this.updateFinishedQuery(ctx, before);
        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
    }

    private void setLaunchedStatus(QueryContext ctx) throws LensException {
        QueryStatus before = ctx.getStatus();
        ctx.setStatus(new QueryStatus(ctx.getStatus().getProgress(), QueryStatus.Status.LAUNCHED, "launched on the driver", false, null, null));
        this.launchedQueries.add(ctx);
        ctx.setLaunchTime(System.currentTimeMillis());
        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
    }

    private void setCancelledStatus(QueryContext ctx, String statusMsg) throws LensException {
        QueryStatus before = ctx.getStatus();
        ctx.setStatus(new QueryStatus(0.0, QueryStatus.Status.CANCELED, statusMsg, false, null, null));
        this.updateFinishedQuery(ctx, before);
        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
    }

    private void updateFinishedQuery(QueryContext ctx, QueryStatus before) {
        if (before != null) {
            if (before.getStatus().equals((Object)QueryStatus.Status.QUEUED)) {
                this.acceptedQueries.remove(ctx);
            } else {
                this.launchedQueries.remove(ctx);
            }
        }
        this.finishedQueries.add(new FinishedQuery(ctx));
    }

    void setSuccessState(QueryContext ctx) throws LensException {
        QueryStatus before = ctx.getStatus();
        ctx.setStatus(new QueryStatus(1.0, QueryStatus.Status.SUCCESSFUL, "Query is successful!", ctx.isResultAvailableInDriver(), null, null));
        this.updateFinishedQuery(ctx, before);
        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus(QueryHandle handle) throws LensException {
        QueryContext ctx = (QueryContext)this.allQueries.get(handle);
        if (ctx != null) {
            QueryContext queryContext = ctx;
            synchronized (queryContext) {
                QueryStatus before = ctx.getStatus();
                if (!(ctx.getStatus().getStatus().equals((Object)QueryStatus.Status.QUEUED) || ctx.getDriverStatus().isFinished() || ctx.getStatus().isFinished())) {
                    LOG.info((Object)("Updating status for " + ctx.getQueryHandle()));
                    try {
                        ctx.getSelectedDriver().updateStatus(ctx);
                        ctx.setStatus(ctx.getDriverStatus().toQueryStatus());
                    }
                    catch (LensException exc) {
                        this.setFailedStatus(ctx, "Status update failed", exc.getMessage());
                        LOG.error((Object)("Status update failed for " + handle), (Throwable)exc);
                    }
                    if (ctx.getStatus().getStatus().equals((Object)QueryStatus.Status.EXECUTED) && !ctx.isPersistent()) {
                        this.setSuccessState(ctx);
                    } else {
                        if (ctx.getStatus().isFinished()) {
                            this.updateFinishedQuery(ctx, before);
                        }
                        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
                    }
                }
            }
        }
    }

    private static StatusChange newStatusChangeEvent(QueryContext ctx, QueryStatus.Status prevState, QueryStatus.Status currState) {
        QueryHandle query = ctx.getQueryHandle();
        switch (currState) {
            case CANCELED: {
                return new QueryCancelled(ctx.getEndTime(), prevState, currState, query, ctx.getSubmittedUser(), null);
            }
            case CLOSED: {
                return new QueryClosed(ctx.getClosedTime(), prevState, currState, query, ctx.getSubmittedUser(), null);
            }
            case FAILED: {
                return new QueryFailed(ctx.getEndTime(), prevState, currState, query, ctx.getSubmittedUser(), null);
            }
            case LAUNCHED: {
                return new QueryLaunched(ctx.getLaunchTime(), prevState, currState, query);
            }
            case QUEUED: {
                return new QueryQueued(ctx.getSubmissionTime(), prevState, currState, query, ctx.getSubmittedUser());
            }
            case RUNNING: {
                return new QueryRunning(System.currentTimeMillis() - ctx.getDriverStatus().getDriverStartTime(), prevState, currState, query);
            }
            case EXECUTED: {
                return new QueryExecuted(ctx.getDriverStatus().getDriverFinishTime().longValue(), prevState, currState, query);
            }
            case SUCCESSFUL: {
                return new QuerySuccess(ctx.getEndTime(), prevState, currState, query);
            }
        }
        LOG.warn((Object)("Query " + query + " transitioned to " + currState + " state from " + prevState + " state"));
        return null;
    }

    private void fireStatusChangeEvent(QueryContext ctx, QueryStatus current, QueryStatus before) {
        if (ctx == null || current == null) {
            return;
        }
        QueryStatus.Status prevState = before.getStatus();
        QueryStatus.Status currentStatus = current.getStatus();
        if (currentStatus.equals((Object)prevState)) {
            return;
        }
        StatusChange event = QueryExecutionServiceImpl.newStatusChangeEvent(ctx, prevState, currentStatus);
        if (event != null) {
            try {
                this.getEventService().notifyEvent((LensEvent)event);
            }
            catch (LensException e) {
                LOG.warn((Object)("LensEventService encountered error while handling event: " + event.getEventId()), (Throwable)e);
            }
        }
    }

    public synchronized void init(HiveConf hiveConf) {
        super.init(hiveConf);
        this.conf = hiveConf;
        this.initializeQueryAcceptorsAndListeners();
        try {
            this.loadDriversAndSelector();
        }
        catch (LensException e) {
            throw new IllegalStateException("Could not load drivers");
        }
        this.maxFinishedQueries = this.conf.getInt("lens.server.max.finished.queries", 100);
        this.initalizeFinishedQueryStore(this.conf);
        LOG.info((Object)"Query execution service initialized");
    }

    private void initalizeFinishedQueryStore(Configuration conf) {
        this.lensServerDao = new LensServerDAO();
        this.lensServerDao.init(conf);
        try {
            this.lensServerDao.createFinishedQueriesTable();
        }
        catch (Exception e) {
            LOG.warn((Object)"Unable to create finished query table, query purger will not purge queries", (Throwable)e);
        }
        SimpleModule module = new SimpleModule("HiveColumnModule", new Version(1, 0, 0, null));
        module.addSerializer(ColumnDescriptor.class, (JsonSerializer)new JsonSerializer<ColumnDescriptor>(){

            public void serialize(ColumnDescriptor columnDescriptor, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("name", columnDescriptor.getName());
                jsonGenerator.writeStringField("comment", columnDescriptor.getComment());
                jsonGenerator.writeNumberField("position", columnDescriptor.getOrdinalPosition());
                jsonGenerator.writeStringField("type", columnDescriptor.getType().getName());
                jsonGenerator.writeEndObject();
            }
        });
        module.addDeserializer(ColumnDescriptor.class, (JsonDeserializer)new JsonDeserializer<ColumnDescriptor>(){

            public ColumnDescriptor deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
                ObjectCodec oc = jsonParser.getCodec();
                JsonNode node = oc.readTree(jsonParser);
                Type t = Type.getType((String)node.get("type").asText());
                return new ColumnDescriptor(node.get("name").asText(), node.get("comment").asText(), new TypeDescriptor(t), node.get("position").asInt());
            }
        });
        mapper.registerModule((Module)module);
    }

    @Override
    public void prepareStopping() {
        super.prepareStopping();
        this.querySubmitter.interrupt();
        this.statusPoller.interrupt();
        this.queryPurger.interrupt();
        this.prepareQueryPurger.interrupt();
    }

    public synchronized void stop() {
        super.stop();
        for (Thread th : new Thread[]{this.querySubmitter, this.statusPoller, this.queryPurger, this.prepareQueryPurger}) {
            try {
                LOG.debug((Object)("Waiting for" + th.getName()));
                th.join();
            }
            catch (InterruptedException e) {
                LOG.error((Object)("Error waiting for thread: " + th.getName()), (Throwable)e);
            }
        }
        LOG.info((Object)"Query execution service stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start() {
        ConcurrentMap<QueryHandle, QueryContext> concurrentMap = this.allQueries;
        synchronized (concurrentMap) {
            for (QueryContext ctx : this.allQueries.values()) {
                try {
                    if (sessionMap.containsKey(ctx.getLensSessionIdentifier())) {
                        ctx.setConf(this.getLensConf(this.getSessionHandle(ctx.getLensSessionIdentifier()), ctx.getLensConf()));
                    } else {
                        ctx.setConf(this.getLensConf(ctx.getLensConf()));
                    }
                    for (LensDriver driver : this.drivers.values()) {
                        if (ctx.getDriverContext() == null) continue;
                        ctx.getDriverContext().setDriverConf(driver, ctx.getConf());
                    }
                }
                catch (LensException e) {
                    LOG.error((Object)"Could not set query conf ", (Throwable)e);
                }
            }
        }
        super.start();
        this.querySubmitter.start();
        this.statusPoller.start();
        this.queryPurger.start();
        this.prepareQueryPurger.start();
    }

    private void rewriteAndSelect(AbstractQueryContext ctx) throws LensException {
        ctx.setDriverQueriesAndPlans(RewriteUtil.rewriteQuery((AbstractQueryContext)ctx));
        LensDriver driver = this.driverSelector.select(ctx, this.conf);
        ctx.setSelectedDriver(driver);
    }

    private void accept(String query, Configuration conf, SubmitOp submitOp) throws LensException {
        for (QueryAcceptor acceptor : this.queryAcceptors) {
            String cause = "";
            String rejectionCause = acceptor.accept(query, conf, submitOp);
            if (rejectionCause == null) continue;
            this.getEventService().notifyEvent((LensEvent)new QueryRejected(System.currentTimeMillis(), query, rejectionCause, null));
            throw new LensException("Query not accepted because " + cause);
        }
        this.getEventService().notifyEvent((LensEvent)new QueryAccepted(System.currentTimeMillis(), null, query, null));
    }

    private LensResultSet getResultsetFromDAO(QueryHandle queryHandle) throws LensException {
        FinishedLensQuery query = this.lensServerDao.getQuery(queryHandle.toString());
        if (query != null) {
            if (query.getResult() == null) {
                throw new NotFoundException("InMemory Query result purged " + queryHandle);
            }
            try {
                Class<?> mdKlass = Class.forName(query.getMetadataClass());
                return new LensPersistentResult((LensResultSetMetadata)mapper.readValue(query.getMetadata(), mdKlass), query.getResult(), query.getRows());
            }
            catch (Exception e) {
                throw new LensException((Throwable)e);
            }
        }
        throw new NotFoundException("Query not found: " + queryHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LensResultSet getResultset(QueryHandle queryHandle) throws LensException {
        QueryContext ctx = (QueryContext)this.allQueries.get(queryHandle);
        if (ctx == null) {
            return this.getResultsetFromDAO(queryHandle);
        }
        QueryContext queryContext = ctx;
        synchronized (queryContext) {
            if (ctx.isFinishedQueryPersisted()) {
                return this.getResultsetFromDAO(queryHandle);
            }
            LensResultSet resultSet = this.resultSets.get(queryHandle);
            if (resultSet == null) {
                if (ctx.isPersistent() && ctx.getQueryOutputFormatter() != null) {
                    this.resultSets.put(queryHandle, (LensResultSet)new LensPersistentResult(ctx.getQueryOutputFormatter().getMetadata(), ctx.getQueryOutputFormatter().getFinalOutputPath().toString(), ctx.getQueryOutputFormatter().getNumRows()));
                } else if (((QueryContext)this.allQueries.get(queryHandle)).isResultAvailableInDriver()) {
                    resultSet = ((QueryContext)this.allQueries.get(queryHandle)).getSelectedDriver().fetchResultSet((QueryContext)this.allQueries.get(queryHandle));
                    this.resultSets.put(queryHandle, resultSet);
                } else {
                    throw new NotFoundException("Result set not available for query:" + queryHandle);
                }
            }
        }
        return this.resultSets.get(queryHandle);
    }

    LensResultSet getDriverResultset(QueryHandle queryHandle) throws LensException {
        return ((QueryContext)this.allQueries.get(queryHandle)).getSelectedDriver().fetchResultSet((QueryContext)this.allQueries.get(queryHandle));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryPrepareHandle prepare(LensSessionHandle sessionHandle, String query, LensConf lensConf, String queryName) throws LensException {
        try {
            this.acquire(sessionHandle);
            PreparedQueryContext prepared = this.prepareQuery(sessionHandle, query, lensConf, SubmitOp.PREPARE);
            prepared.setQueryName(queryName);
            prepared.getSelectedDriver().prepare(prepared);
            QueryPrepareHandle queryPrepareHandle = prepared.getPrepareHandle();
            return queryPrepareHandle;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    private PreparedQueryContext prepareQuery(LensSessionHandle sessionHandle, String query, LensConf lensConf, SubmitOp op) throws LensException {
        Configuration conf = this.getLensConf(sessionHandle, lensConf);
        this.accept(query, conf, op);
        PreparedQueryContext prepared = new PreparedQueryContext(query, this.getSession(sessionHandle).getLoggedInUser(), conf, lensConf, this.drivers.values());
        this.rewriteAndSelect((AbstractQueryContext)prepared);
        this.preparedQueries.put(prepared.getPrepareHandle(), prepared);
        this.preparedQueryQueue.add(prepared);
        this.incrCounter(PREPARED_QUERIES_COUNTER);
        return prepared;
    }

    public QueryPlan explainAndPrepare(LensSessionHandle sessionHandle, String query, LensConf lensConf, String queryName) throws LensException {
        try {
            LOG.info((Object)("ExplainAndPrepare: " + sessionHandle.toString() + " query: " + query));
            this.acquire(sessionHandle);
            PreparedQueryContext prepared = this.prepareQuery(sessionHandle, query, lensConf, SubmitOp.EXPLAIN_AND_PREPARE);
            prepared.setQueryName(queryName);
            QueryPlan plan = prepared.getSelectedDriver().explainAndPrepare(prepared).toQueryPlan();
            plan.setPrepareHandle(prepared.getPrepareHandle());
            QueryPlan queryPlan = plan;
            return queryPlan;
        }
        catch (LensException e) {
            LOG.error((Object)"Explain and prepare failed", (Throwable)e);
            QueryPlan plan = e.getCause() != null && e.getCause().getMessage() != null ? new QueryPlan(true, e.getCause().getMessage()) : new QueryPlan(true, e.getMessage());
            QueryPlan queryPlan = plan;
            return queryPlan;
        }
        catch (UnsupportedEncodingException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHandle executePrepareAsync(LensSessionHandle sessionHandle, QueryPrepareHandle prepareHandle, LensConf conf, String queryName) throws LensException {
        try {
            LOG.info((Object)("ExecutePrepareAsync: " + sessionHandle.toString() + " query:" + prepareHandle.getPrepareHandleId()));
            this.acquire(sessionHandle);
            PreparedQueryContext pctx = this.getPreparedQueryContext(sessionHandle, prepareHandle);
            Configuration qconf = this.getLensConf(sessionHandle, conf);
            this.accept(pctx.getUserQuery(), qconf, SubmitOp.EXECUTE);
            QueryContext ctx = this.createContext(pctx, this.getSession(sessionHandle).getLoggedInUser(), conf, qconf);
            if (StringUtils.isNotBlank((String)queryName)) {
                ctx.setQueryName(queryName);
            } else {
                ctx.setQueryName(pctx.getQueryName());
            }
            QueryHandle queryHandle = this.executeAsyncInternal(sessionHandle, ctx);
            return queryHandle;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHandleWithResultSet executePrepare(LensSessionHandle sessionHandle, QueryPrepareHandle prepareHandle, long timeoutMillis, LensConf conf, String queryName) throws LensException {
        try {
            LOG.info((Object)("ExecutePrepare: " + sessionHandle.toString() + " query:" + prepareHandle.getPrepareHandleId() + " timeout:" + timeoutMillis));
            this.acquire(sessionHandle);
            PreparedQueryContext pctx = this.getPreparedQueryContext(sessionHandle, prepareHandle);
            Configuration qconf = this.getLensConf(sessionHandle, conf);
            QueryContext ctx = this.createContext(pctx, this.getSession(sessionHandle).getLoggedInUser(), conf, qconf);
            if (StringUtils.isNotBlank((String)queryName)) {
                ctx.setQueryName(queryName);
            } else {
                ctx.setQueryName(pctx.getQueryName());
            }
            QueryHandleWithResultSet queryHandleWithResultSet = this.executeTimeoutInternal(sessionHandle, ctx, timeoutMillis, qconf);
            return queryHandleWithResultSet;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHandle executeAsync(LensSessionHandle sessionHandle, String query, LensConf conf, String queryName) throws LensException {
        try {
            LOG.info((Object)("ExecuteAsync: " + sessionHandle.toString() + " query: " + query));
            this.acquire(sessionHandle);
            Configuration qconf = this.getLensConf(sessionHandle, conf);
            this.accept(query, qconf, SubmitOp.EXECUTE);
            QueryContext ctx = this.createContext(query, this.getSession(sessionHandle).getLoggedInUser(), conf, qconf);
            ctx.setQueryName(queryName);
            QueryHandle queryHandle = this.executeAsyncInternal(sessionHandle, ctx);
            return queryHandle;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    protected QueryContext createContext(String query, String userName, LensConf conf, Configuration qconf) throws LensException {
        QueryContext ctx = new QueryContext(query, userName, conf, qconf, this.drivers.values());
        return ctx;
    }

    protected QueryContext createContext(PreparedQueryContext pctx, String userName, LensConf conf, Configuration qconf) throws LensException {
        QueryContext ctx = new QueryContext(pctx, userName, conf, qconf);
        return ctx;
    }

    private QueryHandle executeAsyncInternal(LensSessionHandle sessionHandle, QueryContext ctx) throws LensException {
        ctx.setLensSessionIdentifier(sessionHandle.getPublicId().toString());
        QueryStatus before = ctx.getStatus();
        ctx.setStatus(new QueryStatus(0.0, QueryStatus.Status.QUEUED, "Query is queued", false, null, null));
        this.acceptedQueries.add(ctx);
        this.allQueries.put(ctx.getQueryHandle(), ctx);
        this.fireStatusChangeEvent(ctx, ctx.getStatus(), before);
        LOG.info((Object)("Returning handle " + ctx.getQueryHandle().getHandleId()));
        return ctx.getQueryHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateQueryConf(LensSessionHandle sessionHandle, QueryHandle queryHandle, LensConf newconf) throws LensException {
        try {
            LOG.info((Object)("UpdateQueryConf:" + sessionHandle.toString() + " query: " + queryHandle));
            this.acquire(sessionHandle);
            QueryContext ctx = this.getQueryContext(sessionHandle, queryHandle);
            if (ctx != null && ctx.getStatus().getStatus() == QueryStatus.Status.QUEUED) {
                ctx.updateConf(newconf.getProperties());
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateQueryConf(LensSessionHandle sessionHandle, QueryPrepareHandle prepareHandle, LensConf newconf) throws LensException {
        try {
            LOG.info((Object)("UpdatePreparedQueryConf:" + sessionHandle.toString() + " query: " + prepareHandle));
            this.acquire(sessionHandle);
            PreparedQueryContext ctx = this.getPreparedQueryContext(sessionHandle, prepareHandle);
            ctx.updateConf(newconf.getProperties());
            boolean bl = true;
            return bl;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryContext getQueryContext(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        try {
            this.acquire(sessionHandle);
            QueryContext ctx = (QueryContext)this.allQueries.get(queryHandle);
            if (ctx == null) {
                FinishedLensQuery query = this.lensServerDao.getQuery(queryHandle.toString());
                if (query == null) {
                    throw new NotFoundException("Query not found " + queryHandle);
                }
                QueryContext queryContext = query.toQueryContext(this.conf, this.drivers.values());
                return queryContext;
            }
            this.updateStatus(queryHandle);
            QueryContext queryContext = ctx;
            return queryContext;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    QueryContext getQueryContext(QueryHandle queryHandle) {
        return (QueryContext)this.allQueries.get(queryHandle);
    }

    public LensQuery getQuery(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        return this.getQueryContext(sessionHandle, queryHandle).toLensQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedQueryContext getPreparedQueryContext(LensSessionHandle sessionHandle, QueryPrepareHandle prepareHandle) throws LensException {
        try {
            this.acquire(sessionHandle);
            PreparedQueryContext ctx = this.preparedQueries.get(prepareHandle);
            if (ctx == null) {
                throw new NotFoundException("Prepared query not found " + prepareHandle);
            }
            PreparedQueryContext preparedQueryContext = ctx;
            return preparedQueryContext;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    public LensPreparedQuery getPreparedQuery(LensSessionHandle sessionHandle, QueryPrepareHandle prepareHandle) throws LensException {
        return this.getPreparedQueryContext(sessionHandle, prepareHandle).toPreparedQuery();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryHandleWithResultSet execute(LensSessionHandle sessionHandle, String query, long timeoutMillis, LensConf conf, String queryName) throws LensException {
        try {
            LOG.info((Object)("Blocking execute " + sessionHandle.toString() + " query: " + query + " timeout: " + timeoutMillis));
            this.acquire(sessionHandle);
            Configuration qconf = this.getLensConf(sessionHandle, conf);
            this.accept(query, qconf, SubmitOp.EXECUTE);
            QueryContext ctx = this.createContext(query, this.getSession(sessionHandle).getLoggedInUser(), conf, qconf);
            ctx.setQueryName(queryName);
            QueryHandleWithResultSet queryHandleWithResultSet = this.executeTimeoutInternal(sessionHandle, ctx, timeoutMillis, qconf);
            return queryHandleWithResultSet;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryHandleWithResultSet executeTimeoutInternal(LensSessionHandle sessionHandle, QueryContext ctx, long timeoutMillis, Configuration conf) throws LensException {
        QueryHandle handle = this.executeAsyncInternal(sessionHandle, ctx);
        QueryHandleWithResultSet result = new QueryHandleWithResultSet(handle);
        while (this.getQueryContext(sessionHandle, handle).getStatus().getStatus().equals((Object)QueryStatus.Status.QUEUED)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        QueryCompletionListenerImpl listener = new QueryCompletionListenerImpl(handle);
        this.getQueryContext(sessionHandle, handle).getSelectedDriver().registerForCompletionNotification(handle, timeoutMillis, (QueryCompletionListener)listener);
        try {
            QueryCompletionListenerImpl queryCompletionListenerImpl = listener;
            synchronized (queryCompletionListenerImpl) {
                listener.wait(timeoutMillis);
            }
        }
        catch (InterruptedException e) {
            LOG.info((Object)"Waiting thread interrupted");
        }
        if (this.getQueryContext(sessionHandle, handle).getStatus().isFinished()) {
            result.setResult(this.getResultset(handle).toQueryResult());
        }
        return result;
    }

    public QueryResultSetMetadata getResultSetMetadata(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        try {
            LOG.info((Object)("GetResultSetMetadata: " + sessionHandle.toString() + " query: " + queryHandle));
            this.acquire(sessionHandle);
            LensResultSet resultSet = this.getResultset(queryHandle);
            if (resultSet != null) {
                QueryResultSetMetadata queryResultSetMetadata = resultSet.getMetadata().toQueryResultSetMetadata();
                return queryResultSetMetadata;
            }
            throw new NotFoundException("Resultset metadata not found for query: (" + sessionHandle + ", " + queryHandle + ")");
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult fetchResultSet(LensSessionHandle sessionHandle, QueryHandle queryHandle, long startIndex, int fetchSize) throws LensException {
        try {
            LOG.info((Object)("FetchResultSet:" + sessionHandle.toString() + " query:" + queryHandle));
            this.acquire(sessionHandle);
            QueryResult queryResult = this.getResultset(queryHandle).toQueryResult();
            return queryResult;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        try {
            LOG.info((Object)("CloseResultSet:" + sessionHandle.toString() + " query: " + queryHandle));
            this.acquire(sessionHandle);
            this.resultSets.remove(queryHandle);
            this.getQueryContext(queryHandle).getSelectedDriver().closeResultSet(queryHandle);
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean cancelQuery(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        block9: {
            QueryContext ctx;
            block10: {
                block8: {
                    boolean bl;
                    try {
                        LOG.info((Object)("CancelQuery: " + sessionHandle.toString() + " query:" + queryHandle));
                        this.acquire(sessionHandle);
                        ctx = this.getQueryContext(sessionHandle, queryHandle);
                        if (!ctx.getStatus().isFinished()) break block8;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        this.release(sessionHandle);
                        throw throwable;
                    }
                    this.release(sessionHandle);
                    return bl;
                }
                QueryContext queryContext = ctx;
                // MONITORENTER : queryContext
                if (!ctx.getStatus().getStatus().equals((Object)QueryStatus.Status.LAUNCHED) && !ctx.getStatus().getStatus().equals((Object)QueryStatus.Status.RUNNING)) break block9;
                boolean ret = ctx.getSelectedDriver().cancelQuery(queryHandle);
                if (ret) break block10;
                boolean bl = false;
                // MONITOREXIT : queryContext
                this.release(sessionHandle);
                return bl;
            }
            this.setCancelledStatus(ctx, "Query is cancelled");
            boolean bl = true;
            // MONITOREXIT : queryContext
            this.release(sessionHandle);
            return bl;
        }
        this.release(sessionHandle);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryHandle> getAllQueries(LensSessionHandle sessionHandle, String state, String userName, String queryName, long fromDate, long toDate) throws LensException {
        this.validateTimeRange(fromDate, toDate);
        userName = UtilityMethods.removeDomain(userName);
        try {
            this.acquire(sessionHandle);
            QueryStatus.Status status = null;
            try {
                status = StringUtils.isBlank((String)state) ? null : QueryStatus.Status.valueOf((String)state);
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException("Bad state argument passed, possible values are " + QueryStatus.Status.values(), (Throwable)e);
            }
            boolean filterByStatus = status != null;
            queryName = queryName.toLowerCase();
            boolean filterByQueryName = StringUtils.isNotBlank((String)queryName);
            if (StringUtils.isBlank((String)userName)) {
                userName = this.getSession(sessionHandle).getLoggedInUser();
            }
            ArrayList<QueryHandle> all = new ArrayList<QueryHandle>(this.allQueries.keySet());
            Iterator itr = all.iterator();
            while (itr.hasNext()) {
                QueryHandle q = (QueryHandle)itr.next();
                QueryContext context = (QueryContext)this.allQueries.get(q);
                long querySubmitTime = context.getSubmissionTime();
                if (!(filterByStatus && status != context.getStatus().getStatus() || filterByQueryName && !context.getQueryName().toLowerCase().contains(queryName) || !"all".equalsIgnoreCase(userName) && !userName.equalsIgnoreCase(context.getSubmittedUser()) || fromDate > querySubmitTime) && querySubmitTime <= toDate) continue;
                itr.remove();
            }
            if (status == null || status == QueryStatus.Status.CANCELED || status == QueryStatus.Status.SUCCESSFUL || status == QueryStatus.Status.FAILED) {
                List<QueryHandle> persistedQueries;
                if ("all".equalsIgnoreCase(userName)) {
                    userName = null;
                }
                if ((persistedQueries = this.lensServerDao.findFinishedQueries(state, userName, queryName, fromDate, toDate)) != null && !persistedQueries.isEmpty()) {
                    LOG.info((Object)("Adding persisted queries " + persistedQueries.size()));
                    all.addAll(persistedQueries);
                }
            }
            ArrayList<QueryHandle> arrayList = all;
            return arrayList;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QueryPrepareHandle> getAllPreparedQueries(LensSessionHandle sessionHandle, String user, String queryName, long fromDate, long toDate) throws LensException {
        this.validateTimeRange(fromDate, toDate);
        user = UtilityMethods.removeDomain(user);
        try {
            this.acquire(sessionHandle);
            ArrayList<QueryPrepareHandle> allPrepared = new ArrayList<QueryPrepareHandle>(this.preparedQueries.keySet());
            Iterator itr = allPrepared.iterator();
            while (itr.hasNext()) {
                long queryPrepTime;
                QueryPrepareHandle q = (QueryPrepareHandle)itr.next();
                PreparedQueryContext preparedQueryContext = this.preparedQueries.get(q);
                if (StringUtils.isNotBlank((String)user) && ("all".equalsIgnoreCase(user) || user.equalsIgnoreCase(preparedQueryContext.getPreparedUser())) || StringUtils.isNotBlank((String)queryName) && preparedQueryContext.getQueryName().toLowerCase().contains(queryName.toLowerCase()) || fromDate <= (queryPrepTime = preparedQueryContext.getPreparedTime().getTime()) && queryPrepTime <= toDate) continue;
                itr.remove();
            }
            ArrayList<QueryPrepareHandle> arrayList = allPrepared;
            return arrayList;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    private void validateTimeRange(long fromDate, long toDate) {
        if (fromDate >= toDate) {
            throw new BadRequestException("Invalid time range: [" + fromDate + ", " + toDate + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destroyPrepared(LensSessionHandle sessionHandle, QueryPrepareHandle prepared) throws LensException {
        try {
            LOG.info((Object)("DestroyPrepared: " + sessionHandle.toString() + " query:" + prepared));
            this.acquire(sessionHandle);
            this.destroyPreparedQuery(this.getPreparedQueryContext(sessionHandle, prepared));
            boolean bl = true;
            return bl;
        }
        finally {
            this.release(sessionHandle);
        }
    }

    private void destroyPreparedQuery(PreparedQueryContext ctx) throws LensException {
        ctx.getSelectedDriver().closePreparedQuery(ctx.getPrepareHandle());
        this.preparedQueries.remove(ctx.getPrepareHandle());
        this.preparedQueryQueue.remove(ctx);
        this.decrCounter(PREPARED_QUERIES_COUNTER);
    }

    public QueryPlan explain(LensSessionHandle sessionHandle, String query, LensConf lensConf) throws LensException {
        try {
            LOG.info((Object)("Explain: " + sessionHandle.toString() + " query:" + query));
            this.acquire(sessionHandle);
            Configuration qconf = this.getLensConf(sessionHandle, lensConf);
            ExplainQueryContext explainQueryContext = new ExplainQueryContext(query, this.getSession(sessionHandle).getLoggedInUser(), lensConf, qconf, this.drivers.values());
            this.accept(query, qconf, SubmitOp.EXPLAIN);
            explainQueryContext.setDriverQueriesAndPlans(RewriteUtil.rewriteQuery((AbstractQueryContext)explainQueryContext));
            explainQueryContext.setSelectedDriver(this.driverSelector.select((AbstractQueryContext)explainQueryContext, qconf));
            QueryPlan queryPlan = explainQueryContext.getSelectedDriverQueryPlan().toQueryPlan();
            return queryPlan;
        }
        catch (LensException e) {
            LOG.error((Object)"Error during explain :", (Throwable)e);
            QueryPlan plan = e.getCause() != null && e.getCause().getMessage() != null ? new QueryPlan(true, e.getCause().getMessage()) : new QueryPlan(true, e.getMessage());
            QueryPlan queryPlan = plan;
            return queryPlan;
        }
        catch (UnsupportedEncodingException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addResource(LensSessionHandle sessionHandle, String type, String path) throws LensException {
        try {
            this.acquire(sessionHandle);
            String command = "add " + type.toLowerCase() + " " + path;
            for (LensDriver driver : this.drivers.values()) {
                if (!(driver instanceof HiveDriver)) continue;
                driver.execute(this.createResourceQuery(command, sessionHandle, driver));
            }
        }
        finally {
            this.release(sessionHandle);
        }
    }

    private QueryContext createResourceQuery(String command, LensSessionHandle sessionHandle, LensDriver driver) throws LensException {
        LensConf qconf = new LensConf();
        qconf.addProperty("lens.query.enable.persistent.resultset.indriver", "false");
        QueryContext addQuery = QueryContext.createContextWithSingleDriver((String)command, (String)this.getSession(sessionHandle).getLoggedInUser(), (LensConf)qconf, (Configuration)this.getLensConf(sessionHandle, qconf), (LensDriver)driver, (String)sessionHandle.getPublicId().toString());
        return addQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteResource(LensSessionHandle sessionHandle, String type, String path) throws LensException {
        try {
            this.acquire(sessionHandle);
            String command = "delete " + type.toLowerCase() + " " + path;
            for (LensDriver driver : this.drivers.values()) {
                if (!(driver instanceof HiveDriver)) continue;
                driver.execute(this.createResourceQuery(command, sessionHandle, driver));
            }
        }
        finally {
            this.release(sessionHandle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        super.readExternal(in);
        Map<String, LensDriver> map = this.drivers;
        synchronized (map) {
            int numDrivers = in.readInt();
            for (i = 0; i < numDrivers; ++i) {
                String driverClsName = in.readUTF();
                LensDriver driver = this.drivers.get(driverClsName);
                if (driver == null) {
                    try {
                        Class<?> driverCls = Class.forName(driverClsName);
                        driver = (LensDriver)driverCls.newInstance();
                        driver.configure(this.conf);
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Could not instantiate driver:" + driverClsName));
                        throw new IOException(e);
                    }
                    LOG.info((Object)("Driver state for " + driverClsName + " will be ignored"));
                }
                driver.readExternal(in);
            }
        }
        map = this.allQueries;
        synchronized (map) {
            int numQueries = in.readInt();
            for (i = 0; i < numQueries; ++i) {
                QueryContext ctx = (QueryContext)in.readObject();
                DriverSelectorQueryContext driverCtx = new DriverSelectorQueryContext(ctx.getUserQuery(), new Configuration(), this.drivers.values());
                ctx.setDriverContext(driverCtx);
                boolean driverAvailable = in.readBoolean();
                if (driverAvailable) {
                    String clsName = in.readUTF();
                    ctx.getDriverContext().setSelectedDriver(this.drivers.get(clsName));
                }
                this.allQueries.put(ctx.getQueryHandle(), ctx);
            }
            for (QueryContext ctx : this.allQueries.values()) {
                switch (ctx.getStatus().getStatus()) {
                    case QUEUED: 
                    case NEW: {
                        this.acceptedQueries.add(ctx);
                        break;
                    }
                    case LAUNCHED: 
                    case RUNNING: {
                        this.launchedQueries.add(ctx);
                        break;
                    }
                    case CANCELED: 
                    case FAILED: 
                    case SUCCESSFUL: {
                        this.updateFinishedQuery(ctx, null);
                        break;
                    }
                    case CLOSED: {
                        this.allQueries.remove(ctx.getQueryHandle());
                    }
                }
            }
            LOG.info((Object)("Recovered " + this.allQueries.size() + " queries"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Map<String, LensDriver> map = this.drivers;
        synchronized (map) {
            out.writeInt(this.drivers.size());
            for (LensDriver driver : this.drivers.values()) {
                out.writeUTF(driver.getClass().getName());
                driver.writeExternal(out);
            }
        }
        map = this.allQueries;
        synchronized (map) {
            out.writeInt(this.allQueries.size());
            for (QueryContext ctx : this.allQueries.values()) {
                out.writeObject(ctx);
                boolean isDriverAvailable = ctx.getSelectedDriver() != null;
                out.writeBoolean(isDriverAvailable);
                if (!isDriverAvailable) continue;
                out.writeUTF(ctx.getSelectedDriver().getClass().getName());
            }
        }
        LOG.info((Object)("Persisted " + this.allQueries.size() + " queries"));
    }

    private void pipe(InputStream is, OutputStream os) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        while ((n = is.read(buffer)) > -1) {
            os.write(buffer, 0, n);
            os.flush();
        }
    }

    public Response getHttpResultSet(LensSessionHandle sessionHandle, QueryHandle queryHandle) throws LensException {
        final QueryContext ctx = this.getQueryContext(sessionHandle, queryHandle);
        LensResultSet result = this.getResultset(queryHandle);
        if (result instanceof LensPersistentResult) {
            final Path resultPath = new Path(((PersistentResultSet)result).getOutputPath());
            try {
                FileSystem fs = resultPath.getFileSystem(this.conf);
                if (fs.isDirectory(resultPath)) {
                    throw new NotFoundException("Http result not available for query:" + queryHandle.toString());
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Unable to get status for Result Directory", (Throwable)e);
                throw new NotFoundException("Http result not available for query:" + queryHandle.toString());
            }
            String resultFSReadUrl = ctx.getConf().get("lens.query.result.fs.read.url");
            if (resultFSReadUrl != null) {
                try {
                    URI resultReadPath = new URI(resultFSReadUrl + resultPath.toUri().getPath() + "?op=OPEN&user.name=" + this.getSession(sessionHandle).getClusterUser());
                    return Response.seeOther((URI)resultReadPath).header("content-disposition", (Object)("attachment; filename = " + resultPath.getName())).type("application/octet-stream").build();
                }
                catch (URISyntaxException e) {
                    throw new LensException((Throwable)e);
                }
            }
            StreamingOutput stream = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(OutputStream os) throws IOException {
                    FSDataInputStream fin = null;
                    try {
                        FileSystem fs = resultPath.getFileSystem(ctx.getConf());
                        fin = fs.open(resultPath);
                        QueryExecutionServiceImpl.this.pipe((InputStream)fin, os);
                    }
                    finally {
                        if (fin != null) {
                            fin.close();
                        }
                    }
                }
            };
            return Response.ok((Object)stream).header("content-disposition", (Object)("attachment; filename = " + resultPath.getName())).type("application/octet-stream").build();
        }
        throw new NotFoundException("Http result not available for query:" + queryHandle.toString());
    }

    public void closeDriverSessions(LensSessionHandle sessionHandle) {
        for (LensDriver driver : this.drivers.values()) {
            if (!(driver instanceof HiveDriver)) continue;
            ((HiveDriver)driver).closeSession(sessionHandle);
        }
    }

    @Override
    public void closeSession(LensSessionHandle sessionHandle) throws LensException {
        super.closeSession(sessionHandle);
        this.closeDriverSessions(sessionHandle);
    }

    Collection<LensDriver> getDrivers() {
        return this.drivers.values();
    }

    public long getQueuedQueriesCount() {
        return this.acceptedQueries.size();
    }

    public long getRunningQueriesCount() {
        return this.launchedQueries.size();
    }

    public long getFinishedQueriesCount() {
        return this.finishedQueries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDriverSessionStart(DriverEvent event) {
        DriverSessionStarted sessionStarted = (DriverSessionStarted)event;
        if (!(event.getDriver() instanceof HiveDriver)) {
            return;
        }
        HiveDriver hiveDriver = (HiveDriver)event.getDriver();
        String lensSession = sessionStarted.getLensSessionID();
        LensSessionHandle sessionHandle = this.getSessionHandle(lensSession);
        if (sessionHandle == null) {
            LOG.warn((Object)("Lens session went away for sessionid:" + lensSession));
            return;
        }
        try {
            LensSessionImpl session = this.getSession(sessionHandle);
            this.acquire(sessionHandle);
            List<LensSessionImpl.ResourceEntry> resources = session.getLensSessionPersistInfo().getResources();
            if (resources != null && !resources.isEmpty()) {
                for (LensSessionImpl.ResourceEntry resource : resources) {
                    LOG.info((Object)("Restoring resource " + resource + " for session " + lensSession));
                    String command = "add " + resource.getType().toLowerCase() + " " + resource.getLocation();
                    try {
                        hiveDriver.execute(this.createResourceQuery(command, sessionHandle, (LensDriver)hiveDriver));
                        resource.restoredResource();
                        LOG.info((Object)("Restored resource " + resource + " for session " + lensSession));
                    }
                    catch (Exception exc) {
                        LOG.error((Object)("Unable to add resource " + resource + " for session " + lensSession), (Throwable)exc);
                    }
                }
            } else {
                LOG.info((Object)("No resources to restore for session " + lensSession));
            }
        }
        catch (Exception e) {
            LOG.warn((Object)("Lens session went away! " + lensSession + " driver session: " + ((DriverSessionStarted)event).getDriverSessionID()), (Throwable)e);
        }
        finally {
            this.release(sessionHandle);
        }
    }

    class QueryCompletionListenerImpl
    implements QueryCompletionListener {
        boolean succeeded = false;
        QueryHandle handle;

        QueryCompletionListenerImpl(QueryHandle handle) {
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCompletion(QueryHandle handle) {
            QueryCompletionListenerImpl queryCompletionListenerImpl = this;
            synchronized (queryCompletionListenerImpl) {
                this.succeeded = true;
                LOG.info((Object)("Query " + handle + " with time out succeeded"));
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onError(QueryHandle handle, String error) {
            QueryCompletionListenerImpl queryCompletionListenerImpl = this;
            synchronized (queryCompletionListenerImpl) {
                this.succeeded = false;
                LOG.info((Object)("Query " + handle + " with time out failed"));
                this.notify();
            }
        }
    }

    private class PreparedQueryPurger
    implements Runnable {
        private PreparedQueryPurger() {
        }

        @Override
        public void run() {
            LOG.info((Object)"Starting Prepared Query purger thread");
            while (!QueryExecutionServiceImpl.this.stopped && !QueryExecutionServiceImpl.this.prepareQueryPurger.isInterrupted()) {
                try {
                    PreparedQueryContext prepared = (PreparedQueryContext)QueryExecutionServiceImpl.this.preparedQueryQueue.take();
                    QueryExecutionServiceImpl.this.destroyPreparedQuery(prepared);
                    LOG.info((Object)("Purged prepared query: " + prepared.getPrepareHandle()));
                }
                catch (LensException e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.PREPARED_QUERY_PURGER_COUNTER);
                    LOG.error((Object)"Error closing prepared query ", (Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"PreparedQueryPurger has been interrupted, exiting");
                    return;
                }
                catch (Exception e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.PREPARED_QUERY_PURGER_COUNTER);
                    LOG.error((Object)"Error in prepared query purger", (Throwable)e);
                }
            }
            LOG.info((Object)"PreparedQueryPurger exited");
        }
    }

    private class QueryPurger
    implements Runnable {
        private QueryPurger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)"Starting Query purger thread");
            while (!QueryExecutionServiceImpl.this.stopped && !QueryExecutionServiceImpl.this.queryPurger.isInterrupted()) {
                FinishedQuery finished = null;
                try {
                    finished = (FinishedQuery)QueryExecutionServiceImpl.this.finishedQueries.take();
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"QueryPurger has been interrupted, exiting");
                    return;
                }
                try {
                    LensResultSet set;
                    FinishedLensQuery finishedQuery = new FinishedLensQuery(finished.getCtx());
                    if (finished.ctx.getStatus().getStatus() == QueryStatus.Status.SUCCESSFUL && finished.ctx.getStatus().isResultSetAvailable() && (set = QueryExecutionServiceImpl.this.getResultset(finished.getCtx().getQueryHandle())) != null && PersistentResultSet.class.isAssignableFrom(set.getClass())) {
                        LensResultSetMetadata metadata = set.getMetadata();
                        String outputPath = ((PersistentResultSet)set).getOutputPath();
                        int rows = set.size();
                        finishedQuery.setMetadataClass(metadata.getClass().getName());
                        finishedQuery.setResult(outputPath);
                        finishedQuery.setMetadata(mapper.writeValueAsString((Object)metadata));
                        finishedQuery.setRows(rows);
                    }
                    try {
                        QueryExecutionServiceImpl.this.lensServerDao.insertFinishedQuery(finishedQuery);
                        LOG.info((Object)("Saved query " + finishedQuery.getHandle() + " to DB"));
                    }
                    catch (Exception e) {
                        LOG.warn((Object)"Exception while purging query ", (Throwable)e);
                        QueryExecutionServiceImpl.this.finishedQueries.add(finished);
                        continue;
                    }
                    QueryContext queryContext = finished.ctx;
                    synchronized (queryContext) {
                        finished.ctx.setFinishedQueryPersisted(true);
                        try {
                            if (finished.getCtx().getSelectedDriver() != null) {
                                finished.getCtx().getSelectedDriver().closeQuery(finished.getCtx().getQueryHandle());
                            }
                        }
                        catch (Exception e) {
                            LOG.warn((Object)"Exception while closing query with selected driver.", (Throwable)e);
                        }
                        QueryExecutionServiceImpl.this.allQueries.remove(finished.getCtx().getQueryHandle());
                        QueryExecutionServiceImpl.this.resultSets.remove(finished.getCtx().getQueryHandle());
                    }
                    QueryExecutionServiceImpl.this.fireStatusChangeEvent(finished.getCtx(), new QueryStatus(1.0, QueryStatus.Status.CLOSED, "Query purged", false, null, null), finished.getCtx().getStatus());
                    LOG.info((Object)("Query purged: " + finished.getCtx().getQueryHandle()));
                }
                catch (LensException e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.QUERY_PURGER_COUNTER);
                    LOG.error((Object)"Error closing  query ", (Throwable)e);
                }
                catch (Exception e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.QUERY_PURGER_COUNTER);
                    LOG.error((Object)"Error in query purger", (Throwable)e);
                }
            }
            LOG.info((Object)"QueryPurger exited");
        }
    }

    private class StatusPoller
    implements Runnable {
        long pollInterval = 1000L;

        private StatusPoller() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)"Starting Status poller thread");
            while (!QueryExecutionServiceImpl.this.stopped && !QueryExecutionServiceImpl.this.statusPoller.isInterrupted()) {
                try {
                    ArrayList launched = new ArrayList();
                    launched.addAll(QueryExecutionServiceImpl.this.launchedQueries);
                    for (QueryContext ctx : launched) {
                        if (QueryExecutionServiceImpl.this.stopped || QueryExecutionServiceImpl.this.statusPoller.isInterrupted()) {
                            return;
                        }
                        LOG.info((Object)("Polling status for " + ctx.getQueryHandle()));
                        try {
                            QueryExecutionServiceImpl.this.updateStatus(ctx.getQueryHandle());
                        }
                        catch (LensException e) {
                            LOG.error((Object)"Error updating status ", (Throwable)e);
                        }
                    }
                    Thread.sleep(this.pollInterval);
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Status poller has been interrupted, exiting");
                    return;
                }
                catch (Exception e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.STATUS_UPDATE_COUNTER);
                    LOG.error((Object)"Error in status poller", (Throwable)e);
                }
            }
            LOG.info((Object)"StatusPoller exited");
        }
    }

    private class QuerySubmitter
    implements Runnable {
        private boolean pausedForTest = false;

        private QuerySubmitter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info((Object)"Starting QuerySubmitter thread");
            while (!(this.pausedForTest || QueryExecutionServiceImpl.this.stopped || QueryExecutionServiceImpl.this.querySubmitter.isInterrupted())) {
                try {
                    QueryContext ctx;
                    QueryContext queryContext = ctx = (QueryContext)QueryExecutionServiceImpl.this.acceptedQueries.take();
                    synchronized (queryContext) {
                        if (ctx.getStatus().getStatus().equals((Object)QueryStatus.Status.QUEUED)) {
                            LOG.info((Object)("Launching query:" + ctx.getUserQuery()));
                            try {
                                QueryExecutionServiceImpl.this.acquire(ctx.getLensSessionIdentifier());
                                if (!ctx.isSelectedDriverQueryExplicitlySet()) {
                                    QueryExecutionServiceImpl.this.rewriteAndSelect((AbstractQueryContext)ctx);
                                } else {
                                    LOG.info((Object)"Submitting to already selected driver");
                                }
                                ctx.getSelectedDriver().executeAsync(ctx);
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Error launching query " + ctx.getQueryHandle()), (Throwable)e);
                                String reason = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
                                QueryExecutionServiceImpl.this.setFailedStatus(ctx, "Launching query failed", reason);
                                continue;
                            }
                            finally {
                                QueryExecutionServiceImpl.this.release(ctx.getLensSessionIdentifier());
                            }
                            QueryExecutionServiceImpl.this.setLaunchedStatus(ctx);
                            LOG.info((Object)("Launched query " + ctx.getQueryHandle()));
                        }
                    }
                }
                catch (InterruptedException e) {
                    LOG.info((Object)"Query Submitter has been interrupted, exiting");
                    return;
                }
                catch (Exception e) {
                    QueryExecutionServiceImpl.this.incrCounter(QueryExecutionServiceImpl.QUERY_SUBMITTER_COUNTER);
                    LOG.error((Object)"Error in query submitter", (Throwable)e);
                }
            }
            LOG.info((Object)"QuerySubmitter exited");
        }
    }

    private class FinishedQuery
    implements Delayed {
        private final QueryContext ctx;
        private final Date finishTime;

        FinishedQuery(QueryContext ctx) {
            this.ctx = ctx;
            this.finishTime = new Date();
            ctx.setEndTime(this.finishTime.getTime());
        }

        @Override
        public int compareTo(Delayed o) {
            return (int)(this.finishTime.getTime() - ((FinishedQuery)o).finishTime.getTime());
        }

        @Override
        public long getDelay(TimeUnit units) {
            int size = QueryExecutionServiceImpl.this.finishedQueries.size();
            if (size > QueryExecutionServiceImpl.this.maxFinishedQueries) {
                return 0L;
            }
            return Integer.MAX_VALUE;
        }

        public Date getFinishTime() {
            return this.finishTime;
        }

        public QueryContext getCtx() {
            return this.ctx;
        }
    }

    public static class QueryStatusLogger
    implements LensEventListener<StatusChange> {
        public static final Log STATUS_LOG = LogFactory.getLog(QueryStatusLogger.class);

        public void onEvent(StatusChange event) throws LensException {
            STATUS_LOG.info((Object)event.toString());
        }
    }
}

