/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.query;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.lens.api.query.QueryStatus;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.events.AsyncEventListener;
import org.apache.lens.server.api.metrics.MetricsService;
import org.apache.lens.server.api.query.QueryContext;
import org.apache.lens.server.api.query.QueryEnded;
import org.apache.lens.server.query.QueryExecutionServiceImpl;

public class QueryEndNotifier
extends AsyncEventListener<QueryEnded> {
    private final QueryExecutionServiceImpl queryService;
    public static final Log LOG = LogFactory.getLog(QueryEndNotifier.class);
    public static final String EMAIL_ERROR_COUNTER = "email-send-errors";
    private final HiveConf conf;
    private final String from;
    private final String host;
    private final String port;
    private final int mailSmtpTimeout;
    private final int mailSmtpConnectionTimeout;

    public QueryEndNotifier(QueryExecutionServiceImpl queryService, HiveConf hiveConf) {
        this.queryService = queryService;
        this.conf = hiveConf;
        this.from = this.conf.get("lens.server.mail.from.address");
        this.host = this.conf.get("lens.server.mail.host");
        this.port = this.conf.get("lens.server.mail.port");
        this.mailSmtpTimeout = Integer.parseInt(this.conf.get("lens.server.mail.smtp.timeout", "30000"));
        this.mailSmtpConnectionTimeout = Integer.parseInt(this.conf.get("lens.server.mail.smtp.connectiontimeout", "15000"));
    }

    public void process(QueryEnded event) {
        if (event.getCurrentValue() == QueryStatus.Status.CLOSED) {
            return;
        }
        QueryContext queryContext = this.queryService.getQueryContext(event.getQueryHandle());
        if (queryContext == null) {
            LOG.warn((Object)("Could not find the context for " + event.getQueryHandle() + " for event:" + event.getCurrentValue() + ". No email generated"));
            return;
        }
        boolean whetherMailNotify = Boolean.parseBoolean(queryContext.getConf().get("lens.query.enable.mail.notify", "false"));
        if (!whetherMailNotify) {
            return;
        }
        String queryName = queryContext.getQueryName();
        queryName = queryName == null ? "" : queryName;
        String mailSubject = "Query " + queryName + " " + queryContext.getStatus().getStatus() + ": " + event.getQueryHandle();
        String mailMessage = this.createMailMessage(queryContext);
        String to = queryContext.getSubmittedUser() + "@" + this.queryService.getServerDomain();
        String cc = queryContext.getConf().get("lens.query.result.email.cc", "");
        LOG.info((Object)("Sending completion email for query handle: " + event.getQueryHandle()));
        QueryEndNotifier.sendMail(this.host, this.port, this.from, to, cc, mailSubject, mailMessage, this.mailSmtpTimeout, this.mailSmtpConnectionTimeout);
    }

    private String createMailMessage(QueryContext queryContext) {
        StringBuilder msgBuilder = new StringBuilder();
        switch (queryContext.getStatus().getStatus()) {
            case SUCCESSFUL: {
                msgBuilder.append("Result available at ");
                String baseURI = this.conf.get("lens.server.base.url", "http://0.0.0.0:9999/lensapi");
                msgBuilder.append(baseURI);
                msgBuilder.append("queryapi/queries/");
                msgBuilder.append(queryContext.getQueryHandle());
                msgBuilder.append("/httpresultset");
                break;
            }
            case FAILED: {
                msgBuilder.append(queryContext.getStatus().getErrorMessage());
                break;
            }
        }
        return msgBuilder.toString();
    }

    public static void sendMail(String host, String port, String from, String to, String cc, String subject, String mailMessage, int mailSmtpTimeout, int mailSmtpConnectionTimeout) {
        Properties props = System.getProperties();
        props.put("mail.smtp.host", host);
        props.put("mail.smtp.port", port);
        props.put("mail.smtp.timeout", (Object)mailSmtpTimeout);
        props.put("mail.smtp.connectiontimeout", (Object)mailSmtpConnectionTimeout);
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(from));
            for (String recipient : to.trim().split("\\s*,\\s*")) {
                message.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
            }
            if (cc != null && cc.length() > 0) {
                for (String recipient : cc.trim().split("\\s*,\\s*")) {
                    message.addRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)recipient));
                }
            }
            message.setSubject(subject);
            message.setSentDate(new Date());
            MimeBodyPart messagePart = new MimeBodyPart();
            messagePart.setText(mailMessage);
            MimeMultipart multipart = new MimeMultipart();
            multipart.addBodyPart((BodyPart)messagePart);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
        }
        catch (Exception e) {
            MetricsService metricsService = (MetricsService)LensServices.get().getService("metrics");
            metricsService.incrCounter(QueryEndNotifier.class, EMAIL_ERROR_COUNTER);
            LOG.error((Object)"Error sending query end email", (Throwable)e);
        }
    }
}

