/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.metastore;

import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.lens.api.APIResult;
import org.apache.lens.api.DateTime;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.StringList;
import org.apache.lens.api.metastore.ObjectFactory;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.api.metastore.XDerivedCube;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XFlattenedColumns;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XPartitionList;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.metastore.CubeMetastoreService;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataParam;

@Path(value="metastore")
@Produces(value={"application/json", "application/xml"})
public class MetastoreResource {
    public static final Logger LOG = LogManager.getLogger(MetastoreResource.class);
    public static final APIResult SUCCESS = new APIResult(APIResult.Status.SUCCEEDED, "");
    public static final ObjectFactory xCubeObjectFactory = new ObjectFactory();

    public CubeMetastoreService getSvc() {
        return (CubeMetastoreService)LensServices.get().getService("metastore");
    }

    private void checkSessionId(LensSessionHandle sessionHandle) {
        if (sessionHandle == null) {
            throw new BadRequestException("Invalid session handle");
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return "Metastore is up";
    }

    @GET
    @Path(value="databases")
    public StringList getAllDatabases(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        List allNames;
        this.checkSessionId(sessionid);
        try {
            allNames = this.getSvc().getAllDatabases(sessionid);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return new StringList(allNames);
    }

    @GET
    @Path(value="databases/current")
    public String getDatabase(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        LOG.info((Object)"Get database");
        try {
            return this.getSvc().getCurrentDatabase(sessionid);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    @PUT
    @Path(value="databases/current")
    @Consumes(value={"application/xml", "application/json"})
    public APIResult setDatabase(@QueryParam(value="sessionid") LensSessionHandle sessionid, String dbName) {
        this.checkSessionId(sessionid);
        LOG.info((Object)("Set database:" + dbName));
        try {
            this.getSvc().setCurrentDatabase(sessionid, dbName);
        }
        catch (LensException e) {
            LOG.error((Object)"Error changing current database", (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="databases/{dbName}")
    public APIResult dropDatabase(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dbName") String dbName, @QueryParam(value="cascade") boolean cascade) {
        this.checkSessionId(sessionid);
        LOG.info((Object)("Drop database " + dbName + " cascade?" + cascade));
        try {
            this.getSvc().dropDatabase(sessionid, dbName, cascade);
        }
        catch (LensException e) {
            LOG.error((Object)("Error dropping " + dbName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @POST
    @Path(value="databases")
    public APIResult createDatabase(@QueryParam(value="sessionid") LensSessionHandle sessionid, @QueryParam(value="ignoreIfExisting") @DefaultValue(value="true") boolean ignoreIfExisting, String dbName) {
        this.checkSessionId(sessionid);
        LOG.info((Object)("Create database " + dbName + " Ignore Existing? " + ignoreIfExisting));
        try {
            this.getSvc().createDatabase(sessionid, dbName, ignoreIfExisting);
        }
        catch (LensException e) {
            LOG.error((Object)("Error creating database " + dbName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="nativetables")
    public StringList getAllNativeTables(@QueryParam(value="sessionid") LensSessionHandle sessionid, @QueryParam(value="dbOption") String dbOption, @QueryParam(value="dbName") String dbName) {
        List allNames;
        this.checkSessionId(sessionid);
        try {
            if (StringUtils.isBlank((CharSequence)dbName) && !StringUtils.isBlank((CharSequence)dbOption) && !dbOption.equalsIgnoreCase("current") && !dbOption.equalsIgnoreCase("all")) {
                throw new BadRequestException("Invalid dbOption param:" + dbOption + " Allowed values are 'current' and 'all'");
            }
            allNames = this.getSvc().getAllNativeTableNames(sessionid, dbOption, dbName);
        }
        catch (LensException e) {
            throw new WebApplicationException((Throwable)e);
        }
        return new StringList(allNames);
    }

    @GET
    @Path(value="nativetables/{tableName}")
    public JAXBElement<XNativeTable> getNativeTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="tableName") String tableName) {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXNativeTable(this.getSvc().getNativeTable(sessionid, tableName));
        }
        catch (LensException e) {
            this.checkTableNotFound(e, tableName);
            LOG.error((Object)"Error getting native table", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @GET
    @Path(value="cubes")
    public StringList getAllCubes(@QueryParam(value="sessionid") LensSessionHandle sessionid, @QueryParam(value="type") @DefaultValue(value="all") String cubeTypes) {
        this.checkSessionId(sessionid);
        try {
            if (cubeTypes.equals("all")) {
                return new StringList(this.getSvc().getAllCubeNames(sessionid));
            }
            if (cubeTypes.equals("base")) {
                return new StringList(this.getSvc().getAllBaseCubeNames(sessionid));
            }
            if (cubeTypes.equals("derived")) {
                return new StringList(this.getSvc().getAllDerivedCubeNames(sessionid));
            }
            if (cubeTypes.equals("queryable")) {
                return new StringList(this.getSvc().getAllQueryableCubeNames(sessionid));
            }
            throw new BadRequestException("Invalid type " + cubeTypes + " Accepted" + " values are 'all' or 'base' or 'derived' or 'queryable'");
        }
        catch (LensException e) {
            LOG.error((Object)"Error getting cube names", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="cubes")
    public APIResult deleteAllCubes(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        boolean failed = false;
        List cubeNames = null;
        int numDeleted = 0;
        try {
            cubeNames = this.getSvc().getAllCubeNames(sessionid);
            for (String cubeName : cubeNames) {
                this.getSvc().dropCube(sessionid, cubeName);
                ++numDeleted;
            }
        }
        catch (LensException e) {
            LOG.error((Object)"Error deleting cubes:", (Throwable)e);
            failed = true;
        }
        if (cubeNames != null && numDeleted == cubeNames.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Delete of all cubes is successful");
        }
        assert (failed);
        if (numDeleted == 0) {
            return new APIResult(APIResult.Status.FAILED, "Delete of all cubes has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Delete of all cubes is partial");
    }

    @POST
    @Path(value="cubes")
    public APIResult createNewCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, XCube cube) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().createCube(sessionid, cube);
        }
        catch (LensException e) {
            if (cube instanceof XDerivedCube) {
                this.checkTableNotFound(e, ((XDerivedCube)cube).getParent());
            }
            LOG.error((Object)("Error creating cube " + cube.getName()), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    private void checkTableNotFound(LensException e, String table) {
        HiveException hiveErr;
        if (e.getCause() instanceof HiveException && (hiveErr = (HiveException)e.getCause()).getMessage().startsWith("Could not get table")) {
            throw new NotFoundException("Table not found " + table, (Throwable)e);
        }
    }

    @PUT
    @Path(value="/cubes/{cubeName}")
    public APIResult updateCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="cubeName") String cubeName, XCube cube) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().updateCube(sessionid, cube);
        }
        catch (LensException e) {
            if (cube instanceof XDerivedCube) {
                this.checkTableNotFound(e, ((XDerivedCube)cube).getParent());
            }
            this.checkTableNotFound(e, cube.getName());
            LOG.error((Object)("Error updating cube " + cube.getName()), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/cubes/{cubeName}")
    public JAXBElement<XCube> getCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="cubeName") String cubeName) {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXCube(this.getSvc().getCube(sessionid, cubeName));
        }
        catch (LensException e) {
            this.checkTableNotFound(e, cubeName);
            LOG.error((Object)"Error getting cube", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/cubes/{cubeName}")
    public APIResult dropCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="cubeName") String cubeName) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropCube(sessionid, cubeName);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, cubeName);
            LOG.error((Object)("Error droping cube " + cubeName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="storages")
    public StringList getAllStorages(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        try {
            return new StringList(this.getSvc().getAllStorageNames(sessionid));
        }
        catch (LensException e) {
            LOG.error((Object)"Error getting storages", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="storages")
    public APIResult createNewStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, XStorage storage) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().createStorage(sessionid, storage);
        }
        catch (LensException e) {
            LOG.error((Object)("Error creating storage " + storage.getName()), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="storages")
    public APIResult deleteAllStorages(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        boolean failed = false;
        List storageNames = null;
        int numDeleted = 0;
        try {
            storageNames = this.getSvc().getAllStorageNames(sessionid);
            for (String storageName : storageNames) {
                this.getSvc().dropStorage(sessionid, storageName);
                ++numDeleted;
            }
        }
        catch (LensException e) {
            LOG.error((Object)"Error deleting storages:", (Throwable)e);
            failed = true;
        }
        if (storageNames != null && numDeleted == storageNames.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Delete of all storages is successful");
        }
        assert (failed);
        if (numDeleted == 0) {
            return new APIResult(APIResult.Status.FAILED, "Delete of all storages has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Delete of all storages is partial");
    }

    @PUT
    @Path(value="/storages/{storageName}")
    public APIResult updateStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="storageName") String storageName, XStorage storage) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().alterStorage(sessionid, storageName, storage);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, storageName);
            LOG.error((Object)("Error updating storage" + storageName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/storages/{storage}")
    public JAXBElement<XStorage> getStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="storage") String storageName) throws Exception {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXStorage(this.getSvc().getStorage(sessionid, storageName));
        }
        catch (LensException e) {
            this.checkTableNotFound(e, storageName);
            throw e;
        }
    }

    @DELETE
    @Path(value="/storages/{storage}")
    public APIResult dropStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="storage") String storageName) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropStorage(sessionid, storageName);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, storageName);
            LOG.error((Object)("Error dropping storage" + storageName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="dimensions")
    public StringList getAllDimensionNames(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        try {
            return new StringList(this.getSvc().getAllDimensionNames(sessionid));
        }
        catch (LensException e) {
            LOG.error((Object)"Error getting dimensions", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Path(value="dimensions")
    public APIResult createDimension(@QueryParam(value="sessionid") LensSessionHandle sessionid, XDimension dimension) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().createDimension(sessionid, dimension);
        }
        catch (LensException e) {
            LOG.error((Object)("Error creating dimension " + dimension.getName()), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="dimensions")
    public APIResult deleteAllDimensions(@QueryParam(value="sessionid") LensSessionHandle sessionid) {
        this.checkSessionId(sessionid);
        boolean failed = false;
        List dimNames = null;
        int numDeleted = 0;
        try {
            dimNames = this.getSvc().getAllDimensionNames(sessionid);
            for (String dimName : dimNames) {
                this.getSvc().dropStorage(sessionid, dimName);
                ++numDeleted;
            }
        }
        catch (LensException e) {
            LOG.error((Object)"Error deleting dimensions:", (Throwable)e);
            failed = true;
        }
        if (dimNames != null && numDeleted == dimNames.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Delete of all dimensions is successful");
        }
        assert (failed);
        if (numDeleted == 0) {
            return new APIResult(APIResult.Status.FAILED, "Delete of all dimensions has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Delete of all dimensions is partial");
    }

    @PUT
    @Path(value="/dimensions/{dimName}")
    public APIResult updateDimension(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimName") String dimName, XDimension dimension) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().updateDimension(sessionid, dimName, dimension);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, dimName);
            LOG.error((Object)("Error updating dimension" + dimName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/dimensions/{dimName}")
    public JAXBElement<XDimension> getDimension(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimName") String dimName) throws Exception {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXDimension(this.getSvc().getDimension(sessionid, dimName));
        }
        catch (LensException e) {
            this.checkTableNotFound(e, dimName);
            throw e;
        }
    }

    @DELETE
    @Path(value="/dimensions/{dimName}")
    public APIResult dropDimension(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimName") String dimName) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropDimension(sessionid, dimName);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, dimName);
            LOG.error((Object)("Error dropping dimName" + dimName), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/cubes/{cubeName}/facts")
    public List<XFactTable> getAllFactsOfCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="cubeName") String cubeName) throws LensException {
        this.checkSessionId(sessionid);
        try {
            return this.getSvc().getAllFactsOfCube(sessionid, cubeName);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, cubeName);
            throw exc;
        }
    }

    @GET
    @Path(value="/facts")
    public StringList getAllFacts(@QueryParam(value="sessionid") LensSessionHandle sessionid) throws LensException {
        this.checkSessionId(sessionid);
        return new StringList(this.getSvc().getAllFactNames(sessionid));
    }

    @DELETE
    @Path(value="facts")
    public APIResult deleteAllFacts(@QueryParam(value="sessionid") LensSessionHandle sessionid, @DefaultValue(value="false") @QueryParam(value="cascade") boolean cascade) {
        this.checkSessionId(sessionid);
        boolean failed = false;
        List factNames = null;
        int numDeleted = 0;
        try {
            factNames = this.getSvc().getAllCubeNames(sessionid);
            for (String factName : factNames) {
                this.getSvc().dropFactTable(sessionid, factName, cascade);
                ++numDeleted;
            }
        }
        catch (LensException e) {
            LOG.error((Object)"Error deleting cubes:", (Throwable)e);
            failed = true;
        }
        if (factNames != null && numDeleted == factNames.size()) {
            return new APIResult(APIResult.Status.SUCCEEDED, "Delete of all fact tables is successful");
        }
        assert (failed);
        if (numDeleted == 0) {
            return new APIResult(APIResult.Status.FAILED, "Delete of all fact tables has failed");
        }
        return new APIResult(APIResult.Status.PARTIAL, "Delete of all fact tables is partial");
    }

    @GET
    @Path(value="/facts/{factName}")
    public JAXBElement<XFactTable> getFactTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName) throws LensException {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXFactTable(this.getSvc().getFactTable(sessionid, factName));
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            throw exc;
        }
    }

    @Consumes(value={"multipart/form-data"})
    @POST
    @Path(value="/facts")
    public APIResult createFactTable(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="fact") XFactTable fact) throws LensException {
        this.checkSessionId(sessionid);
        try {
            LOG.info((Object)"Create fact table");
            this.getSvc().createFactTable(sessionid, fact);
        }
        catch (LensException exc) {
            LOG.error((Object)"Exception creating fact:", (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @PUT
    @Path(value="/facts/{factName}")
    public APIResult updateFactTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, XFactTable fact) throws LensException {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().updateFactTable(sessionid, fact);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error updating fact" + factName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/facts/{factName}")
    public APIResult dropFactTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @DefaultValue(value="false") @QueryParam(value="cascade") boolean cascade) throws LensException {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropFactTable(sessionid, factName, cascade);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error dropping fact" + factName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/facts/{factName}/storages")
    public StringList getStoragesOfFact(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName) throws LensException {
        this.checkSessionId(sessionid);
        try {
            return new StringList(this.getSvc().getStoragesOfFact(sessionid, factName));
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            throw new WebApplicationException((Throwable)exc);
        }
    }

    @DELETE
    @Path(value="/facts/{factName}/storages")
    public APIResult dropAllStoragesOfFact(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropAllStoragesOfFact(sessionid, factName);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error dropping storages of fact" + factName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @POST
    @Path(value="/facts/{factName}/storages")
    public APIResult addStorageToFact(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, XStorageTableElement storageTable) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().addStorageToFact(sessionid, factName, storageTable);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error adding storage to fact" + factName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/facts/{factName}/storages/{storage}")
    public APIResult dropStorageFromFact(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropStorageOfFact(sessionid, factName, storage);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error dropping storage of fact" + factName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/facts/{factName}/storages/{storage}")
    public JAXBElement<XStorageTableElement> getStorageOfFact(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage) throws LensException {
        return xCubeObjectFactory.createXStorageTableElement(this.getSvc().getStorageOfFact(sessionid, factName, storage));
    }

    @GET
    @Path(value="/facts/{factName}/storages/{storage}/partitions")
    public JAXBElement<XPartitionList> getAllPartitionsOfFactStorageByFilter(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage, @QueryParam(value="filter") String filter) throws LensException {
        this.checkSessionId(sessionid);
        try {
            List partitions = this.getSvc().getAllPartitionsOfFactStorage(sessionid, factName, storage, filter);
            XPartitionList partList = xCubeObjectFactory.createXPartitionList();
            partList.getPartition().addAll(partitions);
            return xCubeObjectFactory.createXPartitionList(partList);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            throw exc;
        }
    }

    @DELETE
    @Path(value="/facts/{factName}/storages/{storage}/partitions")
    public APIResult dropPartitionsOfFactStorageByFilter(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage, @QueryParam(value="filter") String filter) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropPartitionFromStorageByFilter(sessionid, factName, storage, filter);
        }
        catch (LensException exc) {
            LOG.warn((Object)"Got exception while dropping partition.", (Throwable)exc);
            this.checkTableNotFound(exc, factName);
            return new APIResult(APIResult.Status.PARTIAL, exc.getMessage());
        }
        return SUCCESS;
    }

    @POST
    @Path(value="/facts/{factName}/storages/{storage}/partitions")
    public APIResult addPartitionToFactStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage, XPartition partition) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().addPartitionToFactStorage(sessionid, factName, storage, partition);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, factName);
            LOG.error((Object)("Error adding partition to storage of fact" + factName + ":" + storage), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/facts/{factName}/storages/{storage}/partition")
    public APIResult dropPartitionOfFactStorageByValues(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="factName") String factName, @PathParam(value="storage") String storage, @QueryParam(value="values") String values) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropPartitionFromStorageByValues(sessionid, factName, storage, values);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, factName);
            LOG.error((Object)("Error dropping partition to storage of fact" + factName + ":" + storage), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/dimtables")
    public StringList getAllDims(@QueryParam(value="sessionid") LensSessionHandle sessionid) throws LensException {
        return new StringList(this.getSvc().getAllDimTableNames(sessionid));
    }

    @POST
    @Path(value="/dimtables")
    public APIResult createDimensionTable(@FormDataParam(value="sessionid") LensSessionHandle sessionid, @FormDataParam(value="dimensionTable") XDimensionTable dimensionTable) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().createDimensionTable(sessionid, dimensionTable);
        }
        catch (LensException exc) {
            LOG.error((Object)("Error creating cube dimension table " + dimensionTable.getTableName()), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @PUT
    @Path(value="/dimtables/{dimTableName}")
    public APIResult updateCubeDimension(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, XDimensionTable dimensionTable) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().updateDimensionTable(sessionid, dimensionTable);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, dimTableName);
            LOG.error((Object)("Error updating cube dimension table " + dimTableName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/dimtables/{dimTableName}")
    public APIResult dropDimensionTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimension, @QueryParam(value="cascade") boolean cascade) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropDimensionTable(sessionid, dimension, cascade);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, dimension);
            LOG.error((Object)("Error dropping cube dimension table " + dimension), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/dimtables/{dimTableName}")
    public JAXBElement<XDimensionTable> getDimensionTable(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName) throws LensException {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXDimensionTable(this.getSvc().getDimensionTable(sessionid, dimTableName));
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, dimTableName);
            throw exc;
        }
    }

    @GET
    @Path(value="/dimtables/{dimTableName}/storages")
    public StringList getDimensionStorages(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimension) throws LensException {
        this.checkSessionId(sessionid);
        return new StringList(this.getSvc().getDimTableStorages(sessionid, dimension));
    }

    @POST
    @Path(value="/dimtables/{dimTableName}/storages")
    public APIResult createDimensionStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, XStorageTableElement storageTbl) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().addDimTableStorage(sessionid, dimTableName, storageTbl);
        }
        catch (LensException e) {
            this.checkTableNotFound(e, dimTableName);
            LOG.error((Object)("Error creating dimension table storage " + dimTableName + ":" + storageTbl.getStorageName()), (Throwable)e);
            return new APIResult(APIResult.Status.FAILED, e.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/dimtables/{dimTableName}/storages/{storage}")
    public JAXBElement<XStorageTableElement> getStorageOfDim(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, @PathParam(value="storage") String storage) throws LensException {
        this.checkSessionId(sessionid);
        return xCubeObjectFactory.createXStorageTableElement(this.getSvc().getStorageOfDim(sessionid, dimTableName, storage));
    }

    @DELETE
    @Path(value="/dimtables/{dimTableName}/storages")
    public APIResult dropAllStoragesOfDim(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropAllStoragesOfDimTable(sessionid, dimTableName);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, dimTableName);
            LOG.error((Object)("Error dropping storages of dimension table " + dimTableName), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/dimtables/{dimTableName}/storages/{storage}")
    public APIResult dropStorageOfDim(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, @PathParam(value="storage") String storage) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropStorageOfDimTable(sessionid, dimTableName, storage);
        }
        catch (LensException exc) {
            this.checkTableNotFound(exc, dimTableName);
            LOG.error((Object)("Error dropping storage of dimension table " + dimTableName + ":" + storage), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="/dimtables/{dimTableName}/storages/{storage}/partitions")
    public JAXBElement<XPartitionList> getAllPartitionsOfDimStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimension, @PathParam(value="storage") String storage, @QueryParam(value="filter") String filter) throws LensException {
        this.checkSessionId(sessionid);
        List partitions = this.getSvc().getAllPartitionsOfDimTableStorage(sessionid, dimension, storage, filter);
        XPartitionList partList = xCubeObjectFactory.createXPartitionList();
        partList.getPartition().addAll(partitions);
        return xCubeObjectFactory.createXPartitionList(partList);
    }

    @DELETE
    @Path(value="/dimtables/{dimTableName}/storages/{storage}/partitions")
    public APIResult dropPartitionsOfDimStorageByFilter(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, @PathParam(value="storage") String storage, @QueryParam(value="filter") String filter) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropPartitionFromStorageByFilter(sessionid, dimTableName, storage, filter);
        }
        catch (LensException exc) {
            LOG.error((Object)("Error dropping partition on storage of dimension table " + dimTableName + ":" + storage), (Throwable)exc);
            return new APIResult(APIResult.Status.PARTIAL, exc.getMessage());
        }
        return SUCCESS;
    }

    @DELETE
    @Path(value="/dimtables/{dimTableName}/storages/{storage}/partition")
    public APIResult dropPartitionsOfDimStorageByValue(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, @PathParam(value="storage") String storage, @QueryParam(value="values") String values) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().dropPartitionFromStorageByValues(sessionid, dimTableName, storage, values);
        }
        catch (LensException exc) {
            LOG.error((Object)("Error dropping partitions on storage of dimension table " + dimTableName + ":" + storage), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @POST
    @Path(value="/dimtables/{dimTableName}/storages/{storage}/partitions")
    public APIResult addPartitionToDimStorage(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="dimTableName") String dimTableName, @PathParam(value="storage") String storage, XPartition partition) {
        this.checkSessionId(sessionid);
        try {
            this.getSvc().addPartitionToDimStorage(sessionid, dimTableName, storage, partition);
        }
        catch (LensException exc) {
            LOG.error((Object)("Error adding partition to storage of dimension table " + dimTableName + ":" + storage), (Throwable)exc);
            return new APIResult(APIResult.Status.FAILED, exc.getMessage());
        }
        return SUCCESS;
    }

    @GET
    @Path(value="flattened/{tableName}")
    public JAXBElement<XFlattenedColumns> getFlattenedColumns(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="tableName") String tableName) {
        this.checkSessionId(sessionid);
        try {
            return xCubeObjectFactory.createXFlattenedColumns(this.getSvc().getFlattenedColumns(sessionid, tableName));
        }
        catch (LensException exc) {
            throw new WebApplicationException((Throwable)exc);
        }
    }

    @GET
    @Path(value="/cubes/{cubeName}/latestdate")
    public DateTime getLatestDateOfCube(@QueryParam(value="sessionid") LensSessionHandle sessionid, @PathParam(value="cubeName") String cubeName, @QueryParam(value="timeDimension") String timeDimension) throws LensException, HiveException {
        this.checkSessionId(sessionid);
        try {
            return new DateTime(this.getSvc().getLatestDateOfCube(sessionid, cubeName, timeDimension));
        }
        catch (LensException exc) {
            throw new WebApplicationException((Throwable)exc);
        }
    }
}

