/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.metastore;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.NotFoundException;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.HiveSQLException;
import org.apache.lens.api.LensException;
import org.apache.lens.api.LensSessionHandle;
import org.apache.lens.api.metastore.ObjectFactory;
import org.apache.lens.api.metastore.XCube;
import org.apache.lens.api.metastore.XDerivedCube;
import org.apache.lens.api.metastore.XDimension;
import org.apache.lens.api.metastore.XDimensionTable;
import org.apache.lens.api.metastore.XFactTable;
import org.apache.lens.api.metastore.XFlattenedColumn;
import org.apache.lens.api.metastore.XFlattenedColumns;
import org.apache.lens.api.metastore.XNativeTable;
import org.apache.lens.api.metastore.XPartition;
import org.apache.lens.api.metastore.XStorage;
import org.apache.lens.api.metastore.XStorageTableElement;
import org.apache.lens.api.metastore.XUpdatePeriod;
import org.apache.lens.cube.metadata.AbstractBaseTable;
import org.apache.lens.cube.metadata.Cube;
import org.apache.lens.cube.metadata.CubeDimAttribute;
import org.apache.lens.cube.metadata.CubeDimensionTable;
import org.apache.lens.cube.metadata.CubeFactTable;
import org.apache.lens.cube.metadata.CubeInterface;
import org.apache.lens.cube.metadata.CubeMeasure;
import org.apache.lens.cube.metadata.CubeMetastoreClient;
import org.apache.lens.cube.metadata.DerivedCube;
import org.apache.lens.cube.metadata.Dimension;
import org.apache.lens.cube.metadata.ExprColumn;
import org.apache.lens.cube.metadata.JoinChain;
import org.apache.lens.cube.metadata.MetastoreUtil;
import org.apache.lens.cube.metadata.Storage;
import org.apache.lens.cube.metadata.StorageConstants;
import org.apache.lens.cube.metadata.StorageTableDesc;
import org.apache.lens.cube.metadata.UpdatePeriod;
import org.apache.lens.server.LensService;
import org.apache.lens.server.api.metastore.CubeMetastoreService;
import org.apache.lens.server.metastore.JAXBUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;

public class CubeMetastoreServiceImpl
extends LensService
implements CubeMetastoreService {
    public static final Logger LOG = LogManager.getLogger(CubeMetastoreServiceImpl.class);

    public CubeMetastoreServiceImpl(CLIService cliService) {
        super("metastore", cliService);
    }

    synchronized CubeMetastoreClient getClient(LensSessionHandle sessionid) throws LensException {
        return this.getSession(sessionid).getCubeMetastoreClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCurrentDatabase(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            String string = this.getSession(sessionid).getCurrentDatabase();
            return string;
        }
        finally {
            this.release(sessionid);
        }
    }

    public void setCurrentDatabase(LensSessionHandle sessionid, String database) throws LensException {
        try {
            this.acquire(sessionid);
            if (!Hive.get((HiveConf)this.getSession(sessionid).getHiveConf()).databaseExists(database)) {
                throw new NotFoundException("Database " + database + " does not exist");
            }
            LOG.info((Object)("Set database " + database));
            this.getSession(sessionid).setCurrentDatabase(database);
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropDatabase(LensSessionHandle sessionid, String database, boolean cascade) throws LensException {
        try {
            this.acquire(sessionid);
            Hive.get((HiveConf)this.getSession(sessionid).getHiveConf()).dropDatabase(database, false, true, cascade);
            LOG.info((Object)("Database dropped " + database + " cascade? " + true));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        catch (NoSuchObjectException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void createDatabase(LensSessionHandle sessionid, String database, boolean ignore) throws LensException {
        try {
            this.acquire(sessionid);
            Database db = new Database();
            db.setName(database);
            Hive.get((HiveConf)this.getSession(sessionid).getHiveConf()).createDatabase(db, ignore);
        }
        catch (AlreadyExistsException e) {
            throw new LensException((Throwable)e);
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        LOG.info((Object)("Database created " + database));
    }

    public List<String> getAllDatabases(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List list = Hive.get((HiveConf)this.getSession(sessionid).getHiveConf()).getAllDatabases();
            return list;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getAllCubeNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List cubes = this.getClient(sessionid).getAllCubes();
            if (cubes != null && !cubes.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(cubes.size());
                for (CubeInterface cube : cubes) {
                    names.add(cube.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public void createCube(LensSessionHandle sessionid, XCube cube) throws LensException {
        try {
            this.acquire(sessionid);
            Cube parent = cube instanceof XDerivedCube ? (Cube)this.getClient(sessionid).getCube(((XDerivedCube)cube).getParent()) : null;
            this.getClient(sessionid).createCube(JAXBUtils.hiveCubeFromXCube(cube, parent));
            LOG.info((Object)("Created cube " + cube.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        catch (ParseException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public XCube getCube(LensSessionHandle sessionid, String cubeName) throws LensException {
        try {
            this.acquire(sessionid);
            CubeInterface c = this.getClient(sessionid).getCube(cubeName);
            if (c != null) {
                XCube xCube = JAXBUtils.xCubeFromHiveCube(c);
                return xCube;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public void dropCube(LensSessionHandle sessionid, String cubeName) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).dropCube(cubeName);
            LOG.info((Object)("Dropped cube " + cubeName));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void updateCube(LensSessionHandle sessionid, XCube cube) throws LensException {
        try {
            this.acquire(sessionid);
            Cube parent = cube instanceof XDerivedCube ? (Cube)this.getClient(sessionid).getCube(((XDerivedCube)cube).getParent()) : null;
            this.getClient(sessionid).alterCube(cube.getName(), JAXBUtils.hiveCubeFromXCube(cube, parent));
            LOG.info((Object)("Cube updated " + cube.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        catch (ParseException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void createDimensionTable(LensSessionHandle sessionid, XDimensionTable xDimTable) throws LensException {
        String dimTblName = xDimTable.getTableName();
        ArrayList<FieldSchema> columns = JAXBUtils.fieldSchemaListFromColumns(xDimTable.getColumns());
        Map<String, UpdatePeriod> updatePeriodMap = JAXBUtils.dumpPeriodsFromStorageTables(xDimTable.getStorageTables());
        Map<String, String> properties = JAXBUtils.mapFromXProperties(xDimTable.getProperties());
        Map<String, StorageTableDesc> storageDesc = JAXBUtils.storageTableMapFromXStorageTables(xDimTable.getStorageTables());
        try {
            this.acquire(sessionid);
            LOG.info((Object)("# Columns: " + columns));
            this.getClient(sessionid).createCubeDimensionTable(xDimTable.getDimensionName(), dimTblName, columns, xDimTable.getWeight().doubleValue(), updatePeriodMap, properties, storageDesc);
            LOG.info((Object)("Dimension Table created " + xDimTable.getTableName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropDimensionTable(LensSessionHandle sessionid, String dimTblName, boolean cascade) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).dropDimensionTable(dimTblName, cascade);
            LOG.info((Object)("Dropped dimension table " + dimTblName + " cascade? " + cascade));
        }
        catch (HiveException e) {
            LOG.error((Object)("@@@@ Got HiveException: >>>>>>>" + e.getMessage() + "<<<<<<<<<"));
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public XDimensionTable getDimensionTable(LensSessionHandle sessionid, String dimTblName) throws LensException {
        try {
            this.acquire(sessionid);
            CubeDimensionTable dimTable = this.getClient(sessionid).getDimensionTable(dimTblName);
            XDimensionTable dt = JAXBUtils.dimTableFromCubeDimTable(dimTable);
            for (String storageName : dimTable.getStorages()) {
                XStorageTableElement tblElement = JAXBUtils.getXStorageTableFromHiveTable(this.getClient(sessionid).getHiveTable(MetastoreUtil.getDimStorageTableName((String)dimTblName, (String)storageName)));
                tblElement.setStorageName(storageName);
                UpdatePeriod p = (UpdatePeriod)dimTable.getSnapshotDumpPeriods().get(storageName);
                if (p != null) {
                    tblElement.getUpdatePeriods().getUpdatePeriod().add(XUpdatePeriod.valueOf((String)p.name()));
                }
                dt.getStorageTables().getStorageTable().add(tblElement);
            }
            XDimensionTable xDimensionTable = dt;
            return xDimensionTable;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void updateDimensionTable(LensSessionHandle sessionid, XDimensionTable dimensionTable) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).alterCubeDimensionTable(dimensionTable.getTableName(), JAXBUtils.cubeDimTableFromDimTable(dimensionTable));
            LOG.info((Object)("Updated dimension table " + dimensionTable.getTableName()));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getDimTableStorages(LensSessionHandle sessionid, String dimension) throws LensException {
        try {
            this.acquire(sessionid);
            CubeDimensionTable dimTable = this.getClient(sessionid).getDimensionTable(dimension);
            ArrayList<String> arrayList = new ArrayList<String>(dimTable.getStorages());
            return arrayList;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void addDimTableStorage(LensSessionHandle sessionid, String dimTblName, XStorageTableElement storageTable) throws LensException {
        try {
            this.acquire(sessionid);
            CubeDimensionTable dimTable = this.getClient(sessionid).getDimensionTable(dimTblName);
            UpdatePeriod period = null;
            if (storageTable.getUpdatePeriods() != null && !storageTable.getUpdatePeriods().getUpdatePeriod().isEmpty()) {
                period = UpdatePeriod.valueOf((String)((XUpdatePeriod)storageTable.getUpdatePeriods().getUpdatePeriod().get(0)).name());
            }
            this.getClient(sessionid).addStorage(dimTable, storageTable.getStorageName(), period, JAXBUtils.storageTableDescFromXStorageTableDesc(storageTable.getTableDesc()));
            LOG.info((Object)("Added storage " + storageTable.getStorageName() + " for dimension table " + dimTblName + " with update period " + period));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropAllStoragesOfDimTable(LensSessionHandle sessionid, String dimTblName) throws LensException {
        try {
            this.acquire(sessionid);
            CubeDimensionTable tab = this.getClient(sessionid).getDimensionTable(dimTblName);
            int total = tab.getStorages().size();
            int i = 0;
            ArrayList storageNames = new ArrayList(tab.getStorages());
            for (String s : storageNames) {
                this.getClient(sessionid).dropStorageFromDim(dimTblName, s);
                LOG.info((Object)("Dropped storage " + s + " from dimension table " + dimTblName + " [" + ++i + "/" + total + "]"));
            }
            LOG.info((Object)("Dropped " + total + " storages from dimension table " + dimTblName));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropAllStoragesOfFact(LensSessionHandle sessionid, String factName) throws LensException {
        try {
            this.acquire(sessionid);
            CubeFactTable tab = this.getClient(sessionid).getFactTable(factName);
            int total = tab.getStorages().size();
            int i = 0;
            ArrayList storageNames = new ArrayList(tab.getStorages());
            for (String s : storageNames) {
                this.getClient(sessionid).dropStorageFromFact(factName, s);
                LOG.info((Object)("Dropped storage " + s + " from fact table " + factName + " [" + ++i + "/" + total + "]"));
            }
            LOG.info((Object)("Dropped " + total + " storages from fact table " + factName));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropStorageOfDimTable(LensSessionHandle sessionid, String dimTblName, String storage) throws LensException {
        try {
            this.acquire(sessionid);
            CubeDimensionTable tab = this.getClient(sessionid).getDimensionTable(dimTblName);
            if (!tab.getStorages().contains(storage)) {
                throw new NotFoundException("Storage " + storage + " not found for dimension " + dimTblName);
            }
            this.getClient(sessionid).dropStorageFromDim(dimTblName, storage);
            LOG.info((Object)("Dropped storage " + storage + " from dimension table " + dimTblName));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<XFactTable> getAllFactsOfCube(LensSessionHandle sessionid, String cubeName) throws LensException {
        try {
            this.acquire(sessionid);
            List cubeFacts = this.getClient(sessionid).getAllFactTables(this.getClient(sessionid).getCube(cubeName));
            if (cubeFacts != null && !cubeFacts.isEmpty()) {
                ArrayList<XFactTable> facts = new ArrayList<XFactTable>(cubeFacts.size());
                for (CubeFactTable cft : cubeFacts) {
                    facts.add(JAXBUtils.factTableFromCubeFactTable(cft));
                }
                ArrayList<XFactTable> arrayList = facts;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public XFactTable getFactTable(LensSessionHandle sessionid, String fact) throws LensException {
        try {
            this.acquire(sessionid);
            CubeFactTable cft = this.getClient(sessionid).getFactTable(fact);
            XFactTable factTable = JAXBUtils.factTableFromCubeFactTable(cft);
            for (String storageName : cft.getStorages()) {
                Set updatePeriods = (Set)cft.getUpdatePeriods().get(storageName);
                XStorageTableElement tblElement = JAXBUtils.getXStorageTableFromHiveTable(this.getClient(sessionid).getHiveTable(MetastoreUtil.getFactStorageTableName((String)fact, (String)storageName)));
                tblElement.setStorageName(storageName);
                for (UpdatePeriod p : updatePeriods) {
                    tblElement.getUpdatePeriods().getUpdatePeriod().add(XUpdatePeriod.valueOf((String)p.name()));
                }
                factTable.getStorageTables().getStorageTable().add(tblElement);
            }
            XFactTable xFactTable = factTable;
            return xFactTable;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void createFactTable(LensSessionHandle sessionid, XFactTable fact) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).createCubeFactTable(fact.getCubeName(), fact.getName(), JAXBUtils.fieldSchemaListFromColumns(fact.getColumns()), JAXBUtils.getFactUpdatePeriodsFromStorageTables(fact.getStorageTables()), fact.getWeight().doubleValue(), JAXBUtils.mapFromXProperties(fact.getProperties()), JAXBUtils.storageTableMapFromXStorageTables(fact.getStorageTables()));
            LOG.info((Object)("Created fact table " + fact.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void updateFactTable(LensSessionHandle sessionid, XFactTable fact) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).alterCubeFactTable(fact.getName(), JAXBUtils.cubeFactFromFactTable(fact));
            LOG.info((Object)("Updated fact table " + fact.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropFactTable(LensSessionHandle sessionid, String fact, boolean cascade) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).dropFact(fact, cascade);
            LOG.info((Object)("Dropped fact table " + fact + " cascade? " + cascade));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getAllFactNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List facts = this.getClient(sessionid).getAllFacts();
            ArrayList<String> factNames = new ArrayList<String>(facts.size());
            for (CubeFactTable cft : facts) {
                factNames.add(cft.getName());
            }
            ArrayList<String> arrayList = factNames;
            return arrayList;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getAllDimTableNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List dims = this.getClient(sessionid).getAllDimensionTables();
            ArrayList<String> dimNames = new ArrayList<String>(dims.size());
            for (CubeDimensionTable cdt : dims) {
                dimNames.add(cdt.getName());
            }
            ArrayList<String> arrayList = dimNames;
            return arrayList;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getStoragesOfFact(LensSessionHandle sessionid, String fact) throws LensException {
        try {
            this.acquire(sessionid);
            if (!this.getClient(sessionid).isFactTable(fact)) {
                throw new NotFoundException("Not a fact table " + fact);
            }
            CubeFactTable cft = this.getClient(sessionid).getFactTable(fact);
            if (cft != null) {
                ArrayList<String> arrayList = new ArrayList<String>(cft.getStorages());
                return arrayList;
            }
            try {
                throw new NotFoundException("Could not get fact table " + fact);
            }
            catch (HiveException exc) {
                throw new LensException((Throwable)exc);
            }
        }
        finally {
            this.release(sessionid);
        }
    }

    public XStorageTableElement getStorageOfFact(LensSessionHandle sessionid, String fact, String storageName) throws LensException {
        try {
            CubeFactTable factTable = this.getClient(sessionid).getFactTable(fact);
            Set updatePeriods = (Set)factTable.getUpdatePeriods().get(storageName);
            XStorageTableElement tblElement = JAXBUtils.getXStorageTableFromHiveTable(this.getClient(sessionid).getHiveTable(MetastoreUtil.getFactStorageTableName((String)fact, (String)storageName)));
            tblElement.setStorageName(storageName);
            for (UpdatePeriod p : updatePeriods) {
                tblElement.getUpdatePeriods().getUpdatePeriod().add(XUpdatePeriod.valueOf((String)p.name()));
            }
            XStorageTableElement xStorageTableElement = tblElement;
            return xStorageTableElement;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public XStorageTableElement getStorageOfDim(LensSessionHandle sessionid, String dimTblName, String storageName) throws LensException {
        try {
            CubeDimensionTable dimTable = this.getClient(sessionid).getDimensionTable(dimTblName);
            XStorageTableElement tblElement = JAXBUtils.getXStorageTableFromHiveTable(this.getClient(sessionid).getHiveTable(MetastoreUtil.getDimStorageTableName((String)dimTblName, (String)storageName)));
            tblElement.setStorageName(storageName);
            UpdatePeriod p = (UpdatePeriod)dimTable.getSnapshotDumpPeriods().get(storageName);
            if (p != null) {
                tblElement.getUpdatePeriods().getUpdatePeriod().add(XUpdatePeriod.valueOf((String)p.name()));
            }
            XStorageTableElement xStorageTableElement = tblElement;
            return xStorageTableElement;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void addStorageToFact(LensSessionHandle sessionid, String fact, XStorageTableElement storageTable) throws LensException {
        TreeSet<UpdatePeriod> updatePeriods = new TreeSet<UpdatePeriod>();
        for (XUpdatePeriod sup : storageTable.getUpdatePeriods().getUpdatePeriod()) {
            updatePeriods.add(UpdatePeriod.valueOf((String)sup.name()));
        }
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).addStorage(this.getClient(sessionid).getFactTable(fact), storageTable.getStorageName(), updatePeriods, JAXBUtils.storageTableDescFromXStorageTableElement(storageTable));
            LOG.info((Object)("Added storage " + storageTable.getStorageName() + ":" + updatePeriods + " for fact " + fact));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropStorageOfFact(LensSessionHandle sessionid, String fact, String storage) throws LensException {
        try {
            this.acquire(sessionid);
            this.checkFactStorage(sessionid, fact, storage);
            this.getClient(sessionid).dropStorageFromFact(fact, storage);
            LOG.info((Object)("Dropped storage " + storage + " from fact " + fact));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    private CubeFactTable checkFactStorage(LensSessionHandle sessionid, String fact, String storage) throws HiveException, LensException {
        CubeMetastoreClient client = this.getClient(sessionid);
        if (!client.isFactTable(fact)) {
            throw new NotFoundException("Fact table not found: " + fact);
        }
        CubeFactTable factTable = client.getFactTable(fact);
        if (!factTable.getStorages().contains(storage)) {
            throw new NotFoundException("Storage " + storage + " not found for fact table " + fact);
        }
        return factTable;
    }

    public List<XPartition> getAllPartitionsOfFactStorage(LensSessionHandle sessionid, String fact, String storageName, String filter) throws LensException {
        try {
            this.acquire(sessionid);
            this.checkFactStorage(sessionid, fact, storageName);
            String storageTableName = MetastoreUtil.getFactStorageTableName((String)fact, (String)storageName);
            List parts = this.getClient(sessionid).getPartitionsByFilter(storageTableName, filter);
            if (parts != null) {
                ArrayList<XPartition> result = new ArrayList<XPartition>(parts.size());
                for (Partition p : parts) {
                    XPartition xp = JAXBUtils.xpartitionFromPartition(p);
                    result.add(xp);
                }
                ArrayList<XPartition> arrayList = result;
                return arrayList;
            }
            ArrayList<XPartition> arrayList = new ArrayList<XPartition>();
            return arrayList;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void addPartitionToFactStorage(LensSessionHandle sessionid, String fact, String storageName, XPartition partition) throws LensException {
        try {
            this.acquire(sessionid);
            this.checkFactStorage(sessionid, fact, storageName);
            this.getClient(sessionid).addPartition(JAXBUtils.storagePartSpecFromXPartition(partition), storageName);
            LOG.info((Object)("Added partition for fact " + fact + " on storage:" + storageName + " dates: " + partition.getTimePartitionSpec() + " spec:" + partition.getNonTimePartitionSpec() + " update period: " + partition.getUpdatePeriod()));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    private CubeDimensionTable checkDimensionStorage(LensSessionHandle sessionid, String dimension, String storage) throws HiveException, LensException {
        CubeMetastoreClient client = this.getClient(sessionid);
        if (!client.isDimensionTable(dimension)) {
            throw new NotFoundException("Dimension table not found: " + dimension);
        }
        CubeDimensionTable cdt = client.getDimensionTable(dimension);
        if (!cdt.getStorages().contains(storage)) {
            throw new NotFoundException("Storage " + storage + " not found for dimension " + dimension);
        }
        return cdt;
    }

    public List<XPartition> getAllPartitionsOfDimTableStorage(LensSessionHandle sessionid, String dimension, String storageName, String filter) throws LensException {
        try {
            this.acquire(sessionid);
            this.checkDimensionStorage(sessionid, dimension, storageName);
            String storageTableName = MetastoreUtil.getDimStorageTableName((String)dimension, (String)storageName);
            List partitions = this.getClient(sessionid).getPartitionsByFilter(storageTableName, filter);
            if (partitions != null) {
                ArrayList<XPartition> result = new ArrayList<XPartition>(partitions.size());
                for (Partition p : partitions) {
                    XPartition xp = JAXBUtils.xpartitionFromPartition(p);
                    result.add(xp);
                }
                ArrayList<XPartition> arrayList = result;
                return arrayList;
            }
            ArrayList<XPartition> arrayList = new ArrayList<XPartition>();
            return arrayList;
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void addPartitionToDimStorage(LensSessionHandle sessionid, String dimTblName, String storageName, XPartition partition) throws LensException {
        try {
            this.acquire(sessionid);
            this.checkDimensionStorage(sessionid, dimTblName, storageName);
            this.getClient(sessionid).addPartition(JAXBUtils.storagePartSpecFromXPartition(partition), storageName);
            LOG.info((Object)("Added partition for dimension: " + dimTblName + " storage: " + storageName));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    private String getFilter(CubeMetastoreClient client, String tableName, String values) throws HiveException {
        List cols = client.getHiveTable(tableName).getPartCols();
        String[] vals = StringUtils.split((String)values, (String)",");
        if (vals.length != cols.size()) {
            LOG.error((Object)("Values for all the part columns not specified, cols:" + cols + " vals:" + vals));
            throw new BadRequestException("Values for all the part columns not specified");
        }
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < vals.length; ++i) {
            filter.append(((FieldSchema)cols.get(i)).getName());
            filter.append("=");
            filter.append("\"");
            filter.append(vals[i]);
            filter.append("\"");
            if (i == vals.length - 1) continue;
            filter.append(" AND ");
        }
        return filter.toString();
    }

    private UpdatePeriod populatePartSpec(Partition p, Map<String, Date> timeSpec, Map<String, String> nonTimeSpec) throws HiveException {
        String timePartColsStr = (String)p.getTable().getTTable().getParameters().get("cube.storagetable.time.partcols");
        String upParam = (String)p.getParameters().get("cube.storagetable.partition.update.period");
        UpdatePeriod period = UpdatePeriod.valueOf((String)upParam);
        HashMap partSpec = new HashMap();
        partSpec.putAll(p.getSpec());
        if (timePartColsStr != null) {
            String[] timePartCols;
            for (String partCol : timePartCols = StringUtils.split((String)timePartColsStr, (char)',')) {
                String dateStr = (String)partSpec.get(partCol);
                Date date = null;
                try {
                    date = period.format().parse(dateStr);
                }
                catch (Exception e) {
                    continue;
                }
                partSpec.remove(partCol);
                timeSpec.put(partCol, date);
            }
        }
        if (!partSpec.isEmpty()) {
            nonTimeSpec.putAll(partSpec);
        }
        return period;
    }

    public void dropPartitionFromStorageByValues(LensSessionHandle sessionid, String cubeTableName, String storageName, String values) throws LensException {
        try {
            this.acquire(sessionid);
            String tableName = MetastoreUtil.getStorageTableName((String)cubeTableName, (String)Storage.getPrefix((String)storageName));
            String filter = this.getFilter(this.getClient(sessionid), tableName, values);
            List partitions = this.getClient(sessionid).getPartitionsByFilter(tableName, filter);
            if (partitions.size() > 1) {
                LOG.error((Object)("More than one partition with specified values, correspoding filter:" + filter));
                throw new BadRequestException("More than one partition with specified values");
            }
            if (partitions.size() == 0) {
                LOG.error((Object)("No partition exists with specified values, correspoding filter:" + filter));
                throw new NotFoundException("No partition exists with specified values");
            }
            HashMap<String, Date> timeSpec = new HashMap<String, Date>();
            HashMap<String, String> nonTimeSpec = new HashMap<String, String>();
            UpdatePeriod updatePeriod = this.populatePartSpec((Partition)partitions.get(0), timeSpec, nonTimeSpec);
            this.getClient(sessionid).dropPartition(cubeTableName, storageName, timeSpec, nonTimeSpec, updatePeriod);
            LOG.info((Object)("Dropped partition  for dimension: " + cubeTableName + " storage: " + storageName + " values:" + values));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropPartitionFromStorageByFilter(LensSessionHandle sessionid, String cubeTableName, String storageName, String filter) throws LensException {
        try {
            this.acquire(sessionid);
            String tableName = MetastoreUtil.getStorageTableName((String)cubeTableName, (String)Storage.getPrefix((String)storageName));
            List partitions = this.getClient(sessionid).getPartitionsByFilter(tableName, filter);
            for (Partition part : partitions) {
                try {
                    HashMap<String, Date> timeSpec = new HashMap<String, Date>();
                    HashMap<String, String> nonTimeSpec = new HashMap<String, String>();
                    UpdatePeriod updatePeriod = this.populatePartSpec(part, timeSpec, nonTimeSpec);
                    this.getClient(sessionid).dropPartition(cubeTableName, storageName, timeSpec, nonTimeSpec, updatePeriod);
                }
                catch (HiveException e) {
                    if (e.getCause() instanceof NoSuchObjectException) continue;
                    throw new LensException((Throwable)e);
                }
            }
            LOG.info((Object)("Dropped partition  for cube table: " + cubeTableName + " storage: " + storageName + " by filter:" + filter));
        }
        catch (HiveException exc) {
            throw new LensException((Throwable)exc);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void createStorage(LensSessionHandle sessionid, XStorage storage) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).createStorage(JAXBUtils.storageFromXStorage(storage));
            LOG.info((Object)("Created storage " + storage.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropStorage(LensSessionHandle sessionid, String storageName) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).dropStorage(storageName);
            LOG.info((Object)("Dropped storage " + storageName));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void alterStorage(LensSessionHandle sessionid, String storageName, XStorage storage) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).alterStorage(storageName, JAXBUtils.storageFromXStorage(storage));
            LOG.info((Object)("Altered storage " + storageName));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public XStorage getStorage(LensSessionHandle sessionid, String storageName) throws LensException {
        try {
            this.acquire(sessionid);
            XStorage xStorage = JAXBUtils.xstorageFromStorage(this.getClient(sessionid).getStorage(storageName));
            return xStorage;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getAllStorageNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List storages = this.getClient(sessionid).getAllStorages();
            if (storages != null && !storages.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(storages.size());
                for (Storage storage : storages) {
                    names.add(storage.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public List<String> getAllBaseCubeNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List cubes = this.getClient(sessionid).getAllCubes();
            if (cubes != null && !cubes.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(cubes.size());
                for (CubeInterface cube : cubes) {
                    if (cube.isDerivedCube()) continue;
                    names.add(cube.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public List<String> getAllDerivedCubeNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List cubes = this.getClient(sessionid).getAllCubes();
            if (cubes != null && !cubes.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(cubes.size());
                for (CubeInterface cube : cubes) {
                    if (!cube.isDerivedCube()) continue;
                    names.add(cube.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public List<String> getAllQueryableCubeNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List cubes = this.getClient(sessionid).getAllCubes();
            if (cubes != null && !cubes.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(cubes.size());
                for (CubeInterface cube : cubes) {
                    if (!cube.allFieldsQueriable()) continue;
                    names.add(cube.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public void createDimension(LensSessionHandle sessionid, XDimension dimension) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).createDimension(JAXBUtils.dimensionFromXDimension(dimension));
            LOG.info((Object)("Created dimension " + dimension.getName()));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        catch (ParseException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public XDimension getDimension(LensSessionHandle sessionid, String dimName) throws LensException {
        try {
            this.acquire(sessionid);
            XDimension xDimension = JAXBUtils.xdimensionFromDimension(this.getClient(sessionid).getDimension(dimName));
            return xDimension;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void dropDimension(LensSessionHandle sessionid, String dimName) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).dropDimension(dimName);
            LOG.info((Object)("Dropped dimension " + dimName));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public void updateDimension(LensSessionHandle sessionid, String dimName, XDimension dimension) throws LensException {
        try {
            this.acquire(sessionid);
            this.getClient(sessionid).alterDimension(dimName, JAXBUtils.dimensionFromXDimension(dimension));
            LOG.info((Object)("Altered dimension " + dimName));
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        catch (ParseException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    public List<String> getAllDimensionNames(LensSessionHandle sessionid) throws LensException {
        try {
            this.acquire(sessionid);
            List dimensions = this.getClient(sessionid).getAllDimensions();
            if (dimensions != null && !dimensions.isEmpty()) {
                ArrayList<String> names = new ArrayList<String>(dimensions.size());
                for (Dimension dim : dimensions) {
                    names.add(dim.getName());
                }
                ArrayList<String> arrayList = names;
                return arrayList;
            }
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
        return null;
    }

    public XNativeTable getNativeTable(LensSessionHandle sessionid, String name) throws LensException {
        try {
            this.acquire(sessionid);
            Table tbl = this.getClient(sessionid).getHiveTable(name);
            if (tbl.getParameters().get("cube.table.type") != null) {
                throw new BadRequestException(name + " is not a native table");
            }
            XNativeTable xNativeTable = JAXBUtils.nativeTableFromMetaTable(tbl);
            return xNativeTable;
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    private List<String> getTablesFromDB(LensSessionHandle sessionid, String dbName, boolean prependDbName) throws MetaException, UnknownDBException, HiveSQLException, TException, LensException {
        List tables = this.getSession(sessionid).getMetaStoreClient().getAllTables(dbName);
        ArrayList<String> result = new ArrayList<String>();
        if (tables != null && !tables.isEmpty()) {
            for (String tblName : tables) {
                org.apache.hadoop.hive.metastore.api.Table tbl = this.getSession(sessionid).getMetaStoreClient().getTable(dbName, tblName);
                if (tbl.getParameters().get("cube.table.type") != null) continue;
                if (prependDbName) {
                    result.add(dbName + "." + tblName);
                    continue;
                }
                result.add(tblName);
            }
        }
        return result;
    }

    public List<String> getAllNativeTableNames(LensSessionHandle sessionid, String dbOption, String dbName) throws LensException {
        try {
            List<String> tables;
            this.acquire(sessionid);
            if (!StringUtils.isBlank((String)dbName) && !Hive.get().databaseExists(dbName)) {
                throw new NotFoundException("Database " + dbName + " does not exist");
            }
            if (StringUtils.isBlank((String)dbName) && (StringUtils.isBlank((String)dbOption) || dbOption.equalsIgnoreCase("current"))) {
                dbName = this.getSession(sessionid).getCurrentDatabase();
            }
            if (!StringUtils.isBlank((String)dbName)) {
                tables = this.getTablesFromDB(sessionid, dbName, false);
            } else {
                LOG.info((Object)"Getting tables from all dbs");
                List<String> alldbs = this.getAllDatabases(sessionid);
                tables = new ArrayList<String>();
                for (String db : alldbs) {
                    tables.addAll(this.getTablesFromDB(sessionid, db, true));
                }
            }
            List<String> list = tables;
            return list;
        }
        catch (HiveSQLException e) {
            throw new LensException((Throwable)e);
        }
        catch (MetaException e) {
            throw new LensException((Throwable)e);
        }
        catch (UnknownDBException e) {
            throw new NotFoundException("Database " + dbName + " does not exist");
        }
        catch (TException e) {
            throw new LensException((Throwable)e);
        }
        catch (HiveException e) {
            throw new LensException((Throwable)e);
        }
        finally {
            this.release(sessionid);
        }
    }

    private void addAllMeasuresToFlattenedList(ObjectFactory objectFactory, CubeInterface cube, List<XFlattenedColumn> columnList) {
        for (CubeMeasure msr : cube.getMeasures()) {
            XFlattenedColumn fcol = objectFactory.createXFlattenedColumn();
            fcol.setMeasure(JAXBUtils.xMeasureFromHiveMeasure(msr));
            fcol.setTableName(cube.getName());
            columnList.add(fcol);
        }
    }

    private void addAllDirectAttributesToFlattenedListFromCube(ObjectFactory objectFactory, CubeInterface cube, List<XFlattenedColumn> columnList) {
        AbstractBaseTable baseTbl = (AbstractBaseTable)(cube instanceof DerivedCube ? ((DerivedCube)cube).getParent() : cube);
        for (CubeDimAttribute dim : cube.getDimAttributes()) {
            XFlattenedColumn fcol = objectFactory.createXFlattenedColumn();
            fcol.setDimAttribute(JAXBUtils.xDimAttrFromHiveDimAttr(dim, baseTbl));
            fcol.setTableName(cube.getName());
            columnList.add(fcol);
        }
    }

    private void addAllDirectAttributesToFlattenedListFromDimension(ObjectFactory objectFactory, Dimension dimension, List<XFlattenedColumn> columnList, String chainName) {
        for (CubeDimAttribute cd : dimension.getAttributes()) {
            XFlattenedColumn fcol = objectFactory.createXFlattenedColumn();
            fcol.setDimAttribute(JAXBUtils.xDimAttrFromHiveDimAttr(cd, (AbstractBaseTable)dimension));
            fcol.setTableName(dimension.getName());
            if (chainName != null) {
                fcol.setChainName(chainName);
            }
            columnList.add(fcol);
        }
    }

    private void addAllDirectExpressionsToFlattenedList(ObjectFactory objectFactory, AbstractBaseTable baseTbl, List<XFlattenedColumn> columnList, String chainName) {
        for (ExprColumn expr : baseTbl.getExpressions()) {
            XFlattenedColumn fcol = objectFactory.createXFlattenedColumn();
            fcol.setExpression(JAXBUtils.xExprColumnFromHiveExprColumn(expr));
            fcol.setTableName(baseTbl.getName());
            if (chainName != null) {
                fcol.setChainName(chainName);
            }
            columnList.add(fcol);
        }
    }

    private void addAllChainedColsToFlattenedListFromCube(CubeMetastoreClient client, ObjectFactory objectFactory, CubeInterface cube, List<XFlattenedColumn> columnList) throws HiveException {
        if (cube instanceof DerivedCube) {
            return;
        }
        this.addAllChainedColsToFlattenedList(client, objectFactory, (AbstractBaseTable)cube, columnList);
    }

    private void addAllChainedColsToFlattenedList(CubeMetastoreClient client, ObjectFactory objectFactory, AbstractBaseTable baseTbl, List<XFlattenedColumn> columnList) throws HiveException {
        for (JoinChain chain : baseTbl.getJoinChains()) {
            Dimension dim = client.getDimension(chain.getDestTable());
            this.addAllDirectAttributesToFlattenedListFromDimension(objectFactory, dim, columnList, chain.getName());
            this.addAllDirectExpressionsToFlattenedList(objectFactory, (AbstractBaseTable)dim, columnList, chain.getName());
        }
    }

    public XFlattenedColumns getFlattenedColumns(LensSessionHandle sessionHandle, String tableName) throws LensException {
        try {
            this.acquire(sessionHandle);
            CubeMetastoreClient client = this.getClient(sessionHandle);
            ObjectFactory objectFactory = new ObjectFactory();
            XFlattenedColumns flattenedColumns = objectFactory.createXFlattenedColumns();
            List columnList = flattenedColumns.getFlattenedColumn();
            if (client.isCube(tableName)) {
                CubeInterface cube = client.getCube(tableName);
                this.addAllMeasuresToFlattenedList(objectFactory, cube, columnList);
                this.addAllDirectAttributesToFlattenedListFromCube(objectFactory, cube, columnList);
                this.addAllDirectExpressionsToFlattenedList(objectFactory, (AbstractBaseTable)cube, columnList, null);
                this.addAllChainedColsToFlattenedListFromCube(client, objectFactory, cube, columnList);
            } else if (client.isDimension(tableName)) {
                Dimension dimension = client.getDimension(tableName);
                this.addAllDirectAttributesToFlattenedListFromDimension(objectFactory, dimension, columnList, null);
                this.addAllDirectExpressionsToFlattenedList(objectFactory, (AbstractBaseTable)dimension, columnList, null);
                this.addAllChainedColsToFlattenedList(client, objectFactory, (AbstractBaseTable)dimension, columnList);
            } else {
                throw new BadRequestException("Can't get reachable columns. '" + tableName + "' is neither a cube nor a dimension");
            }
            XFlattenedColumns xFlattenedColumns = flattenedColumns;
            return xFlattenedColumns;
        }
        catch (LensException exc) {
            throw exc;
        }
        catch (HiveException e) {
            throw new LensException("Error getting flattened view for " + tableName, (Throwable)e);
        }
        finally {
            this.release(sessionHandle);
        }
    }

    public Date getLatestDateOfCube(LensSessionHandle sessionid, String cubeName, String timeDimension) throws LensException, HiveException {
        this.acquire(sessionid);
        CubeInterface ci = this.getClient(sessionid).getCube(cubeName);
        if (!(ci instanceof Cube)) {
            throw new BadRequestException("cubeName : " + cubeName + " is not a base cube.");
        }
        Cube c = (Cube)ci;
        String partitionColumn = c.getPartitionColumnOfTimeDim(timeDimension);
        List<XFactTable> factTables = this.getAllFactsOfCube(sessionid, cubeName);
        Date latestDate = null;
        if (factTables != null && !factTables.isEmpty()) {
            for (XFactTable factTable : factTables) {
                List<String> storages = this.getStoragesOfFact(sessionid, factTable.getName());
                if (storages == null || storages.isEmpty()) continue;
                for (String storage : storages) {
                    String storageTableName = MetastoreUtil.getFactStorageTableName((String)factTable.getName(), (String)storage);
                    List parts = new LinkedList();
                    try {
                        parts = this.getClient(sessionid).getPartitionsByFilter(storageTableName, StorageConstants.getLatestPartFilter((String)partitionColumn));
                    }
                    catch (HiveException e) {
                        LOG.info((Object)("Storage Table " + storageTableName + " skipped while finding latestDate due to exception: "), (Throwable)e);
                    }
                    if (parts.size() == 1) {
                        Date tmpDate = this.getClient(sessionid).getLatestTimeStamp((Partition)parts.get(0), partitionColumn);
                        if (latestDate != null && !latestDate.before(tmpDate)) continue;
                        latestDate = tmpDate;
                        continue;
                    }
                    if (parts.size() <= 1) continue;
                    throw new LensException("CubeMetastoreClient return more than 1 partitions for filter " + partitionColumn + "='latest'");
                }
            }
        }
        this.release(sessionid);
        return latestDate;
    }
}

