/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server;

import javax.ws.rs.ClientErrorException;
import javax.ws.rs.ServerErrorException;
import org.apache.lens.server.LensServices;
import org.apache.lens.server.api.metrics.MetricsService;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class LensRequestListener
implements RequestEventListener {
    public static final String HTTP_REQUESTS_STARTED = "http-requests-started";
    public static final String HTTP_REQUESTS_FINISHED = "http-requests-finished";
    public static final String HTTP_ERROR = "http-error";
    public static final String HTTP_SERVER_ERROR = "http-server-error";
    public static final String HTTP_CLIENT_ERROR = "http-client-error";
    public static final String HTTP_UNKOWN_ERROR = "http-unkown-error";
    public static final String EXCEPTION_COUNT = "count";

    public void onEvent(RequestEvent event) {
        MetricsService metrics;
        if (RequestEvent.Type.ON_EXCEPTION == event.getType()) {
            Throwable error = event.getException();
            if (error != null) {
                Class<?> errorClass = error.getClass();
                MetricsService metrics2 = (MetricsService)LensServices.get().getService("metrics");
                if (metrics2 != null) {
                    metrics2.incrCounter(LensRequestListener.class, HTTP_ERROR);
                    metrics2.incrCounter(errorClass, EXCEPTION_COUNT);
                    if (error instanceof ServerErrorException) {
                        metrics2.incrCounter(LensRequestListener.class, HTTP_SERVER_ERROR);
                    } else if (error instanceof ClientErrorException) {
                        metrics2.incrCounter(LensRequestListener.class, HTTP_CLIENT_ERROR);
                    } else {
                        metrics2.incrCounter(LensRequestListener.class, HTTP_UNKOWN_ERROR);
                        error.printStackTrace();
                    }
                }
            }
        } else if (RequestEvent.Type.FINISHED == event.getType() && (metrics = (MetricsService)LensServices.get().getService("metrics")) != null) {
            metrics.incrCounter(LensRequestListener.class, HTTP_REQUESTS_FINISHED);
        }
    }
}

