/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.api.LensException;
import org.apache.lens.server.api.driver.DriverQueryPlan;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.AbstractQueryContext;
import org.apache.lens.server.api.util.LensUtil;

public class DriverSelectorQueryContext {
    public static final Log LOG = LogFactory.getLog(DriverSelectorQueryContext.class);
    protected LensDriver selectedDriver;
    protected Map<LensDriver, DriverQueryContext> driverQueryContextMap = new HashMap<LensDriver, DriverQueryContext>();

    public DriverSelectorQueryContext(String userQuery, Configuration queryConf, Collection<LensDriver> drivers) {
        for (LensDriver driver : drivers) {
            DriverQueryContext ctx = new DriverQueryContext(driver);
            ctx.setDriverSpecificConf(this.mergeConf(driver, queryConf));
            ctx.setQuery(userQuery);
            this.driverQueryContextMap.put(driver, ctx);
        }
    }

    private Configuration mergeConf(LensDriver driver, Configuration queryConf) {
        Configuration conf = new Configuration(driver.getConf());
        for (Map.Entry entry : queryConf) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
        conf.setClassLoader(queryConf.getClassLoader());
        return conf;
    }

    void setDriverQueriesAndPlans(Map<LensDriver, String> driverQueries, AbstractQueryContext qctx) throws LensException {
        StringBuilder detailedFailureCause = new StringBuilder();
        String failureCause = null;
        boolean useBuilder = false;
        boolean succeededOnAtleastOneDriver = false;
        for (LensDriver driver : driverQueries.keySet()) {
            DriverQueryContext driverQueryContext = this.driverQueryContextMap.get(driver);
            driverQueryContext.setQuery(driverQueries.get(driver));
            try {
                driverQueryContext.setDriverQueryPlan(driver.explain(qctx));
                succeededOnAtleastOneDriver = true;
            }
            catch (Exception e) {
                LOG.error((Object)("Setting driver plan failed for driver " + driver), (Throwable)e);
                String expMsg = LensUtil.getCauseMessage(e);
                driverQueryContext.setDriverQueryPlanGenerationError(e);
                detailedFailureCause.append("\n Driver :").append(driver.getClass().getName());
                detailedFailureCause.append(" Cause :" + expMsg);
                if (failureCause != null && !failureCause.equals(expMsg)) {
                    useBuilder = true;
                }
                if (failureCause != null) continue;
                failureCause = expMsg;
            }
        }
        if (!succeededOnAtleastOneDriver) {
            throw new LensException(useBuilder ? detailedFailureCause.toString() : failureCause);
        }
    }

    public DriverQueryPlan getSelectedDriverQueryPlan() throws LensException {
        Map<LensDriver, DriverQueryContext> driverQueryCtxs = this.getDriverQueryContextMap();
        if (driverQueryCtxs == null) {
            throw new LensException("No Driver query ctx. Check if re-write happened or not");
        }
        if (this.getSelectedDriver() == null) {
            throw new LensException("Selected Driver is NULL.");
        }
        if (driverQueryCtxs.get(this.getSelectedDriver()) == null) {
            throw new LensException("Could not find Driver Context for selected driver " + this.getSelectedDriver());
        }
        if (driverQueryCtxs.get(this.getSelectedDriver()).getDriverQueryPlanGenerationError() != null) {
            throw new LensException("Driver Query Plan of the selected driver is null", (Throwable)driverQueryCtxs.get(this.getSelectedDriver()).getDriverQueryPlanGenerationError());
        }
        return driverQueryCtxs.get(this.getSelectedDriver()).getDriverQueryPlan();
    }

    public Configuration getSelectedDriverConf() {
        return this.getSelectedDriver() == null ? null : this.driverQueryContextMap.get(this.getSelectedDriver()).getDriverSpecificConf();
    }

    public String getSelectedDriverQuery() {
        return this.getSelectedDriver() == null ? null : this.driverQueryContextMap.get(this.getSelectedDriver()).getQuery();
    }

    public void setDriverConf(LensDriver driver, Configuration conf) {
        this.driverQueryContextMap.get(driver).setDriverSpecificConf(conf);
    }

    public void setSelectedDriverQuery(String driverQuery) {
        if (this.driverQueryContextMap != null && this.driverQueryContextMap.get(this.getSelectedDriver()) != null) {
            this.driverQueryContextMap.get(this.getSelectedDriver()).setQuery(driverQuery);
        }
    }

    public Collection<LensDriver> getDrivers() {
        return this.driverQueryContextMap.keySet();
    }

    public Collection<String> getDriverQueries() {
        ArrayList<String> queries = new ArrayList<String>();
        Collection<DriverQueryContext> values = this.driverQueryContextMap.values();
        for (DriverQueryContext ctx : values) {
            if (ctx.getQuery() == null) continue;
            queries.add(ctx.getQuery());
        }
        return queries;
    }

    public DriverQueryPlan getDriverQueryPlan(LensDriver driver) {
        return this.driverQueryContextMap.get(driver) != null ? this.driverQueryContextMap.get(driver).getDriverQueryPlan() : null;
    }

    public Configuration getDriverConf(LensDriver driver) {
        return this.driverQueryContextMap.get(driver) != null ? this.driverQueryContextMap.get(driver).getDriverSpecificConf() : null;
    }

    public String getDriverQuery(LensDriver driver) {
        return this.driverQueryContextMap.get(driver) != null ? this.driverQueryContextMap.get(driver).getQuery() : null;
    }

    public LensDriver getSelectedDriver() {
        return this.selectedDriver;
    }

    public void setSelectedDriver(LensDriver selectedDriver) {
        this.selectedDriver = selectedDriver;
    }

    public Map<LensDriver, DriverQueryContext> getDriverQueryContextMap() {
        return this.driverQueryContextMap;
    }

    public void setDriverQueryContextMap(Map<LensDriver, DriverQueryContext> driverQueryContextMap) {
        this.driverQueryContextMap = driverQueryContextMap;
    }

    public static class DriverQueryContext {
        protected LensDriver driver;
        protected DriverQueryPlan driverQueryPlan;
        protected Configuration driverSpecificConf;
        protected Exception driverQueryPlanGenerationError;
        protected String query;

        DriverQueryContext(LensDriver driver) {
            this.driver = driver;
        }

        public LensDriver getDriver() {
            return this.driver;
        }

        public DriverQueryPlan getDriverQueryPlan() {
            return this.driverQueryPlan;
        }

        public void setDriverQueryPlan(DriverQueryPlan driverQueryPlan) {
            this.driverQueryPlan = driverQueryPlan;
        }

        public Configuration getDriverSpecificConf() {
            return this.driverSpecificConf;
        }

        public void setDriverSpecificConf(Configuration driverSpecificConf) {
            this.driverSpecificConf = driverSpecificConf;
        }

        public Exception getDriverQueryPlanGenerationError() {
            return this.driverQueryPlanGenerationError;
        }

        public void setDriverQueryPlanGenerationError(Exception driverQueryPlanGenerationError) {
            this.driverQueryPlanGenerationError = driverQueryPlanGenerationError;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }
    }
}

