/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.query;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.lens.api.LensConf;
import org.apache.lens.api.LensException;
import org.apache.lens.server.api.driver.DriverQueryPlan;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.query.DriverSelectorQueryContext;

public abstract class AbstractQueryContext
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Log LOG = LogFactory.getLog(AbstractQueryContext.class);
    protected String userQuery;
    protected transient Configuration conf;
    protected LensConf lensConf;
    protected transient DriverSelectorQueryContext driverContext;
    protected String selectedDriverQuery;
    private final String submittedUser;
    private String lensSessionIdentifier;
    private boolean isSelectedDriverQueryExplicitlySet = false;

    protected AbstractQueryContext(String query, String user, LensConf qconf, Configuration conf, Collection<LensDriver> drivers) {
        this.driverContext = new DriverSelectorQueryContext(query, conf, drivers);
        this.userQuery = query;
        this.lensConf = qconf;
        this.conf = conf;
        this.submittedUser = user;
        if (drivers != null && drivers.size() == 1) {
            this.selectedDriverQuery = query;
            this.setSelectedDriver(drivers.iterator().next());
        }
    }

    public void setDriverQueriesAndPlans(Map<LensDriver, String> driverQueries) throws LensException {
        this.driverContext.setDriverQueriesAndPlans(driverQueries, this);
        this.isSelectedDriverQueryExplicitlySet = true;
    }

    public String getSelectedDriverQuery() {
        if (this.selectedDriverQuery != null) {
            return this.selectedDriverQuery;
        }
        if (this.driverContext != null) {
            return this.driverContext.getSelectedDriverQuery();
        }
        return null;
    }

    public String getDriverQuery(LensDriver driver) {
        return this.driverContext.getDriverQuery(driver);
    }

    public Configuration getDriverConf(LensDriver driver) {
        return this.driverContext.getDriverConf(driver);
    }

    public Configuration getSelectedDriverConf() {
        if (this.driverContext != null) {
            return this.driverContext.getSelectedDriverConf();
        }
        return null;
    }

    public void setSelectedDriverQuery(String driverQuery) {
        this.selectedDriverQuery = driverQuery;
        if (this.driverContext != null) {
            this.driverContext.setSelectedDriverQuery(driverQuery);
            this.isSelectedDriverQueryExplicitlySet = true;
        }
    }

    public void setSelectedDriver(LensDriver driver) {
        if (this.driverContext != null) {
            this.driverContext.setSelectedDriver(driver);
            this.selectedDriverQuery = this.driverContext.getSelectedDriverQuery();
        }
    }

    public LensDriver getSelectedDriver() {
        if (this.driverContext != null) {
            return this.driverContext.getSelectedDriver();
        }
        return null;
    }

    public DriverQueryPlan getSelectedDriverQueryPlan() throws LensException {
        if (this.driverContext != null) {
            return this.driverContext.getSelectedDriverQueryPlan();
        }
        return null;
    }

    public String getUserQuery() {
        return this.userQuery;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public LensConf getLensConf() {
        return this.lensConf;
    }

    public DriverSelectorQueryContext getDriverContext() {
        return this.driverContext;
    }

    public void setDriverContext(DriverSelectorQueryContext driverContext) {
        this.driverContext = driverContext;
    }

    public String getSubmittedUser() {
        return this.submittedUser;
    }

    public String getLensSessionIdentifier() {
        return this.lensSessionIdentifier;
    }

    public void setLensSessionIdentifier(String lensSessionIdentifier) {
        this.lensSessionIdentifier = lensSessionIdentifier;
    }

    public boolean isSelectedDriverQueryExplicitlySet() {
        return this.isSelectedDriverQueryExplicitlySet;
    }
}

