/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.driver;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.hive.service.cli.TypeDescriptor;
import org.apache.lens.api.query.QueryResultSetMetadata;
import org.apache.lens.api.query.ResultColumn;

public abstract class LensResultSetMetadata {
    public abstract List<ColumnDescriptor> getColumns();

    public QueryResultSetMetadata toQueryResultSetMetadata() {
        ArrayList<ResultColumn> result = new ArrayList<ResultColumn>();
        for (ColumnDescriptor col : this.getColumns()) {
            result.add(new ResultColumn(col.getName(), col.getType().getName()));
        }
        return new QueryResultSetMetadata(result);
    }

    public static String getQualifiedTypeName(TypeDescriptor typeDesc) {
        if (typeDesc.getType().isQualifiedType()) {
            switch (typeDesc.getType()) {
                case VARCHAR_TYPE: {
                    return VarcharTypeInfo.getQualifiedName((String)typeDesc.getTypeName(), (int)typeDesc.getTypeQualifiers().getCharacterMaximumLength()).toLowerCase();
                }
                case CHAR_TYPE: {
                    return CharTypeInfo.getQualifiedName((String)typeDesc.getTypeName(), (int)typeDesc.getTypeQualifiers().getCharacterMaximumLength()).toLowerCase();
                }
                case DECIMAL_TYPE: {
                    return DecimalTypeInfo.getQualifiedName((int)typeDesc.getTypeQualifiers().getPrecision(), (int)typeDesc.getTypeQualifiers().getScale()).toLowerCase();
                }
            }
        } else if (typeDesc.getType().isComplexType()) {
            switch (typeDesc.getType()) {
                case ARRAY_TYPE: 
                case MAP_TYPE: 
                case STRUCT_TYPE: {
                    return "string";
                }
            }
        }
        return typeDesc.getTypeName().toLowerCase();
    }
}

