/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.driver;

import java.io.Serializable;
import org.apache.lens.api.query.QueryStatus;

public class DriverQueryStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double progress = 0.0;
    private DriverQueryState state = DriverQueryState.NEW;
    private String statusMessage;
    private boolean isResultSetAvailable = false;
    private String progressMessage;
    private String errorMessage;
    private Long driverStartTime = 0L;
    private Long driverFinishTime = 0L;

    public QueryStatus toQueryStatus() {
        QueryStatus.Status qstate = null;
        switch (this.state) {
            case NEW: 
            case INITIALIZED: 
            case PENDING: {
                qstate = QueryStatus.Status.LAUNCHED;
                break;
            }
            case RUNNING: {
                qstate = QueryStatus.Status.RUNNING;
                break;
            }
            case SUCCESSFUL: {
                qstate = QueryStatus.Status.EXECUTED;
                break;
            }
            case FAILED: {
                qstate = QueryStatus.Status.FAILED;
                break;
            }
            case CANCELED: {
                qstate = QueryStatus.Status.CANCELED;
                break;
            }
            case CLOSED: {
                qstate = QueryStatus.Status.CLOSED;
            }
        }
        return new QueryStatus(this.progress, qstate, this.statusMessage, this.isResultSetAvailable, this.progressMessage, this.errorMessage);
    }

    public static QueryStatus createQueryStatus(QueryStatus.Status state, DriverQueryStatus dstatus) {
        return new QueryStatus(dstatus.progress, state, dstatus.statusMessage, dstatus.isResultSetAvailable, dstatus.progressMessage, dstatus.errorMessage);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.state.toString()).append(':').append(this.statusMessage);
        if (this.state.equals((Object)DriverQueryState.RUNNING)) {
            str.append(" - Progress:").append(this.progress).append(":").append(this.progressMessage);
        }
        if (this.state.equals((Object)DriverQueryState.SUCCESSFUL)) {
            if (this.isResultSetAvailable) {
                str.append(" - Result Available");
            } else {
                str.append(" - Result Not Available");
            }
        }
        if (this.state.equals((Object)DriverQueryState.FAILED)) {
            str.append(" - Cause:").append(this.errorMessage);
        }
        return str.toString();
    }

    public boolean isFinished() {
        return this.state.equals((Object)DriverQueryState.SUCCESSFUL) || this.state.equals((Object)DriverQueryState.FAILED) || this.state.equals((Object)DriverQueryState.CANCELED) || this.state.equals((Object)DriverQueryState.CLOSED);
    }

    public double getProgress() {
        return this.progress;
    }

    public void setProgress(double progress) {
        this.progress = progress;
    }

    public DriverQueryState getState() {
        return this.state;
    }

    public void setState(DriverQueryState state) {
        this.state = state;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    public boolean isResultSetAvailable() {
        return this.isResultSetAvailable;
    }

    public void setResultSetAvailable(boolean isResultSetAvailable) {
        this.isResultSetAvailable = isResultSetAvailable;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Long getDriverStartTime() {
        return this.driverStartTime;
    }

    public void setDriverStartTime(Long driverStartTime) {
        this.driverStartTime = driverStartTime;
    }

    public Long getDriverFinishTime() {
        return this.driverFinishTime;
    }

    public void setDriverFinishTime(Long driverFinishTime) {
        this.driverFinishTime = driverFinishTime;
    }

    public static enum DriverQueryState {
        NEW,
        INITIALIZED,
        PENDING,
        RUNNING,
        SUCCESSFUL,
        FAILED,
        CANCELED,
        CLOSED;

    }
}

