/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.driver;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lens.api.query.QueryCost;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPlan;
import org.apache.lens.api.query.QueryPrepareHandle;

public abstract class DriverQueryPlan {
    protected int numJoins = 0;
    protected int numGbys = 0;
    protected int numSels = 0;
    protected int numSelDi = 0;
    protected int numHaving = 0;
    protected int numObys = 0;
    protected int numAggrExprs = 0;
    protected int numFilters = 0;
    protected final List<String> tablesQueried = new ArrayList<String>();
    protected boolean hasSubQuery = false;
    protected String resultDestination;
    protected ExecMode execMode;
    protected ScanMode scanMode;
    protected final Map<String, Double> tableWeights = new HashMap<String, Double>();
    protected Double joinWeight;
    protected Double gbyWeight;
    protected Double filterWeight;
    protected Double havingWeight;
    protected Double obyWeight;
    protected Double selectWeight;
    protected QueryPrepareHandle handle;

    public abstract String getPlan();

    public abstract QueryCost getCost();

    public int getNumGbys() {
        return this.numGbys;
    }

    protected void setNumGbys(int numGbys) {
        this.numGbys = numGbys;
    }

    public int getNumSels() {
        return this.numSels;
    }

    protected void setNumSels(int numSels) {
        this.numSels = numSels;
    }

    public int getNumSelDistincts() {
        return this.numSelDi;
    }

    protected void setNumSelDistincts(int numSelDi) {
        this.numSelDi = numSelDi;
    }

    public int getNumJoins() {
        return this.numJoins;
    }

    protected void setNumJoins(int numJoins) {
        this.numJoins = numJoins;
    }

    public int getNumHaving() {
        return this.numHaving;
    }

    protected void setNumHaving(int numHaving) {
        this.numHaving = numHaving;
    }

    public int getNumOrderBys() {
        return this.numObys;
    }

    protected void setNumOrderBys(int numObys) {
        this.numObys = numObys;
    }

    public List<String> getTablesQueried() {
        return this.tablesQueried;
    }

    protected void addTablesQueries(String table) {
        this.tablesQueried.add(table);
    }

    public int getNumFilters() {
        return this.numFilters;
    }

    protected void setNumFilters(int numFilters) {
        this.numFilters = numFilters;
    }

    public boolean hasSubQuery() {
        return this.hasSubQuery;
    }

    protected void setHasSubQuery() {
        this.hasSubQuery = true;
    }

    public String getResultDestination() {
        return this.resultDestination;
    }

    protected void setResultDestination(String resultDestination) {
        this.resultDestination = resultDestination;
    }

    public Map<String, Double> getTableWeights() {
        return this.tableWeights;
    }

    public Double getTableWeight(String tableName) {
        return this.tableWeights.get(tableName);
    }

    protected void setTableWeight(String tableName, Double tableWeight) {
        this.tableWeights.put(tableName, tableWeight);
    }

    public ExecMode getExecMode() {
        return this.execMode;
    }

    protected void setExecMode(ExecMode execMode) {
        this.execMode = execMode;
    }

    public ScanMode getScanMode() {
        return this.scanMode;
    }

    protected void setScanMode(ScanMode scanMode) {
        this.scanMode = scanMode;
    }

    public Double getJoinWeight() {
        return this.joinWeight;
    }

    protected void setJoinWeight(Double joinWeight) {
        this.joinWeight = joinWeight;
    }

    public Double getGbyWeight() {
        return this.gbyWeight;
    }

    protected void setGbyWeight(Double gbyWeight) {
        this.gbyWeight = gbyWeight;
    }

    public Double getFilterWeight() {
        return this.filterWeight;
    }

    protected void setFilterWeight(Double filterWeight) {
        this.filterWeight = filterWeight;
    }

    public Double getObyWeight() {
        return this.obyWeight;
    }

    protected void setObyWeight(Double obyWeight) {
        this.obyWeight = obyWeight;
    }

    public Double getHavingWeight() {
        return this.havingWeight;
    }

    protected void setHavingWeight(Double havingWeight) {
        this.havingWeight = havingWeight;
    }

    public Double getSelectWeight() {
        return this.selectWeight;
    }

    protected void setSelectWeight(Double selectWeight) {
        this.selectWeight = selectWeight;
    }

    public QueryHandle getHandle() {
        if (this.handle != null) {
            return new QueryHandle(this.handle.getPrepareHandleId());
        }
        return null;
    }

    public QueryPrepareHandle getPrepareHandle() {
        return this.handle;
    }

    public void setPrepareHandle(QueryPrepareHandle handle) {
        this.handle = handle;
    }

    public int getNumAggreagateExprs() {
        return this.numAggrExprs;
    }

    public Map<String, List<String>> getPartitions() {
        return null;
    }

    public QueryPlan toQueryPlan() throws UnsupportedEncodingException {
        return new QueryPlan(this.numJoins, this.numGbys, this.numSels, this.numSelDi, this.numHaving, this.numObys, this.numAggrExprs, this.numFilters, this.tablesQueried, this.hasSubQuery, this.execMode != null ? this.execMode.name() : null, this.scanMode != null ? this.scanMode.name() : null, this.tableWeights, this.joinWeight, this.gbyWeight, this.filterWeight, this.havingWeight, this.obyWeight, this.selectWeight, null, URLEncoder.encode(this.getPlan(), "UTF-8"), this.getCost(), false, null);
    }

    public static enum ScanMode {
        IN_MEMORY,
        INDEX_SCAN,
        PARTIAL_SCAN,
        FULL_SCAN;

    }

    public static enum ExecMode {
        INTERACTIVE,
        BATCH,
        NOT_ACCEPTED;

    }
}

