/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.server.api.driver;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hive.service.cli.ColumnDescriptor;
import org.apache.lens.api.LensException;
import org.apache.lens.api.query.QueryCost;
import org.apache.lens.api.query.QueryHandle;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.ResultRow;
import org.apache.lens.server.api.driver.DriverEvent;
import org.apache.lens.server.api.driver.DriverQueryPlan;
import org.apache.lens.server.api.driver.DriverQueryStatus;
import org.apache.lens.server.api.driver.InMemoryResultSet;
import org.apache.lens.server.api.driver.LensDriver;
import org.apache.lens.server.api.driver.LensResultSet;
import org.apache.lens.server.api.driver.LensResultSetMetadata;
import org.apache.lens.server.api.driver.PersistentResultSet;
import org.apache.lens.server.api.driver.QueryCompletionListener;
import org.apache.lens.server.api.events.LensEventListener;
import org.apache.lens.server.api.query.AbstractQueryContext;
import org.apache.lens.server.api.query.PreparedQueryContext;
import org.apache.lens.server.api.query.QueryContext;

public class MockDriver
implements LensDriver {
    Configuration conf;
    String query;
    private int ioTestVal = -1;

    public Configuration getConf() {
        return this.conf;
    }

    public void configure(Configuration conf) throws LensException {
        this.conf = conf;
        this.ioTestVal = conf.getInt("mock.driver.test.val", -1);
    }

    public DriverQueryPlan explain(AbstractQueryContext explainCtx) throws LensException {
        return new MockQueryPlan(explainCtx.getUserQuery());
    }

    public void updateStatus(QueryContext context) throws LensException {
        context.getDriverStatus().setProgress(1.0);
        context.getDriverStatus().setStatusMessage("Done");
        context.getDriverStatus().setState(DriverQueryStatus.DriverQueryState.SUCCESSFUL);
    }

    public boolean cancelQuery(QueryHandle handle) throws LensException {
        return false;
    }

    public void closeQuery(QueryHandle handle) throws LensException {
    }

    public void close() throws LensException {
    }

    public void registerDriverEventListener(LensEventListener<DriverEvent> driverEventListener) {
    }

    public void prepare(PreparedQueryContext pContext) throws LensException {
    }

    public DriverQueryPlan explainAndPrepare(PreparedQueryContext pContext) throws LensException {
        MockQueryPlan p = new MockQueryPlan(pContext.getSelectedDriverQuery());
        p.setPrepareHandle(pContext.getPrepareHandle());
        return p;
    }

    public void closePreparedQuery(QueryPrepareHandle handle) throws LensException {
    }

    public LensResultSet execute(QueryContext context) throws LensException {
        this.query = context.getSelectedDriverQuery();
        return new PersistentResultSet(){

            public int size() throws LensException {
                return 0;
            }

            public LensResultSetMetadata getMetadata() throws LensException {
                return new LensResultSetMetadata(){

                    public List<ColumnDescriptor> getColumns() {
                        return null;
                    }
                };
            }

            public String getOutputPath() throws LensException {
                return null;
            }
        };
    }

    public void executeAsync(QueryContext context) throws LensException {
        this.query = context.getSelectedDriverQuery();
    }

    public LensResultSet fetchResultSet(QueryContext context) throws LensException {
        return new InMemoryResultSet(){

            public int size() throws LensException {
                return 0;
            }

            public LensResultSetMetadata getMetadata() throws LensException {
                return new LensResultSetMetadata(){

                    public List<ColumnDescriptor> getColumns() {
                        return null;
                    }
                };
            }

            public void setFetchSize(int size) throws LensException {
            }

            public ResultRow next() throws LensException {
                return null;
            }

            public boolean hasNext() throws LensException {
                return false;
            }
        };
    }

    public void closeResultSet(QueryHandle handle) throws LensException {
    }

    public void registerForCompletionNotification(QueryHandle handle, long timeoutMillis, QueryCompletionListener listener) throws LensException {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ioTestVal = in.readInt();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.ioTestVal);
    }

    public int getTestIOVal() {
        return this.ioTestVal;
    }

    public static class MockQueryPlan
    extends DriverQueryPlan {
        String query;
        private Map<String, List<String>> partitions;

        MockQueryPlan(String query) {
            this.query = query;
            this.setPrepareHandle(new QueryPrepareHandle(UUID.randomUUID()));
            this.tableWeights.put("table1", 1.0);
            this.tableWeights.put("table2", 2.0);
            this.tableWeights.put("table3", 3.0);
        }

        public String getPlan() {
            return this.query;
        }

        public QueryCost getCost() {
            return new QueryCost(0L, 0.0);
        }

        public Map<String, List<String>> getPartitions() {
            return this.partitions;
        }

        public void setPartitions(Map<String, List<String>> partitions) {
            this.partitions = partitions;
        }
    }
}

