/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.common.logging;

import com.google.common.collect.Lists;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.spark.utils.SparkHadoopUtils;

public abstract class AbstractHdfsLogAppender
extends AppenderSkeleton {
    private final Object flushLogLock = new Object();
    private final Object initWriterLock = new Object();
    private final Object closeLock = new Object();
    private final Object fileSystemLock = new Object();
    private FSDataOutputStream outStream = null;
    private BufferedWriter bufferedWriter = null;
    private FileSystem fileSystem = null;
    private ExecutorService appendHdfsService = null;
    private BlockingDeque<LoggingEvent> logBufferQue = null;
    private static final double QUEUE_FLUSH_THRESHOLD = 0.2;
    private int logQueueCapacity = 8192;
    private int flushInterval = 5000;
    private String hdfsWorkingDir;

    public int getLogQueueCapacity() {
        return this.logQueueCapacity;
    }

    public void setLogQueueCapacity(int logQueueCapacity) {
        this.logQueueCapacity = logQueueCapacity;
    }

    public BlockingDeque<LoggingEvent> getLogBufferQue() {
        return this.logBufferQue;
    }

    public int getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(int flushInterval) {
        this.flushInterval = flushInterval;
    }

    public String getHdfsWorkingDir() {
        return this.hdfsWorkingDir;
    }

    public void setHdfsWorkingDir(String hdfsWorkingDir) {
        this.hdfsWorkingDir = hdfsWorkingDir;
    }

    public FileSystem getFileSystem() {
        if (null == this.fileSystem) {
            return this.getFileSystem(SparkHadoopUtils.newConfigurationWithSparkConf());
        }
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileSystem getFileSystem(Configuration conf) {
        Object object = this.fileSystemLock;
        synchronized (object) {
            if (null == this.fileSystem) {
                try {
                    this.fileSystem = new Path(this.hdfsWorkingDir).getFileSystem(conf);
                }
                catch (IOException e) {
                    LogLog.error((String)"Failed to create the file system, ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
        return this.fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWriterInited() {
        Object object = this.initWriterLock;
        synchronized (object) {
            return null != this.bufferedWriter;
        }
    }

    abstract void init();

    abstract String getAppenderName();

    public void activateOptions() {
        LogLog.warn((String)String.format(Locale.ROOT, "%s starting ...", this.getAppenderName()));
        LogLog.warn((String)("hdfsWorkingDir -> " + this.getHdfsWorkingDir()));
        this.init();
        this.logBufferQue = new LinkedBlockingDeque<LoggingEvent>(this.getLogQueueCapacity());
        this.appendHdfsService = Executors.newSingleThreadExecutor();
        this.appendHdfsService.execute(this::checkAndFlushLog);
        Runtime.getRuntime().addShutdownHook(new Thread(this::closing));
        LogLog.warn((String)String.format(Locale.ROOT, "%s started ...", this.getAppenderName()));
    }

    public void append(LoggingEvent loggingEvent) {
        try {
            boolean offered = this.logBufferQue.offer(loggingEvent, 10L, TimeUnit.SECONDS);
            if (!offered) {
                LogLog.error((String)"LogEvent cannot put into the logBufferQue, log event content:");
                this.printLoggingEvent(loggingEvent);
            }
        }
        catch (InterruptedException e) {
            LogLog.warn((String)"Append logging event interrupted!", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closing() {
        LogLog.warn((String)String.format(Locale.ROOT, "%s flush log when shutdown ...", this.getAppenderName()));
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                ArrayList transaction = Lists.newArrayList();
                try {
                    this.flushLog(this.getLogBufferQue().size(), transaction);
                }
                catch (Exception e) {
                    transaction.forEach(this::printLoggingEvent);
                    try {
                        while (!this.getLogBufferQue().isEmpty()) {
                            this.printLoggingEvent(this.getLogBufferQue().take());
                        }
                    }
                    catch (Exception ie) {
                        LogLog.error((String)"clear the logging buffer queue failed!", (Throwable)ie);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogLog.warn((String)String.format(Locale.ROOT, "%s attempt to closing ...", this.getAppenderName()));
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.closed) {
                this.closed = true;
                ArrayList transaction = Lists.newArrayList();
                try {
                    this.flushLog(this.getLogBufferQue().size(), transaction);
                    if (this.appendHdfsService != null && !this.appendHdfsService.isShutdown()) {
                        this.appendHdfsService.shutdownNow();
                    }
                    this.closeWriter();
                }
                catch (Exception e) {
                    transaction.forEach(this::printLoggingEvent);
                    try {
                        while (!this.getLogBufferQue().isEmpty()) {
                            this.printLoggingEvent(this.getLogBufferQue().take());
                        }
                    }
                    catch (Exception ie) {
                        LogLog.error((String)"clear the logging buffer queue failed!", (Throwable)ie);
                    }
                    LogLog.error((String)String.format(Locale.ROOT, "close %s failed!", this.getAppenderName()), (Throwable)e);
                }
                LogLog.warn((String)String.format(Locale.ROOT, "%s closed ...", this.getAppenderName()));
            }
        }
    }

    private void closeWriter() {
        IOUtils.closeQuietly((Writer)this.bufferedWriter);
        IOUtils.closeQuietly((OutputStream)this.outStream);
    }

    public boolean requiresLayout() {
        return true;
    }

    abstract boolean isSkipCheckAndFlushLog();

    private void clearLogBufferQueueWhenBlocked() {
        if (this.logBufferQue.size() >= this.getLogQueueCapacity()) {
            for (int removeNum = this.getLogQueueCapacity() / 5; removeNum > 0; --removeNum) {
                try {
                    LoggingEvent loggingEvent = this.logBufferQue.take();
                    this.printLoggingEvent(loggingEvent);
                    continue;
                }
                catch (Exception ex) {
                    LogLog.error((String)"Take event interrupted!", (Throwable)ex);
                }
            }
        }
    }

    private void printLoggingEvent(LoggingEvent loggingEvent) {
        try {
            String log = this.getLayout().format(loggingEvent);
            LogLog.error((String)(log.endsWith("\n") ? log.substring(0, log.length() - 1) : log));
            if (null != loggingEvent.getThrowableStrRep()) {
                for (String stack : loggingEvent.getThrowableStrRep()) {
                    LogLog.error((String)stack);
                }
            }
        }
        catch (Exception e) {
            LogLog.error((String)"print logging event failed!", (Throwable)e);
        }
    }

    protected void checkAndFlushLog() {
        long start = System.currentTimeMillis();
        do {
            ArrayList transaction = Lists.newArrayList();
            try {
                if (this.isSkipCheckAndFlushLog()) continue;
                int eventSize = this.getLogBufferQue().size();
                if ((double)eventSize > (double)this.getLogQueueCapacity() * 0.2 || System.currentTimeMillis() - start > (long)this.getFlushInterval()) {
                    start = System.currentTimeMillis();
                    this.flushLog(eventSize, transaction);
                    continue;
                }
                Thread.sleep(this.getFlushInterval() / 100);
            }
            catch (Exception e) {
                transaction.forEach(this::printLoggingEvent);
                this.clearLogBufferQueueWhenBlocked();
                LogLog.error((String)"Error occurred when consume event", (Throwable)e);
            }
        } while (!this.closed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initHdfsWriter(Path outPath, Configuration conf) {
        Object object = this.initWriterLock;
        synchronized (object) {
            this.closeWriter();
            this.bufferedWriter = null;
            this.outStream = null;
            int retry = 10;
            while (retry-- > 0) {
                try {
                    this.fileSystem = this.getFileSystem(conf);
                    this.outStream = this.fileSystem.create(outPath, true);
                    break;
                }
                catch (Exception e) {
                    LogLog.error((String)("fail to create stream for path: " + outPath), (Throwable)e);
                    try {
                        this.initWriterLock.wait(1000L);
                    }
                    catch (InterruptedException e2) {
                        LogLog.warn((String)"Init writer interrupted!", (Throwable)e2);
                        Thread.currentThread().interrupt();
                    }
                }
            }
            if (null != this.outStream) {
                this.bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.outStream, StandardCharsets.UTF_8));
                return true;
            }
        }
        return false;
    }

    protected void write(String message) throws IOException {
        if (this.isWriterInited()) {
            this.bufferedWriter.write(message);
        }
    }

    protected void writeLogEvent(LoggingEvent loggingEvent) throws IOException {
        if (null != loggingEvent) {
            this.write(this.getLayout().format(loggingEvent));
            if (null != loggingEvent.getThrowableStrRep()) {
                for (String message : loggingEvent.getThrowableStrRep()) {
                    this.write(message);
                    this.write("\n");
                }
            }
        }
    }

    abstract void doWriteLog(int var1, List<LoggingEvent> var2) throws IOException, InterruptedException;

    private void flush() throws IOException {
        if (this.isWriterInited()) {
            this.bufferedWriter.flush();
            this.outStream.hsync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushLog(int eventSize, List<LoggingEvent> transaction) throws IOException, InterruptedException {
        if (eventSize <= 0) {
            return;
        }
        Object object = this.flushLogLock;
        synchronized (object) {
            if (eventSize > this.getLogBufferQue().size()) {
                eventSize = this.getLogBufferQue().size();
            }
            this.doWriteLog(eventSize, transaction);
            this.flush();
        }
    }
}

