/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.HttpHost;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.auth.AuthSchemeFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.auth.AuthSchemeProvider;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.auth.AuthScope;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.CredentialsProvider;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.methods.HttpPost;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.methods.HttpUriRequest;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.protocol.HttpClientContext;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.config.Lookup;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.config.RegistryBuilder;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.entity.ContentType;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.client.BasicAuthCache;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.client.HttpClients;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.HttpRequestExecutor;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.RequestConnControl;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.RequestContent;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.protocol.RequestTargetHost;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.org.apache.http.util.EntityUtils;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AuthenticationType;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import org.apache.kylin.jdbc.shaded.org.apache.calcite.avatica.remote.UsernamePasswordAuthenticateable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvaticaCommonsHttpClientImpl
implements AvaticaHttpClient,
UsernamePasswordAuthenticateable {
    private static final Logger LOG = LoggerFactory.getLogger(AvaticaCommonsHttpClientImpl.class);
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_KEY = "avatica.pooled.connections.per.route";
    private static final String MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT = "25";
    private static final String MAX_POOLED_CONNECTIONS_KEY = "avatica.pooled.connections.max";
    private static final String MAX_POOLED_CONNECTIONS_DEFAULT = "100";
    protected final HttpHost host;
    protected final URL url;
    protected final HttpProcessor httpProcessor;
    protected final HttpRequestExecutor httpExecutor;
    protected final BasicAuthCache authCache;
    protected final CloseableHttpClient client;
    final PoolingHttpClientConnectionManager pool;
    protected UsernamePasswordCredentials credentials = null;
    protected CredentialsProvider credentialsProvider = null;
    protected Lookup<AuthSchemeProvider> authRegistry = null;

    public AvaticaCommonsHttpClientImpl(URL url) {
        this.host = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        this.url = Objects.requireNonNull(url);
        this.httpProcessor = HttpProcessorBuilder.create().add(new RequestContent()).add(new RequestTargetHost()).add(new RequestConnControl()).add(new RequestExpectContinue()).build();
        this.httpExecutor = new HttpRequestExecutor();
        this.pool = new PoolingHttpClientConnectionManager();
        String maxCnxns = System.getProperty(MAX_POOLED_CONNECTIONS_KEY, MAX_POOLED_CONNECTIONS_DEFAULT);
        this.pool.setMaxTotal(Integer.parseInt(maxCnxns));
        String maxCnxnsPerRoute = System.getProperty(MAX_POOLED_CONNECTION_PER_ROUTE_KEY, MAX_POOLED_CONNECTION_PER_ROUTE_DEFAULT);
        this.pool.setDefaultMaxPerRoute(Integer.parseInt(maxCnxnsPerRoute));
        this.authCache = new BasicAuthCache();
        this.client = HttpClients.custom().setConnectionManager(this.pool).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        HttpClientContext context = HttpClientContext.create();
        context.setTargetHost(this.host);
        if (null != this.credentials) {
            context.setCredentialsProvider(this.credentialsProvider);
            context.setAuthSchemeRegistry(this.authRegistry);
            context.setAuthCache(this.authCache);
        }
        ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
        HttpPost post = new HttpPost(AvaticaCommonsHttpClientImpl.toURI(this.url));
        post.setEntity(entity);
        try (CloseableHttpResponse response = this.client.execute((HttpUriRequest)post, context);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (200 == statusCode || 500 == statusCode) {
                byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                return byArray;
            }
            throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.debug("Failed to execute HTTP request", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setUsernamePassword(AuthenticationType authType, String username, String password) {
        this.credentials = new UsernamePasswordCredentials(Objects.requireNonNull(username), Objects.requireNonNull(password));
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, this.credentials);
        RegistryBuilder<AuthSchemeFactory> authRegistryBuilder = RegistryBuilder.create();
        switch (authType) {
            case BASIC: {
                authRegistryBuilder.register("Basic", new BasicSchemeFactory());
                break;
            }
            case DIGEST: {
                authRegistryBuilder.register("Digest", new DigestSchemeFactory());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentiation type: " + (Object)((Object)authType));
            }
        }
        this.authRegistry = authRegistryBuilder.build();
    }

    private static URI toURI(URL url) throws RuntimeException {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

