/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.cluster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.shaded.com.google.common.base.Joiner;
import org.apache.kudu.shaded.com.google.common.collect.Lists;
import org.apache.kudu.test.cluster.KuduBinaryLocator;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class KuduBinaryInfo {
    private final String binDir;
    private final String saslDir;

    public KuduBinaryInfo(String binDir, String saslDir) {
        this.binDir = binDir;
        this.saslDir = saslDir;
    }

    public KuduBinaryInfo(String binDir) {
        this(binDir, null);
    }

    public String getBinDir() {
        return this.binDir;
    }

    public String getSaslDir() {
        return this.saslDir;
    }

    public static SanitizerType getSanitizerType() {
        List<String> vs = KuduBinaryInfo.getBinaryVersionStrings();
        if (vs.size() < 1 || !vs.get(0).startsWith("kudu ")) {
            throw new RuntimeException(String.format("unexpected version output from kudu binary: %s", Joiner.on("\n").join(vs)));
        }
        for (String s : vs) {
            if (s.equals("ASAN enabled")) {
                return SanitizerType.ASAN;
            }
            if (!s.equals("TSAN enabled")) continue;
            return SanitizerType.TSAN;
        }
        return SanitizerType.NONE;
    }

    private static List<String> getBinaryVersionStrings() {
        try {
            KuduBinaryLocator.ExecutableInfo exeInfo = KuduBinaryLocator.findBinary("kudu");
            ProcessBuilder pb = new ProcessBuilder(Lists.newArrayList(exeInfo.exePath(), "--version"));
            pb.environment().putAll(exeInfo.environment());
            pb.redirectError(ProcessBuilder.Redirect.INHERIT);
            Process p = pb.start();
            ArrayList<String> result = new ArrayList<String>();
            try (InputStreamReader isr = new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    result.add(line);
                }
            }
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                throw new RuntimeException(String.format("unexpected exit code from kudu binary: %d", exitCode));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception while trying to run kudu binary", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("unexpected exception while trying to run kudu binary", e);
        }
    }

    public static enum SanitizerType {
        NONE,
        ASAN,
        TSAN;

    }
}

