/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.test.cluster;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.kudu.shaded.com.google.common.base.Throwables;
import org.apache.kudu.shaded.com.google.common.net.InetAddresses;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FakeDNS {
    static FakeDNS instance = new FakeDNS();
    @GuardedBy(value="this")
    private Map<String, InetAddress> forwardResolutions = new HashMap<String, InetAddress>();
    @GuardedBy(value="this")
    private Map<InetAddress, String> reverseResolutions = new HashMap<InetAddress, String>();
    @GuardedBy(value="this")
    private boolean installed = false;

    private FakeDNS() {
    }

    public static FakeDNS getInstance() {
        return instance;
    }

    public synchronized void addForwardResolution(String hostname, InetAddress ip) {
        this.forwardResolutions.put(hostname, ip);
    }

    public synchronized void addReverseResolution(InetAddress ip, String hostname) {
        this.reverseResolutions.put(ip, hostname);
    }

    public synchronized void install() {
        if (this.installed) {
            return;
        }
        try {
            try {
                Class<?> nameServiceInterface = Class.forName("java.net.InetAddress$NameService");
                Field field = InetAddress.class.getDeclaredField("nameService");
                Method method = InetAddress.class.getDeclaredMethod("createNameService", new Class[0]);
                method.setAccessible(true);
                Object fallbackNameService = method.invoke(null, new Object[0]);
                Object proxy = Proxy.newProxyInstance(nameServiceInterface.getClassLoader(), new Class[]{nameServiceInterface}, (InvocationHandler)new NameServiceListener(fallbackNameService));
                field.setAccessible(true);
                field.set(InetAddress.class, proxy);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                Class<?> nameServiceInterface = Class.forName("sun.net.spi.nameservice.NameService");
                Field field = InetAddress.class.getDeclaredField("nameServices");
                Method method = InetAddress.class.getDeclaredMethod("createNSProvider", String.class);
                method.setAccessible(true);
                Object fallbackNameService = method.invoke(null, "default");
                Object proxy = Proxy.newProxyInstance(nameServiceInterface.getClassLoader(), new Class[]{nameServiceInterface}, (InvocationHandler)new NameServiceListener(fallbackNameService));
                field.setAccessible(true);
                field.set(InetAddress.class, Arrays.asList(proxy));
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.installed = true;
    }

    private class NameServiceListener
    implements InvocationHandler {
        private final Object fallbackNameService;

        NameServiceListener(Object fallbackNameService) {
            this.fallbackNameService = fallbackNameService;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InetAddress[] lookupAllHostAddr(String host) throws UnknownHostException {
            InetAddress inetAddress;
            FakeDNS fakeDNS = FakeDNS.this;
            synchronized (fakeDNS) {
                inetAddress = (InetAddress)FakeDNS.this.forwardResolutions.get(host);
            }
            if (inetAddress != null) {
                return new InetAddress[]{inetAddress};
            }
            try {
                Method method = this.fallbackNameService.getClass().getDeclaredMethod("lookupAllHostAddr", String.class);
                method.setAccessible(true);
                return (InetAddress[])method.invoke(this.fallbackNameService, host);
            }
            catch (ReflectiveOperationException e) {
                Throwables.propagateIfPossible(e.getCause(), UnknownHostException.class);
                throw new AssertionError("unexpected reflection issue", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getHostByAddr(byte[] addr) throws UnknownHostException {
            String hostname;
            if (addr[0] == 127) {
                return InetAddresses.toAddrString(InetAddress.getByAddress(addr));
            }
            FakeDNS fakeDNS = FakeDNS.this;
            synchronized (fakeDNS) {
                hostname = (String)FakeDNS.this.reverseResolutions.get(InetAddress.getByAddress(addr));
            }
            if (hostname != null) {
                return hostname;
            }
            try {
                Method method = this.fallbackNameService.getClass().getDeclaredMethod("getHostByAddr", byte[].class);
                method.setAccessible(true);
                return (String)method.invoke(this.fallbackNameService, new Object[]{addr});
            }
            catch (ReflectiveOperationException e) {
                Throwables.propagateIfPossible(e.getCause(), UnknownHostException.class);
                throw new AssertionError("unexpected reflection issue", e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            switch (method.getName()) {
                case "lookupAllHostAddr": {
                    return this.lookupAllHostAddr((String)args[0]);
                }
                case "getHostByAddr": {
                    return this.getHostByAddr((byte[])args[0]);
                }
            }
            throw new UnsupportedOperationException();
        }
    }
}

