/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.com.google.gradle.osdetector;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.kudu.shaded.kr.motd.maven.os.Detector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsDetector {
    private static final Logger logger = LoggerFactory.getLogger((String)OsDetector.class.getName());
    private final List<String> classifierWithLikes = new ArrayList<String>();
    private Impl impl;

    public String getOs() {
        return (String)this.getImpl().detectedProperties.get("os.detected.name");
    }

    public String getArch() {
        return (String)this.getImpl().detectedProperties.get("os.detected.arch");
    }

    public String getClassifier() {
        return (String)this.getImpl().detectedProperties.get("os.detected.classifier");
    }

    public Release getRelease() {
        Impl impl = this.getImpl();
        Object releaseId = impl.detectedProperties.get("os.detected.release");
        if (releaseId == null) {
            return null;
        }
        return new Release(impl);
    }

    public synchronized void setClassifierWithLikes(List<String> classifierWithLikes) {
        if (this.impl != null) {
            throw new IllegalStateException("classifierWithLikes must be set before osdetector is read.");
        }
        this.classifierWithLikes.clear();
        this.classifierWithLikes.addAll(classifierWithLikes);
    }

    private synchronized Impl getImpl() {
        if (this.impl == null) {
            this.impl = new Impl(this.classifierWithLikes);
        }
        return this.impl;
    }

    private static class Impl
    extends Detector {
        final Properties detectedProperties = System.getProperties();

        @Override
        protected void log(String message) {
            logger.info(message);
        }

        @Override
        protected void logProperty(String name, String value) {
            logger.info(name + "=" + value);
        }

        Impl(List<String> classifierWithLikes) {
            this.detect(this.detectedProperties, classifierWithLikes);
        }
    }

    public static class Release {
        private final Impl impl;

        private Release(Impl impl) {
            this.impl = impl;
        }

        public String getId() {
            return (String)this.impl.detectedProperties.get("os.detected.release");
        }

        public String getVersion() {
            return (String)this.impl.detectedProperties.get("os.detected.release.version");
        }

        public boolean isLike(String baseRelease) {
            return this.impl.detectedProperties.containsKey("os.detected.release.like." + baseRelease);
        }
    }
}

