/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.step;

import java.util.concurrent.TimeUnit;
import java.util.function.ToDoubleFunction;
import java.util.function.ToLongFunction;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Clock;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Counter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.DistributionSummary;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.FunctionTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.LongTaskTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Measurement;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.HistogramGauges;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.pause.PauseDetector;
import org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultGauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultLongTaskTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.internal.DefaultMeter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.push.PushMeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepDistributionSummary;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepFunctionCounter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepFunctionTimer;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepRegistryConfig;
import org.apache.kudu.shaded.io.micrometer.core.instrument.step.StepTimer;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

public abstract class StepMeterRegistry
extends PushMeterRegistry {
    private final StepRegistryConfig config;

    public StepMeterRegistry(StepRegistryConfig config, Clock clock) {
        super(config, clock);
        this.config = config;
    }

    @Override
    protected <T> Gauge newGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> valueFunction) {
        return new DefaultGauge<T>(id, obj, valueFunction);
    }

    @Override
    protected Counter newCounter(Meter.Id id) {
        return new StepCounter(id, this.clock, this.config.step().toMillis());
    }

    @Override
    protected LongTaskTimer newLongTaskTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig) {
        DefaultLongTaskTimer ltt = new DefaultLongTaskTimer(id, this.clock, this.getBaseTimeUnit(), distributionStatisticConfig, false);
        HistogramGauges.registerWithCommonFormat(ltt, (MeterRegistry)this);
        return ltt;
    }

    @Override
    protected Timer newTimer(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector) {
        StepTimer timer = new StepTimer(id, this.clock, distributionStatisticConfig, pauseDetector, this.getBaseTimeUnit(), this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(timer, (MeterRegistry)this);
        return timer;
    }

    @Override
    protected DistributionSummary newDistributionSummary(Meter.Id id, DistributionStatisticConfig distributionStatisticConfig, double scale) {
        StepDistributionSummary summary = new StepDistributionSummary(id, this.clock, distributionStatisticConfig, scale, this.config.step().toMillis(), false);
        HistogramGauges.registerWithCommonFormat(summary, (MeterRegistry)this);
        return summary;
    }

    @Override
    protected <T> FunctionTimer newFunctionTimer(Meter.Id id, T obj, ToLongFunction<T> countFunction, ToDoubleFunction<T> totalTimeFunction, TimeUnit totalTimeFunctionUnit) {
        return new StepFunctionTimer<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction, totalTimeFunction, totalTimeFunctionUnit, this.getBaseTimeUnit());
    }

    @Override
    protected <T> FunctionCounter newFunctionCounter(Meter.Id id, T obj, ToDoubleFunction<T> countFunction) {
        return new StepFunctionCounter<T>(id, this.clock, this.config.step().toMillis(), obj, countFunction);
    }

    @Override
    protected Meter newMeter(Meter.Id id, Meter.Type type, Iterable<Measurement> measurements) {
        return new DefaultMeter(id, type, measurements);
    }

    @Override
    protected DistributionStatisticConfig defaultHistogramConfig() {
        return DistributionStatisticConfig.builder().expiry(this.config.step()).build().merge(DistributionStatisticConfig.DEFAULT);
    }
}

