/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.netty.handler.codec.mqtt;

import org.apache.kudu.shaded.io.netty.handler.codec.mqtt.MqttQoS;
import org.apache.kudu.shaded.io.netty.handler.codec.mqtt.MqttSubscriptionOption;
import org.apache.kudu.shaded.io.netty.util.internal.StringUtil;

public final class MqttTopicSubscription {
    private final String topicFilter;
    private final MqttSubscriptionOption option;

    public MqttTopicSubscription(String topicFilter, MqttQoS qualityOfService) {
        this.topicFilter = topicFilter;
        this.option = MqttSubscriptionOption.onlyFromQos(qualityOfService);
    }

    public MqttTopicSubscription(String topicFilter, MqttSubscriptionOption option) {
        this.topicFilter = topicFilter;
        this.option = option;
    }

    public String topicName() {
        return this.topicFilter;
    }

    public MqttQoS qualityOfService() {
        return this.option.qos();
    }

    public MqttSubscriptionOption option() {
        return this.option;
    }

    public String toString() {
        return StringUtil.simpleClassName(this) + '[' + "topicFilter=" + this.topicFilter + ", option=" + this.option + ']';
    }
}

