/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.client;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.ColumnTypeAttributes;
import org.apache.kudu.Schema;
import org.apache.kudu.Type;
import org.apache.kudu.client.Bytes;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.util.Slice;
import org.apache.kudu.util.TimestampUtil;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
class ColumnarRowResult
extends RowResult {
    private final Slice[] data;
    private final Slice[] varlenData;
    private final Slice[] nonNullBitmaps;

    ColumnarRowResult(Schema schema, Slice[] data, Slice[] varlenData, Slice[] nonNullBitmaps, int rowIndex) {
        super(schema, rowIndex);
        this.data = data;
        this.varlenData = varlenData;
        this.nonNullBitmaps = nonNullBitmaps;
        this.advancePointerTo(rowIndex);
    }

    @Override
    public int getInt(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT32, Type.DATE);
        return Bytes.getInt(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 4);
    }

    @Override
    public short getShort(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT16);
        return Bytes.getShort(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 2);
    }

    @Override
    public boolean getBoolean(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BOOL);
        byte b = Bytes.getByte(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index);
        return b == 1;
    }

    @Override
    public byte getByte(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.INT8);
        return Bytes.getByte(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index);
    }

    @Override
    public float getFloat(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.FLOAT);
        return Bytes.getFloat(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 4);
    }

    @Override
    public double getDouble(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DOUBLE);
        return Bytes.getDouble(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 8);
    }

    @Override
    public BigDecimal getDecimal(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.DECIMAL);
        ColumnSchema column = this.schema.getColumnByIndex(columnIndex);
        ColumnTypeAttributes typeAttributes = column.getTypeAttributes();
        return Bytes.getDecimal(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + Type.DECIMAL.getSize(typeAttributes) * this.index, typeAttributes.getPrecision(), typeAttributes.getScale());
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.UNIXTIME_MICROS);
        long micros = this.getLong(columnIndex);
        return TimestampUtil.microsToTimestamp(micros);
    }

    @Override
    public String getVarLengthData(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.STRING, Type.VARCHAR);
        int offset = this.getOffsetForCurrentRow(columnIndex);
        int length = this.getOffsetForNextRow(columnIndex) - offset;
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return Bytes.getString(this.varlenData[columnIndex].getRawArray(), this.varlenData[columnIndex].getRawOffset() + offset, length);
    }

    @Override
    public byte[] getBinaryCopy(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        int offset = this.getOffsetForCurrentRow(columnIndex);
        int length = this.getOffsetForNextRow(columnIndex) - offset;
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        byte[] ret = new byte[length];
        System.arraycopy(this.varlenData[columnIndex].getRawArray(), this.varlenData[columnIndex].getRawOffset() + offset, ret, 0, length);
        return ret;
    }

    @Override
    public ByteBuffer getBinary(int columnIndex) {
        this.checkValidColumn(columnIndex);
        this.checkNull(columnIndex);
        this.checkType(columnIndex, Type.BINARY);
        int offset = this.getOffsetForCurrentRow(columnIndex);
        int length = this.getOffsetForNextRow(columnIndex) - offset;
        assert (offset < Integer.MAX_VALUE);
        assert (length < Integer.MAX_VALUE);
        return ByteBuffer.wrap(this.varlenData[columnIndex].getRawArray(), this.varlenData[columnIndex].getRawOffset() + offset, length);
    }

    @Override
    public long getLong(int columnIndex) {
        return Bytes.getLong(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 8);
    }

    protected int getOffsetForCurrentRow(int columnIndex) {
        return Bytes.getInt(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + this.index * 4);
    }

    protected int getOffsetForNextRow(int columnIndex) {
        return Bytes.getInt(this.data[columnIndex].getRawArray(), this.data[columnIndex].getRawOffset() + (this.index + 1) * 4);
    }

    @Override
    public boolean isNull(int columnIndex) {
        this.checkValidColumn(columnIndex);
        if (!this.schema.getColumnByIndex(columnIndex).isNullable()) {
            return false;
        }
        byte flag = Bytes.getByte(this.nonNullBitmaps[columnIndex].getRawArray(), this.nonNullBitmaps[columnIndex].getRawOffset() + this.index / 8);
        boolean nonNull = (flag & 1 << this.index % 8) != 0;
        return !nonNull;
    }

    public String toString() {
        return "ColumnarRowResult index: " + this.index;
    }
}

