/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.spark.kudu;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Locale;
import org.apache.kudu.client.AsyncKuduClient;
import org.apache.kudu.client.ReplicaSelection;
import org.apache.kudu.spark.kudu.Delete$;
import org.apache.kudu.spark.kudu.DeleteIgnore$;
import org.apache.kudu.spark.kudu.Insert$;
import org.apache.kudu.spark.kudu.InsertIgnore$;
import org.apache.kudu.spark.kudu.KuduReadOptions;
import org.apache.kudu.spark.kudu.KuduReadOptions$;
import org.apache.kudu.spark.kudu.KuduRelation;
import org.apache.kudu.spark.kudu.KuduSink;
import org.apache.kudu.spark.kudu.KuduWriteOptions;
import org.apache.kudu.spark.kudu.KuduWriteOptions$;
import org.apache.kudu.spark.kudu.OperationType;
import org.apache.kudu.spark.kudu.Update$;
import org.apache.kudu.spark.kudu.UpdateIgnore$;
import org.apache.kudu.spark.kudu.Upsert$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@InterfaceAudience.Private
@InterfaceStability.Unstable
@ScalaSignature(bytes="\u0006\u0001\t\u001de\u0001B\u001d;\u0001\u0011CQ\u0001\u0019\u0001\u0005\u0002\u0005Dq\u0001\u001a\u0001C\u0002\u0013\u0005Q\r\u0003\u0004o\u0001\u0001\u0006IA\u001a\u0005\b_\u0002\u0011\r\u0011\"\u0001f\u0011\u0019\u0001\b\u0001)A\u0005M\"9\u0011\u000f\u0001b\u0001\n\u0003)\u0007B\u0002:\u0001A\u0003%a\rC\u0004t\u0001\t\u0007I\u0011A3\t\rQ\u0004\u0001\u0015!\u0003g\u0011\u001d)\bA1A\u0005\u0002\u0015DaA\u001e\u0001!\u0002\u00131\u0007bB<\u0001\u0005\u0004%\t!\u001a\u0005\u0007q\u0002\u0001\u000b\u0011\u00024\t\u000fe\u0004!\u0019!C\u0001K\"1!\u0010\u0001Q\u0001\n\u0019Dqa\u001f\u0001C\u0002\u0013\u0005Q\r\u0003\u0004}\u0001\u0001\u0006IA\u001a\u0005\b{\u0002\u0011\r\u0011\"\u0001f\u0011\u0019q\b\u0001)A\u0005M\"9q\u0010\u0001b\u0001\n\u0003)\u0007bBA\u0001\u0001\u0001\u0006IA\u001a\u0005\t\u0003\u0007\u0001!\u0019!C\u0001K\"9\u0011Q\u0001\u0001!\u0002\u00131\u0007\u0002CA\u0004\u0001\t\u0007I\u0011A3\t\u000f\u0005%\u0001\u0001)A\u0005M\"A\u00111\u0002\u0001C\u0002\u0013\u0005Q\rC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u00024\t\u0011\u0005=\u0001A1A\u0005\u0002\u0015Dq!!\u0005\u0001A\u0003%a\r\u0003\u0005\u0002\u0014\u0001\u0011\r\u0011\"\u0001f\u0011\u001d\t)\u0002\u0001Q\u0001\n\u0019D\u0001\"a\u0006\u0001\u0005\u0004%\t!\u001a\u0005\b\u00033\u0001\u0001\u0015!\u0003g\u0011!\tY\u0002\u0001b\u0001\n\u0003)\u0007bBA\u000f\u0001\u0001\u0006IA\u001a\u0005\t\u0003?\u0001!\u0019!C\u0001K\"9\u0011\u0011\u0005\u0001!\u0002\u00131\u0007\u0002CA\u0012\u0001\t\u0007I\u0011A3\t\u000f\u0005\u0015\u0002\u0001)A\u0005M\"A\u0011q\u0005\u0001C\u0002\u0013\u0005Q\rC\u0004\u0002*\u0001\u0001\u000b\u0011\u00024\t\u000f\u0005-\u0002\u0001\"\u0011\u0002.!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA\"\u0001\u0011\u0005\u00131\r\u0005\b\u0003\u0007\u0002A\u0011IA=\u0011\u001d\tY\u000b\u0001C!\u0003[Cq!!:\u0001\t\u0013\t9\u000fC\u0004\u0002l\u0002!I!!<\t\u000f\u0005]\b\u0001\"\u0003\u0002z\"9!1\u0001\u0001\u0005\n\t\u0015\u0001b\u0002B\u0005\u0001\u0011%!1\u0002\u0005\b\u0005\u001f\u0001A\u0011\u0002B\t\u0011\u001d\u0011Y\u0002\u0001C\u0005\u0005;AqAa\u000f\u0001\t\u0013\u0011i\u0004C\u0004\u0003L\u0001!IA!\u0014\t\u000f\t]\u0003\u0001\"\u0003\u0003Z\tiA)\u001a4bk2$8k\\;sG\u0016T!a\u000f\u001f\u0002\t-,H-\u001e\u0006\u0003{y\nQa\u001d9be.T!aO \u000b\u0005\u0001\u000b\u0015AB1qC\u000eDWMC\u0001C\u0003\ry'oZ\u0002\u0001'\u001d\u0001Qi\u0013+X5v\u0003\"AR%\u000e\u0003\u001dS\u0011\u0001S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0015\u001e\u0013a!\u00118z%\u00164\u0007C\u0001'S\u001b\u0005i%B\u0001(P\u0003\u001d\u0019x.\u001e:dKNT!\u0001U)\u0002\u0007M\fHN\u0003\u0002>\u007f%\u00111+\u0014\u0002\u0013\t\u0006$\u0018mU8ve\u000e,'+Z4jgR,'\u000f\u0005\u0002M+&\u0011a+\u0014\u0002\u0011%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"\u0001\u0014-\n\u0005ek%!G\"sK\u0006$\u0018M\u00197f%\u0016d\u0017\r^5p]B\u0013xN^5eKJ\u0004\"\u0001T.\n\u0005qk%AF*dQ\u0016l\u0017MU3mCRLwN\u001c)s_ZLG-\u001a:\u0011\u00051s\u0016BA0N\u0005I\u0019FO]3b[NKgn\u001b)s_ZLG-\u001a:\u0002\rqJg.\u001b;?)\u0005\u0011\u0007CA2\u0001\u001b\u0005Q\u0014!\u0003+B\u00052+ulS#Z+\u00051\u0007CA4m\u001b\u0005A'BA5k\u0003\u0011a\u0017M\\4\u000b\u0003-\fAA[1wC&\u0011Q\u000e\u001b\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015Q\u000b%\tT#`\u0017\u0016K\u0006%A\u0006L+\u0012+v,T!T)\u0016\u0013\u0016\u0001D&V\tV{V*Q*U\u000bJ\u0003\u0013!C(Q\u000bJ\u000bE+S(O\u0003)y\u0005+\u0012*B)&{e\nI\u0001\u0017\r\u0006+F\nV0U\u001f2+%+\u0011(U?N\u001b\u0015I\u0014(F%\u00069b)Q+M)~#v\nT#S\u0003:#vlU\"B\u001d:+%\u000bI\u0001\u000e'\u000e\u000bej\u0018'P\u0007\u0006c\u0015\nV-\u0002\u001dM\u001b\u0015IT0M\u001f\u000e\u000bE*\u0013+ZA\u0005Y\u0011j\u0012(P%\u0016{f*\u0016'M\u00031IuIT(S\u000b~sU\u000b\u0014'!\u0003mIuIT(S\u000b~#U\u000b\u0015'J\u0007\u0006#Vi\u0018*P/~+%KU(S'\u0006a\u0012j\u0012(P%\u0016{F)\u0016)M\u0013\u000e\u000bE+R0S\u001f^{VI\u0015*P%N\u0003\u0013a\u0003*F!\u0006\u0013F+\u0013+J\u001f:\u000bABU#Q\u0003J#\u0016\nV%P\u001d\u0002\n\u0001CU#Q\u0003J#\u0016\nV%P\u001d~\u001bvJ\u0015+\u0002#I+\u0005+\u0011*U\u0013RKuJT0T\u001fJ#\u0006%A\fT\u0007\u0006suLU#R+\u0016\u001bFk\u0018+J\u001b\u0016{U\u000bV0N'\u0006A2kQ!O?J+\u0015+V#T)~#\u0016*T#P+R{Vj\u0015\u0011\u0002-M{5iS#U?J+\u0015\tR0U\u00136+u*\u0016+`\u001bN\u000bqcU(D\u0017\u0016#vLU#B\t~#\u0016*T#P+R{Vj\u0015\u0011\u0002\u0015\t\u000bEk\u0011%`'&SV)A\u0006C\u0003R\u001b\u0005jX*J5\u0016\u0003\u0013\u0001F&F\u000bB{\u0016\tT%W\u000b~\u0003VIU%P\t~k5+A\u000bL\u000b\u0016\u0003v,\u0011'J-\u0016{\u0006+\u0012*J\u001f\u0012{Vj\u0015\u0011\u0002!M\u0003F*\u0013+`'&SVi\u0018\"Z)\u0016\u001b\u0016!E*Q\u0019&#vlU%[\u000b~\u0013\u0015\fV#TA\u0005\u0019\u0002*\u0011(E\u0019\u0016{6k\u0011%F\u001b\u0006{FIU%G)\u0006!\u0002*\u0011(E\u0019\u0016{6k\u0011%F\u001b\u0006{FIU%G)\u0002\n1#V*F?\u0012\u0013\u0016JV#S?6+E+\u0011#B)\u0006\u000bA#V*F?\u0012\u0013\u0016JV#S?6+E+\u0011#B)\u0006\u0003\u0013!F*O\u0003B\u001b\u0006j\u0014+`)&kUi\u0015+B\u001bB{VjU\u0001\u0017':\u000b\u0005k\u0015%P)~#\u0016*T#T)\u0006k\u0005kX'TA\u0005\u00112+Q*M?B\u0013v\nV(D\u001f2{f*Q'F\u0003M\u0019\u0016i\u0015'`!J{EkT\"P\u0019~s\u0015)T#!\u0003Y\u0011V)U+J%\u0016{\u0016)\u0016+I\u000b:#\u0016jQ!U\u0013>s\u0015a\u0006*F#VK%+R0B+RCUI\u0014+J\u0007\u0006#\u0016j\u0014(!\u0003E)ej\u0011*Z!RKuJT0Q\u001f2K5)W\u0001\u0013\u000b:\u001b%+\u0017)U\u0013>su\fU(M\u0013\u000eK\u0006%A\u0005tQ>\u0014HOT1nKR\u0011\u0011q\u0006\t\u0005\u0003c\tyD\u0004\u0003\u00024\u0005m\u0002cAA\u001b\u000f6\u0011\u0011q\u0007\u0006\u0004\u0003s\u0019\u0015A\u0002\u001fs_>$h(C\u0002\u0002>\u001d\u000ba\u0001\u0015:fI\u00164\u0017bA7\u0002B)\u0019\u0011QH$\u0002\u001d\r\u0014X-\u0019;f%\u0016d\u0017\r^5p]R1\u0011qIA'\u00033\u00022\u0001TA%\u0013\r\tY%\u0014\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\u0005\b\u0003\u001fZ\u0003\u0019AA)\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0005\u0003'\n)&D\u0001P\u0013\r\t9f\u0014\u0002\u000b'Fc5i\u001c8uKb$\bbBA.W\u0001\u0007\u0011QL\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003CA\u0019\u0003?\ny#a\f\n\t\u0005\u0005\u0014\u0011\t\u0002\u0004\u001b\u0006\u0004H\u0003CA$\u0003K\n9'!\u001b\t\u000f\u0005=C\u00061\u0001\u0002R!9\u00111\f\u0017A\u0002\u0005u\u0003bBA6Y\u0001\u0007\u0011QN\u0001\u0007g\u000eDW-\\1\u0011\t\u0005=\u0014QO\u0007\u0003\u0003cR1!a\u001dP\u0003\u0015!\u0018\u0010]3t\u0013\u0011\t9(!\u001d\u0003\u0015M#(/^2u)f\u0004X\r\u0006\u0006\u0002H\u0005m\u0014QPAD\u0003\u0013Cq!a\u0014.\u0001\u0004\t\t\u0006C\u0004\u0002\u00005\u0002\r!!!\u0002\t5|G-\u001a\t\u0005\u0003'\n\u0019)C\u0002\u0002\u0006>\u0013\u0001bU1wK6{G-\u001a\u0005\b\u00037j\u0003\u0019AA/\u0011\u001d\tY)\fa\u0001\u0003\u001b\u000bA\u0001Z1uCB!\u0011qRAS\u001d\u0011\t\t*!)\u000f\t\u0005M\u0015q\u0014\b\u0005\u0003+\u000biJ\u0004\u0003\u0002\u0018\u0006me\u0002BA\u001b\u00033K\u0011AQ\u0005\u0003\u0001\u0006K!!P \n\u0005A\u000b\u0016bAAR\u001f\u00069\u0001/Y2lC\u001e,\u0017\u0002BAT\u0003S\u0013\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005\rv*\u0001\u0006de\u0016\fG/Z*j].$\"\"a,\u0002@\u0006\u0005\u00171YAl!\u0011\t\t,a/\u000e\u0005\u0005M&\u0002BA[\u0003o\u000b\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0007\u0005ev*A\u0005fq\u0016\u001cW\u000f^5p]&!\u0011QXAZ\u0005\u0011\u0019\u0016N\\6\t\u000f\u0005=c\u00061\u0001\u0002R!9\u00111\f\u0018A\u0002\u0005u\u0003bBAc]\u0001\u0007\u0011qY\u0001\u0011a\u0006\u0014H/\u001b;j_:\u001cu\u000e\\;n]N\u0004b!!3\u0002R\u0006=b\u0002BAf\u0003\u001ftA!!\u000e\u0002N&\t\u0001*C\u0002\u0002$\u001eKA!a5\u0002V\n\u00191+Z9\u000b\u0007\u0005\rv\tC\u0004\u0002Z:\u0002\r!a7\u0002\u0015=,H\u000f];u\u001b>$W\r\u0005\u0003\u0002^\u0006\u0005XBAAp\u0015\r\t)lT\u0005\u0005\u0003G\fyN\u0001\u0006PkR\u0004X\u000f^'pI\u0016\fAbZ3u)\u0006\u0014G.\u001a(b[\u0016$B!a\f\u0002j\"9\u00111L\u0018A\u0002\u0005u\u0013AD4fiJ+\u0017\rZ(qi&|gn\u001d\u000b\u0005\u0003_\f)\u0010E\u0002d\u0003cL1!a=;\u0005=YU\u000fZ;SK\u0006$w\n\u001d;j_:\u001c\bbBA.a\u0001\u0007\u0011QL\u0001\u0010O\u0016$xK]5uK>\u0003H/[8ogR!\u00111 B\u0001!\r\u0019\u0017Q`\u0005\u0004\u0003\u007fT$\u0001E&vIV<&/\u001b;f\u001fB$\u0018n\u001c8t\u0011\u001d\tY&\ra\u0001\u0003;\nabZ3u\u001b\u0006\u001cH/\u001a:BI\u0012\u00148\u000f\u0006\u0003\u00020\t\u001d\u0001bBA.e\u0001\u0007\u0011QL\u0001\u0014O\u0016$8+Y:m!J|Go\\2pY:\u000bW.\u001a\u000b\u0005\u0003_\u0011i\u0001C\u0004\u0002\\M\u0002\r!!\u0018\u00021\u001d,GOU3rk&\u0014X-Q;uQ\u0016tG/[2bi&|g\u000e\u0006\u0003\u0003\u0014\te\u0001c\u0001$\u0003\u0016%\u0019!qC$\u0003\u000f\t{w\u000e\\3b]\"9\u00111\f\u001bA\u0002\u0005u\u0013aE4fi\u0016s7M]=qi&|g\u000eU8mS\u000eLH\u0003\u0002B\u0010\u0005s\u0001BA!\t\u000349!!1\u0005B\u0017\u001d\u0011\u0011)C!\u000b\u000f\t\u0005U%qE\u0005\u0003w}J1Aa\u000b?\u0003\u0019\u0019G.[3oi&!!q\u0006B\u0019\u0003=\t5/\u001f8d\u0017V$Wo\u00117jK:$(b\u0001B\u0016}%!!Q\u0007B\u001c\u0005A)en\u0019:zaRLwN\u001c)pY&\u001c\u0017P\u0003\u0003\u00030\tE\u0002bBA.k\u0001\u0007\u0011QL\u0001\u0014O\u0016$8kY1o\u0019>\u001c\u0017\r\\5usRK\b/\u001a\u000b\u0005\u0005\u007f\u00119\u0005\u0005\u0003\u0003B\t\rSB\u0001B\u0019\u0013\u0011\u0011)E!\r\u0003!I+\u0007\u000f\\5dCN+G.Z2uS>t\u0007b\u0002B%m\u0001\u0007\u0011qF\u0001\b_B\u0004\u0016M]1n\u0003A9W\r^(qKJ\fG/[8o)f\u0004X\r\u0006\u0003\u0003P\tU\u0003cA2\u0003R%\u0019!1\u000b\u001e\u0003\u001b=\u0003XM]1uS>tG+\u001f9f\u0011\u001d\tYf\u000ea\u0001\u0003;\nQc\u001d;sS:<Gk\\(qKJ\fG/[8o)f\u0004X\r\u0006\u0003\u0003P\tm\u0003b\u0002B%q\u0001\u0007\u0011q\u0006\u0015\u0004\u0001\t}\u0003\u0003\u0002B1\u0005crAAa\u0019\u0003n5\u0011!Q\r\u0006\u0005\u0005O\u0012I'\u0001\u0005bk\u0012LWM\\2f\u0015\r\u0011YgP\u0001\u0006s\u0016$Xo]\u0005\u0005\u0005_\u0012)'\u0001\nJ]R,'OZ1dKN#\u0018MY5mSRL\u0018\u0002\u0002B:\u0005k\u0012\u0001\"\u00168ti\u0006\u0014G.\u001a\u0006\u0005\u0005_\u0012)\u0007K\u0002\u0001\u0005s\u0002BAa\u001f\u0003\u0002:!!1\rB?\u0013\u0011\u0011yH!\u001a\u0002#%sG/\u001a:gC\u000e,\u0017)\u001e3jK:\u001cW-\u0003\u0003\u0003\u0004\n\u0015%a\u0002)sSZ\fG/\u001a\u0006\u0005\u0005\u007f\u0012)\u0007")
public class DefaultSource
implements DataSourceRegister,
RelationProvider,
CreatableRelationProvider,
SchemaRelationProvider,
StreamSinkProvider {
    private final String TABLE_KEY;
    private final String KUDU_MASTER;
    private final String OPERATION;
    private final String FAULT_TOLERANT_SCANNER;
    private final String SCAN_LOCALITY;
    private final String IGNORE_NULL;
    private final String IGNORE_DUPLICATE_ROW_ERRORS;
    private final String REPARTITION;
    private final String REPARTITION_SORT;
    private final String SCAN_REQUEST_TIMEOUT_MS;
    private final String SOCKET_READ_TIMEOUT_MS;
    private final String BATCH_SIZE;
    private final String KEEP_ALIVE_PERIOD_MS;
    private final String SPLIT_SIZE_BYTES;
    private final String HANDLE_SCHEMA_DRIFT;
    private final String USE_DRIVER_METADATA;
    private final String SNAPSHOT_TIMESTAMP_MS;
    private final String SASL_PROTOCOL_NAME;
    private final String REQUIRE_AUTHENTICATION;
    private final String ENCRYPTION_POLICY;

    public String TABLE_KEY() {
        return this.TABLE_KEY;
    }

    public String KUDU_MASTER() {
        return this.KUDU_MASTER;
    }

    public String OPERATION() {
        return this.OPERATION;
    }

    public String FAULT_TOLERANT_SCANNER() {
        return this.FAULT_TOLERANT_SCANNER;
    }

    public String SCAN_LOCALITY() {
        return this.SCAN_LOCALITY;
    }

    public String IGNORE_NULL() {
        return this.IGNORE_NULL;
    }

    public String IGNORE_DUPLICATE_ROW_ERRORS() {
        return this.IGNORE_DUPLICATE_ROW_ERRORS;
    }

    public String REPARTITION() {
        return this.REPARTITION;
    }

    public String REPARTITION_SORT() {
        return this.REPARTITION_SORT;
    }

    public String SCAN_REQUEST_TIMEOUT_MS() {
        return this.SCAN_REQUEST_TIMEOUT_MS;
    }

    public String SOCKET_READ_TIMEOUT_MS() {
        return this.SOCKET_READ_TIMEOUT_MS;
    }

    public String BATCH_SIZE() {
        return this.BATCH_SIZE;
    }

    public String KEEP_ALIVE_PERIOD_MS() {
        return this.KEEP_ALIVE_PERIOD_MS;
    }

    public String SPLIT_SIZE_BYTES() {
        return this.SPLIT_SIZE_BYTES;
    }

    public String HANDLE_SCHEMA_DRIFT() {
        return this.HANDLE_SCHEMA_DRIFT;
    }

    public String USE_DRIVER_METADATA() {
        return this.USE_DRIVER_METADATA;
    }

    public String SNAPSHOT_TIMESTAMP_MS() {
        return this.SNAPSHOT_TIMESTAMP_MS;
    }

    public String SASL_PROTOCOL_NAME() {
        return this.SASL_PROTOCOL_NAME;
    }

    public String REQUIRE_AUTHENTICATION() {
        return this.REQUIRE_AUTHENTICATION;
    }

    public String ENCRYPTION_POLICY() {
        return this.ENCRYPTION_POLICY;
    }

    public String shortName() {
        return "kudu";
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, parameters, null);
    }

    public BaseRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        String tableName = this.getTableName(parameters);
        String kuduMaster = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        String saslProtocolName = this.getSaslProtocolName(parameters);
        boolean requireAuthentication = this.getRequireAuthentication(parameters);
        AsyncKuduClient.EncryptionPolicy encryptionPolicy = this.getEncryptionPolicy(parameters);
        Option schemaOption = Option$.MODULE$.apply((Object)schema);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduRelation(tableName, kuduMaster, saslProtocolName, requireAuthentication, encryptionPolicy, operationType, (Option<StructType>)schemaOption, readOptions, writeOptions, sqlContext);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        BaseRelation kuduRelation = this.createRelation(sqlContext, parameters);
        SaveMode saveMode = mode;
        if (!SaveMode.Append.equals(saveMode)) {
            throw new UnsupportedOperationException("Currently, only Append is supported");
        }
        ((KuduRelation)kuduRelation).insert(data, false);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return kuduRelation;
    }

    public Sink createSink(SQLContext sqlContext, Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        String tableName = this.getTableName(parameters);
        String masterAddrs = this.getMasterAddrs(parameters);
        OperationType operationType = this.getOperationType(parameters);
        String saslProtocolName = this.getSaslProtocolName(parameters);
        boolean requireAuthentication = this.getRequireAuthentication(parameters);
        AsyncKuduClient.EncryptionPolicy encryptionPolicy = this.getEncryptionPolicy(parameters);
        KuduReadOptions readOptions = this.getReadOptions(parameters);
        KuduWriteOptions writeOptions = this.getWriteOptions(parameters);
        return new KuduSink(tableName, masterAddrs, saslProtocolName, requireAuthentication, encryptionPolicy, operationType, readOptions, writeOptions, sqlContext);
    }

    private String getTableName(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.TABLE_KEY(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(64).append("Kudu table name must be specified in create options using key '").append(this.TABLE_KEY()).append("'").toString());
        });
    }

    private KuduReadOptions getReadOptions(Map<String, String> parameters) {
        int batchSize = BoxesRunTime.unboxToInt((Object)parameters.get((Object)this.BATCH_SIZE()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)DefaultSource.$anonfun$getReadOptions$1(x$1))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultBatchSize()));
        boolean faultTolerantScanner = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.FAULT_TOLERANT_SCANNER()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getReadOptions$3(x$2))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultFaultTolerantScanner()));
        ReplicaSelection scanLocality = (ReplicaSelection)((Object)parameters.get((Object)this.SCAN_LOCALITY()).map((Function1 & Serializable & scala.Serializable)opParam -> this.getScanLocalityType((String)opParam)).getOrElse((Function0 & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultScanLocality()));
        Option scanRequestTimeoutMs = parameters.get((Object)this.SCAN_REQUEST_TIMEOUT_MS()).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$7(x$3)));
        long keepAlivePeriodMs = BoxesRunTime.unboxToLong((Object)parameters.get((Object)this.KEEP_ALIVE_PERIOD_MS()).map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$8(x$4))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultKeepAlivePeriodMs()));
        Option splitSizeBytes = parameters.get((Object)this.SPLIT_SIZE_BYTES()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$10(x$5)));
        boolean useDriverMetadata = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.USE_DRIVER_METADATA()).map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getReadOptions$11(x$6))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduReadOptions$.MODULE$.defaultUseDriverMetadata()));
        Option snapshotTimestampMs = parameters.get((Object)this.SNAPSHOT_TIMESTAMP_MS()).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)DefaultSource.$anonfun$getReadOptions$13(x$7)));
        return new KuduReadOptions(batchSize, scanLocality, faultTolerantScanner, keepAlivePeriodMs, (Option<Object>)scanRequestTimeoutMs, (Option<Object>)None$.MODULE$, (Option<Object>)splitSizeBytes, useDriverMetadata, (Option<Object>)snapshotTimestampMs);
    }

    private KuduWriteOptions getWriteOptions(Map<String, String> parameters) {
        boolean ignoreDuplicateRowErrors = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.IGNORE_DUPLICATE_ROW_ERRORS()).map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$1(x$8))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultIgnoreDuplicateRowErrors()));
        boolean ignoreNull = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.IGNORE_NULL()).map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$3(x$9))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultIgnoreNull()));
        boolean repartition = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION()).map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$5(x$10))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultRepartition()));
        boolean repartitionSort = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.REPARTITION_SORT()).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$7(x$11))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultRepartitionSort()));
        boolean handleSchemaDrift = BoxesRunTime.unboxToBoolean((Object)parameters.get((Object)this.HANDLE_SCHEMA_DRIFT()).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getWriteOptions$9(x$12))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> KuduWriteOptions$.MODULE$.defaultHandleSchemaDrift()));
        return new KuduWriteOptions(ignoreDuplicateRowErrors, ignoreNull, repartition, repartitionSort, handleSchemaDrift);
    }

    private String getMasterAddrs(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.KUDU_MASTER(), (Function0 & Serializable & scala.Serializable)() -> InetAddress.getLocalHost().getCanonicalHostName());
    }

    private String getSaslProtocolName(Map<String, String> parameters) {
        return (String)parameters.getOrElse((Object)this.SASL_PROTOCOL_NAME(), (Function0 & Serializable & scala.Serializable)() -> "kudu");
    }

    private boolean getRequireAuthentication(Map<String, String> parameters) {
        return parameters.get((Object)this.REQUIRE_AUTHENTICATION()).exists((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)DefaultSource.$anonfun$getRequireAuthentication$1(x$13)));
    }

    private AsyncKuduClient.EncryptionPolicy getEncryptionPolicy(Map<String, String> parameters) {
        AsyncKuduClient.EncryptionPolicy encryptionPolicy;
        String string = ((String)parameters.getOrElse((Object)this.ENCRYPTION_POLICY(), (Function0 & Serializable & scala.Serializable)() -> "optional")).toLowerCase(Locale.ENGLISH);
        if ("optional".equals(string)) {
            encryptionPolicy = AsyncKuduClient.EncryptionPolicy.OPTIONAL;
        } else if ("required".equals(string)) {
            encryptionPolicy = AsyncKuduClient.EncryptionPolicy.REQUIRED;
        } else if ("required_remote".equals(string)) {
            encryptionPolicy = AsyncKuduClient.EncryptionPolicy.REQUIRED_REMOTE;
        } else {
            throw new MatchError((Object)string);
        }
        return encryptionPolicy;
    }

    private ReplicaSelection getScanLocalityType(String opParam) {
        ReplicaSelection replicaSelection;
        String string = opParam.toLowerCase(Locale.ENGLISH);
        if ("leader_only".equals(string)) {
            replicaSelection = ReplicaSelection.LEADER_ONLY;
        } else if ("closest_replica".equals(string)) {
            replicaSelection = ReplicaSelection.CLOSEST_REPLICA;
        } else {
            throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported replica selection type '").append(opParam).append("'").toString());
        }
        return replicaSelection;
    }

    private OperationType getOperationType(Map<String, String> parameters) {
        return (OperationType)parameters.get((Object)this.OPERATION()).map((Function1 & Serializable & scala.Serializable)opParam -> this.stringToOperationType((String)opParam)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Upsert$.MODULE$);
    }

    private OperationType stringToOperationType(String opParam) {
        OperationType operationType;
        String string = opParam.toLowerCase(Locale.ENGLISH);
        if ("insert".equals(string)) {
            operationType = Insert$.MODULE$;
        } else if ("insert_ignore".equals(string)) {
            operationType = InsertIgnore$.MODULE$;
        } else if ("insert-ignore".equals(string)) {
            operationType = InsertIgnore$.MODULE$;
        } else if ("upsert".equals(string)) {
            operationType = Upsert$.MODULE$;
        } else if ("update".equals(string)) {
            operationType = Update$.MODULE$;
        } else if ("update_ignore".equals(string)) {
            operationType = UpdateIgnore$.MODULE$;
        } else if ("update-ignore".equals(string)) {
            operationType = UpdateIgnore$.MODULE$;
        } else if ("delete".equals(string)) {
            operationType = Delete$.MODULE$;
        } else if ("delete_ignore".equals(string)) {
            operationType = DeleteIgnore$.MODULE$;
        } else if ("delete-ignore".equals(string)) {
            operationType = DeleteIgnore$.MODULE$;
        } else {
            throw new IllegalArgumentException(new StringBuilder(29).append("Unsupported operation type '").append(opParam).append("'").toString());
        }
        return operationType;
    }

    public static final /* synthetic */ int $anonfun$getReadOptions$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$getReadOptions$3(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toLong();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$8(String x$4) {
        return new StringOps(Predef$.MODULE$.augmentString(x$4)).toLong();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$10(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getReadOptions$11(String x$6) {
        return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
    }

    public static final /* synthetic */ long $anonfun$getReadOptions$13(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$1(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$3(String x$9) {
        return new StringOps(Predef$.MODULE$.augmentString(x$9)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$5(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$7(String x$11) {
        return new StringOps(Predef$.MODULE$.augmentString(x$11)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getWriteOptions$9(String x$12) {
        return new StringOps(Predef$.MODULE$.augmentString(x$12)).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getRequireAuthentication$1(String x$13) {
        return new StringOps(Predef$.MODULE$.augmentString(x$13)).toBoolean();
    }

    public DefaultSource() {
        this.TABLE_KEY = "kudu.table";
        this.KUDU_MASTER = "kudu.master";
        this.OPERATION = "kudu.operation";
        this.FAULT_TOLERANT_SCANNER = "kudu.faultTolerantScan";
        this.SCAN_LOCALITY = "kudu.scanLocality";
        this.IGNORE_NULL = "kudu.ignoreNull";
        this.IGNORE_DUPLICATE_ROW_ERRORS = "kudu.ignoreDuplicateRowErrors";
        this.REPARTITION = "kudu.repartition";
        this.REPARTITION_SORT = "kudu.repartition.sort";
        this.SCAN_REQUEST_TIMEOUT_MS = "kudu.scanRequestTimeoutMs";
        this.SOCKET_READ_TIMEOUT_MS = "kudu.socketReadTimeoutMs";
        this.BATCH_SIZE = "kudu.batchSize";
        this.KEEP_ALIVE_PERIOD_MS = "kudu.keepAlivePeriodMs";
        this.SPLIT_SIZE_BYTES = "kudu.splitSizeBytes";
        this.HANDLE_SCHEMA_DRIFT = "kudu.handleSchemaDrift";
        this.USE_DRIVER_METADATA = "kudu.useDriverMetadata";
        this.SNAPSHOT_TIMESTAMP_MS = "kudu.snapshotTimestampMs";
        this.SASL_PROTOCOL_NAME = "kudu.saslProtocolName";
        this.REQUIRE_AUTHENTICATION = "kudu.requireAuthentication";
        this.ENCRYPTION_POLICY = "kudu.encryptionPolicy";
    }
}

