/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.composite;

import java.lang.ref.WeakReference;
import java.util.function.ToDoubleFunction;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Gauge;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.composite.AbstractCompositeMeter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.noop.NoopGauge;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

class CompositeGauge<T>
extends AbstractCompositeMeter<Gauge>
implements Gauge {
    private final WeakReference<T> ref;
    private final ToDoubleFunction<T> f;

    CompositeGauge(Meter.Id id, @Nullable T obj, ToDoubleFunction<T> f) {
        super(id);
        this.ref = new WeakReference<T>(obj);
        this.f = f;
    }

    @Override
    public double value() {
        return ((Gauge)this.firstChild()).value();
    }

    @Override
    Gauge newNoopMeter() {
        return new NoopGauge(this.getId());
    }

    @Override
    Gauge registerNewMeter(MeterRegistry registry) {
        Object obj = this.ref.get();
        if (obj == null) {
            return null;
        }
        return Gauge.builder(this.getId().getName(), obj, this.f).tags(this.getId().getTagsAsIterable()).description(this.getId().getDescription()).baseUnit(this.getId().getBaseUnit()).register(registry);
    }
}

