/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import java.util.Objects;
import org.apache.kudu.Type;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class ColumnTypeAttributes {
    private final boolean hasPrecision;
    private final int precision;
    private final boolean hasScale;
    private final int scale;

    private ColumnTypeAttributes(boolean hasPrecision, int precision, boolean hasScale, int scale) {
        this.hasPrecision = hasPrecision;
        this.precision = precision;
        this.hasScale = hasScale;
        this.scale = scale;
    }

    public boolean hasPrecision() {
        return this.hasPrecision;
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean hasScale() {
        return this.hasScale;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnTypeAttributes that = (ColumnTypeAttributes)o;
        if (this.hasPrecision != that.hasPrecision) {
            return false;
        }
        if (this.precision != that.precision) {
            return false;
        }
        if (this.hasScale != that.hasScale) {
            return false;
        }
        return this.scale == that.scale;
    }

    public int hashCode() {
        return Objects.hash(this.hasPrecision, this.precision, this.hasScale, this.scale);
    }

    public String toStringForType(Type type) {
        if (type == Type.DECIMAL) {
            return "(" + this.precision + ", " + this.scale + ")";
        }
        return "";
    }

    public String toString() {
        return "hasPrecision: " + this.hasPrecision + ", precision: " + this.precision + ", hasScale: " + this.hasScale + ", scale: " + this.scale;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Evolving
    public static class ColumnTypeAttributesBuilder {
        private boolean hasPrecision;
        private int precision;
        private boolean hasScale;
        private int scale;

        public ColumnTypeAttributesBuilder precision(int precision) {
            this.hasPrecision = true;
            this.precision = precision;
            return this;
        }

        public ColumnTypeAttributesBuilder scale(int scale) {
            this.hasScale = true;
            this.scale = scale;
            return this;
        }

        public ColumnTypeAttributes build() {
            return new ColumnTypeAttributes(this.hasPrecision, this.precision, this.hasScale, this.scale);
        }
    }
}

