/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.netty.channel;

import org.apache.kudu.shaded.io.netty.buffer.ByteBuf;
import org.apache.kudu.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.kudu.shaded.io.netty.buffer.CompositeByteBuf;
import org.apache.kudu.shaded.io.netty.buffer.Unpooled;
import org.apache.kudu.shaded.io.netty.channel.AbstractCoalescingBufferQueue;
import org.apache.kudu.shaded.io.netty.channel.Channel;
import org.apache.kudu.shaded.io.netty.channel.ChannelPromise;
import org.apache.kudu.shaded.io.netty.util.internal.ObjectUtil;

public final class CoalescingBufferQueue
extends AbstractCoalescingBufferQueue {
    private final Channel channel;

    public CoalescingBufferQueue(Channel channel) {
        this(channel, 4);
    }

    public CoalescingBufferQueue(Channel channel, int initSize) {
        this(channel, initSize, false);
    }

    public CoalescingBufferQueue(Channel channel, int initSize, boolean updateWritability) {
        super(updateWritability ? channel : null, initSize);
        this.channel = ObjectUtil.checkNotNull(channel, "channel");
    }

    public ByteBuf remove(int bytes, ChannelPromise aggregatePromise) {
        return this.remove(this.channel.alloc(), bytes, aggregatePromise);
    }

    public void releaseAndFailAll(Throwable cause) {
        this.releaseAndFailAll(this.channel, cause);
    }

    @Override
    protected ByteBuf compose(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf next2) {
        if (cumulation instanceof CompositeByteBuf) {
            CompositeByteBuf composite = (CompositeByteBuf)cumulation;
            composite.addComponent(true, next2);
            return composite;
        }
        return this.composeIntoComposite(alloc, cumulation, next2);
    }

    @Override
    protected ByteBuf removeEmptyValue() {
        return Unpooled.EMPTY_BUFFER;
    }
}

