/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument;

import org.apache.kudu.shaded.io.micrometer.core.instrument.AbstractMeter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Clock;
import org.apache.kudu.shaded.io.micrometer.core.instrument.DistributionSummary;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Meter;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.Histogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.HistogramSnapshot;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.NoopHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.TimeWindowFixedBoundaryHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.distribution.TimeWindowPercentileHistogram;
import org.apache.kudu.shaded.io.micrometer.core.instrument.util.MeterEquivalence;
import org.apache.kudu.shaded.io.micrometer.core.lang.Nullable;

public abstract class AbstractDistributionSummary
extends AbstractMeter
implements DistributionSummary {
    protected final Histogram histogram;
    private final double scale;

    protected AbstractDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        super(id);
        this.scale = scale;
        this.histogram = distributionStatisticConfig.isPublishingPercentiles() ? new TimeWindowPercentileHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : (distributionStatisticConfig.isPublishingHistogram() ? new TimeWindowFixedBoundaryHistogram(clock, distributionStatisticConfig, supportsAggregablePercentiles) : NoopHistogram.INSTANCE);
    }

    @Override
    public final void record(double amount) {
        if (amount >= 0.0) {
            double scaledAmount = this.scale * amount;
            this.histogram.recordDouble(scaledAmount);
            this.recordNonNegative(scaledAmount);
        }
    }

    protected abstract void recordNonNegative(double var1);

    @Override
    public HistogramSnapshot takeSnapshot() {
        return this.histogram.takeSnapshot(this.count(), this.totalAmount(), this.max());
    }

    public boolean equals(@Nullable Object o) {
        return MeterEquivalence.equals(this, o);
    }

    public int hashCode() {
        return MeterEquivalence.hashCode(this);
    }
}

