/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.kudu.Hash;
import org.apache.kudu.PbUtil;
import org.apache.kudu.shaded.com.google.protobuf.AbstractParser;
import org.apache.kudu.shaded.com.google.protobuf.ByteString;
import org.apache.kudu.shaded.com.google.protobuf.CodedInputStream;
import org.apache.kudu.shaded.com.google.protobuf.CodedOutputStream;
import org.apache.kudu.shaded.com.google.protobuf.Descriptors;
import org.apache.kudu.shaded.com.google.protobuf.ExtensionRegistry;
import org.apache.kudu.shaded.com.google.protobuf.ExtensionRegistryLite;
import org.apache.kudu.shaded.com.google.protobuf.GeneratedMessageV3;
import org.apache.kudu.shaded.com.google.protobuf.Internal;
import org.apache.kudu.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.kudu.shaded.com.google.protobuf.Message;
import org.apache.kudu.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.kudu.shaded.com.google.protobuf.Parser;
import org.apache.kudu.shaded.com.google.protobuf.UninitializedMessageException;
import org.apache.kudu.shaded.com.google.protobuf.UnknownFieldSet;

public final class BlockBloomFilter {
    private static final Descriptors.Descriptor internal_static_kudu_BlockBloomFilterPB_descriptor;
    private static final GeneratedMessageV3.FieldAccessorTable internal_static_kudu_BlockBloomFilterPB_fieldAccessorTable;
    private static Descriptors.FileDescriptor descriptor;

    private BlockBloomFilter() {
    }

    public static void registerAllExtensions(ExtensionRegistryLite registry) {
    }

    public static void registerAllExtensions(ExtensionRegistry registry) {
        BlockBloomFilter.registerAllExtensions((ExtensionRegistryLite)registry);
    }

    public static Descriptors.FileDescriptor getDescriptor() {
        return descriptor;
    }

    static {
        String[] descriptorData = new String[]{"\n\"kudu/util/block_bloom_filter.proto\u0012\u0004kudu\u001a\u0014kudu/util/hash.proto\u001a\u0017kudu/util/pb_util.proto\"\u00ab\u0001\n\u0012BlockBloomFilterPB\u0012\u0017\n\u000flog_space_bytes\u0018\u0001 \u0001(\u0005\u0012\u0018\n\nbloom_data\u0018\u0002 \u0001(\fB\u0004\u0088\u00b5\u0018\u0001\u0012\u0014\n\falways_false\u0018\u0003 \u0001(\b\u00126\n\u000ehash_algorithm\u0018\u0004 \u0001(\u000e2\u0013.kudu.HashAlgorithm:\tFAST_HASH\u0012\u0014\n\thash_seed\u0018\u0005 \u0001(\r:\u00010B\u0011\n\u000forg.apache.kudu"};
        descriptor = Descriptors.FileDescriptor.internalBuildGeneratedFileFrom(descriptorData, new Descriptors.FileDescriptor[]{Hash.getDescriptor(), PbUtil.getDescriptor()});
        internal_static_kudu_BlockBloomFilterPB_descriptor = BlockBloomFilter.getDescriptor().getMessageTypes().get(0);
        internal_static_kudu_BlockBloomFilterPB_fieldAccessorTable = new GeneratedMessageV3.FieldAccessorTable(internal_static_kudu_BlockBloomFilterPB_descriptor, new String[]{"LogSpaceBytes", "BloomData", "AlwaysFalse", "HashAlgorithm", "HashSeed"});
        ExtensionRegistry registry = ExtensionRegistry.newInstance();
        registry.add(PbUtil.rEDACT);
        Descriptors.FileDescriptor.internalUpdateFileDescriptor(descriptor, registry);
        Hash.getDescriptor();
        PbUtil.getDescriptor();
    }

    public static final class BlockBloomFilterPB
    extends GeneratedMessageV3
    implements BlockBloomFilterPBOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int LOG_SPACE_BYTES_FIELD_NUMBER = 1;
        private int logSpaceBytes_ = 0;
        public static final int BLOOM_DATA_FIELD_NUMBER = 2;
        private ByteString bloomData_ = ByteString.EMPTY;
        public static final int ALWAYS_FALSE_FIELD_NUMBER = 3;
        private boolean alwaysFalse_ = false;
        public static final int HASH_ALGORITHM_FIELD_NUMBER = 4;
        private int hashAlgorithm_ = 3;
        public static final int HASH_SEED_FIELD_NUMBER = 5;
        private int hashSeed_ = 0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final BlockBloomFilterPB DEFAULT_INSTANCE = new BlockBloomFilterPB();
        @Deprecated
        public static final Parser<BlockBloomFilterPB> PARSER = new AbstractParser<BlockBloomFilterPB>(){

            @Override
            public BlockBloomFilterPB parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = BlockBloomFilterPB.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage(builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private BlockBloomFilterPB(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private BlockBloomFilterPB() {
            this.bloomData_ = ByteString.EMPTY;
            this.hashAlgorithm_ = 3;
        }

        @Override
        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new BlockBloomFilterPB();
        }

        @Override
        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return internal_static_kudu_BlockBloomFilterPB_descriptor;
        }

        @Override
        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return internal_static_kudu_BlockBloomFilterPB_fieldAccessorTable.ensureFieldAccessorsInitialized(BlockBloomFilterPB.class, Builder.class);
        }

        @Override
        public boolean hasLogSpaceBytes() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public int getLogSpaceBytes() {
            return this.logSpaceBytes_;
        }

        @Override
        public boolean hasBloomData() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public ByteString getBloomData() {
            return this.bloomData_;
        }

        @Override
        public boolean hasAlwaysFalse() {
            return (this.bitField0_ & 4) != 0;
        }

        @Override
        public boolean getAlwaysFalse() {
            return this.alwaysFalse_;
        }

        @Override
        public boolean hasHashAlgorithm() {
            return (this.bitField0_ & 8) != 0;
        }

        @Override
        public Hash.HashAlgorithm getHashAlgorithm() {
            Hash.HashAlgorithm result = Hash.HashAlgorithm.forNumber(this.hashAlgorithm_);
            return result == null ? Hash.HashAlgorithm.FAST_HASH : result;
        }

        @Override
        public boolean hasHashSeed() {
            return (this.bitField0_ & 0x10) != 0;
        }

        @Override
        public int getHashSeed() {
            return this.hashSeed_;
        }

        @Override
        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        @Override
        public void writeTo(CodedOutputStream output) throws IOException {
            if ((this.bitField0_ & 1) != 0) {
                output.writeInt32(1, this.logSpaceBytes_);
            }
            if ((this.bitField0_ & 2) != 0) {
                output.writeBytes(2, this.bloomData_);
            }
            if ((this.bitField0_ & 4) != 0) {
                output.writeBool(3, this.alwaysFalse_);
            }
            if ((this.bitField0_ & 8) != 0) {
                output.writeEnum(4, this.hashAlgorithm_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                output.writeUInt32(5, this.hashSeed_);
            }
            this.getUnknownFields().writeTo(output);
        }

        @Override
        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if ((this.bitField0_ & 1) != 0) {
                size += CodedOutputStream.computeInt32Size(1, this.logSpaceBytes_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += CodedOutputStream.computeBytesSize(2, this.bloomData_);
            }
            if ((this.bitField0_ & 4) != 0) {
                size += CodedOutputStream.computeBoolSize(3, this.alwaysFalse_);
            }
            if ((this.bitField0_ & 8) != 0) {
                size += CodedOutputStream.computeEnumSize(4, this.hashAlgorithm_);
            }
            if ((this.bitField0_ & 0x10) != 0) {
                size += CodedOutputStream.computeUInt32Size(5, this.hashSeed_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof BlockBloomFilterPB)) {
                return super.equals(obj);
            }
            BlockBloomFilterPB other = (BlockBloomFilterPB)obj;
            if (this.hasLogSpaceBytes() != other.hasLogSpaceBytes()) {
                return false;
            }
            if (this.hasLogSpaceBytes() && this.getLogSpaceBytes() != other.getLogSpaceBytes()) {
                return false;
            }
            if (this.hasBloomData() != other.hasBloomData()) {
                return false;
            }
            if (this.hasBloomData() && !this.getBloomData().equals(other.getBloomData())) {
                return false;
            }
            if (this.hasAlwaysFalse() != other.hasAlwaysFalse()) {
                return false;
            }
            if (this.hasAlwaysFalse() && this.getAlwaysFalse() != other.getAlwaysFalse()) {
                return false;
            }
            if (this.hasHashAlgorithm() != other.hasHashAlgorithm()) {
                return false;
            }
            if (this.hasHashAlgorithm() && this.hashAlgorithm_ != other.hashAlgorithm_) {
                return false;
            }
            if (this.hasHashSeed() != other.hasHashSeed()) {
                return false;
            }
            if (this.hasHashSeed() && this.getHashSeed() != other.getHashSeed()) {
                return false;
            }
            return this.getUnknownFields().equals(other.getUnknownFields());
        }

        @Override
        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + BlockBloomFilterPB.getDescriptor().hashCode();
            if (this.hasLogSpaceBytes()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getLogSpaceBytes();
            }
            if (this.hasBloomData()) {
                hash = 37 * hash + 2;
                hash = 53 * hash + this.getBloomData().hashCode();
            }
            if (this.hasAlwaysFalse()) {
                hash = 37 * hash + 3;
                hash = 53 * hash + Internal.hashBoolean(this.getAlwaysFalse());
            }
            if (this.hasHashAlgorithm()) {
                hash = 37 * hash + 4;
                hash = 53 * hash + this.hashAlgorithm_;
            }
            if (this.hasHashSeed()) {
                hash = 37 * hash + 5;
                hash = 53 * hash + this.getHashSeed();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static BlockBloomFilterPB parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static BlockBloomFilterPB parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static BlockBloomFilterPB parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static BlockBloomFilterPB parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static BlockBloomFilterPB parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data);
        }

        public static BlockBloomFilterPB parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return PARSER.parseFrom(data, extensionRegistry);
        }

        public static BlockBloomFilterPB parseFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static BlockBloomFilterPB parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        public static BlockBloomFilterPB parseDelimitedFrom(InputStream input) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
        }

        public static BlockBloomFilterPB parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input, extensionRegistry);
        }

        public static BlockBloomFilterPB parseFrom(CodedInputStream input) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static BlockBloomFilterPB parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return GeneratedMessageV3.parseWithIOException(PARSER, input, extensionRegistry);
        }

        @Override
        public Builder newBuilderForType() {
            return BlockBloomFilterPB.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(BlockBloomFilterPB prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @Override
        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @Override
        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static BlockBloomFilterPB getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<BlockBloomFilterPB> parser() {
            return PARSER;
        }

        public Parser<BlockBloomFilterPB> getParserForType() {
            return PARSER;
        }

        @Override
        public BlockBloomFilterPB getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements BlockBloomFilterPBOrBuilder {
            private int bitField0_;
            private int logSpaceBytes_;
            private ByteString bloomData_ = ByteString.EMPTY;
            private boolean alwaysFalse_;
            private int hashAlgorithm_ = 3;
            private int hashSeed_;

            public static final Descriptors.Descriptor getDescriptor() {
                return internal_static_kudu_BlockBloomFilterPB_descriptor;
            }

            @Override
            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return internal_static_kudu_BlockBloomFilterPB_fieldAccessorTable.ensureFieldAccessorsInitialized(BlockBloomFilterPB.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            @Override
            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.logSpaceBytes_ = 0;
                this.bloomData_ = ByteString.EMPTY;
                this.alwaysFalse_ = false;
                this.hashAlgorithm_ = 3;
                this.hashSeed_ = 0;
                return this;
            }

            @Override
            public Descriptors.Descriptor getDescriptorForType() {
                return internal_static_kudu_BlockBloomFilterPB_descriptor;
            }

            @Override
            public BlockBloomFilterPB getDefaultInstanceForType() {
                return BlockBloomFilterPB.getDefaultInstance();
            }

            @Override
            public BlockBloomFilterPB build() {
                BlockBloomFilterPB result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException(result);
                }
                return result;
            }

            @Override
            public BlockBloomFilterPB buildPartial() {
                BlockBloomFilterPB result = new BlockBloomFilterPB(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(BlockBloomFilterPB result) {
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if ((from_bitField0_ & 1) != 0) {
                    result.logSpaceBytes_ = this.logSpaceBytes_;
                    to_bitField0_ |= 1;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.bloomData_ = this.bloomData_;
                    to_bitField0_ |= 2;
                }
                if ((from_bitField0_ & 4) != 0) {
                    result.alwaysFalse_ = this.alwaysFalse_;
                    to_bitField0_ |= 4;
                }
                if ((from_bitField0_ & 8) != 0) {
                    result.hashAlgorithm_ = this.hashAlgorithm_;
                    to_bitField0_ |= 8;
                }
                if ((from_bitField0_ & 0x10) != 0) {
                    result.hashSeed_ = this.hashSeed_;
                    to_bitField0_ |= 0x10;
                }
                result.bitField0_ |= to_bitField0_;
            }

            @Override
            public Builder clone() {
                return (Builder)super.clone();
            }

            @Override
            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            @Override
            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            @Override
            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            @Override
            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            @Override
            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            @Override
            public Builder mergeFrom(Message other) {
                if (other instanceof BlockBloomFilterPB) {
                    return this.mergeFrom((BlockBloomFilterPB)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(BlockBloomFilterPB other) {
                if (other == BlockBloomFilterPB.getDefaultInstance()) {
                    return this;
                }
                if (other.hasLogSpaceBytes()) {
                    this.setLogSpaceBytes(other.getLogSpaceBytes());
                }
                if (other.hasBloomData()) {
                    this.setBloomData(other.getBloomData());
                }
                if (other.hasAlwaysFalse()) {
                    this.setAlwaysFalse(other.getAlwaysFalse());
                }
                if (other.hasHashAlgorithm()) {
                    this.setHashAlgorithm(other.getHashAlgorithm());
                }
                if (other.hasHashSeed()) {
                    this.setHashSeed(other.getHashSeed());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            @Override
            public final boolean isInitialized() {
                return true;
            }

            @Override
            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block13: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block13;
                            }
                            case 8: {
                                this.logSpaceBytes_ = input.readInt32();
                                this.bitField0_ |= 1;
                                continue block13;
                            }
                            case 18: {
                                this.bloomData_ = input.readBytes();
                                this.bitField0_ |= 2;
                                continue block13;
                            }
                            case 24: {
                                this.alwaysFalse_ = input.readBool();
                                this.bitField0_ |= 4;
                                continue block13;
                            }
                            case 32: {
                                int tmpRaw = input.readEnum();
                                Hash.HashAlgorithm tmpValue = Hash.HashAlgorithm.forNumber(tmpRaw);
                                if (tmpValue == null) {
                                    this.mergeUnknownVarintField(4, tmpRaw);
                                    continue block13;
                                }
                                this.hashAlgorithm_ = tmpRaw;
                                this.bitField0_ |= 8;
                                continue block13;
                            }
                            case 40: {
                                this.hashSeed_ = input.readUInt32();
                                this.bitField0_ |= 0x10;
                                continue block13;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasLogSpaceBytes() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public int getLogSpaceBytes() {
                return this.logSpaceBytes_;
            }

            public Builder setLogSpaceBytes(int value) {
                this.logSpaceBytes_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearLogSpaceBytes() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.logSpaceBytes_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBloomData() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public ByteString getBloomData() {
                return this.bloomData_;
            }

            public Builder setBloomData(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bloomData_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearBloomData() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.bloomData_ = BlockBloomFilterPB.getDefaultInstance().getBloomData();
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasAlwaysFalse() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public boolean getAlwaysFalse() {
                return this.alwaysFalse_;
            }

            public Builder setAlwaysFalse(boolean value) {
                this.alwaysFalse_ = value;
                this.bitField0_ |= 4;
                this.onChanged();
                return this;
            }

            public Builder clearAlwaysFalse() {
                this.bitField0_ &= 0xFFFFFFFB;
                this.alwaysFalse_ = false;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasHashAlgorithm() {
                return (this.bitField0_ & 8) != 0;
            }

            @Override
            public Hash.HashAlgorithm getHashAlgorithm() {
                Hash.HashAlgorithm result = Hash.HashAlgorithm.forNumber(this.hashAlgorithm_);
                return result == null ? Hash.HashAlgorithm.FAST_HASH : result;
            }

            public Builder setHashAlgorithm(Hash.HashAlgorithm value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 8;
                this.hashAlgorithm_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearHashAlgorithm() {
                this.bitField0_ &= 0xFFFFFFF7;
                this.hashAlgorithm_ = 3;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasHashSeed() {
                return (this.bitField0_ & 0x10) != 0;
            }

            @Override
            public int getHashSeed() {
                return this.hashSeed_;
            }

            public Builder setHashSeed(int value) {
                this.hashSeed_ = value;
                this.bitField0_ |= 0x10;
                this.onChanged();
                return this;
            }

            public Builder clearHashSeed() {
                this.bitField0_ &= 0xFFFFFFEF;
                this.hashSeed_ = 0;
                this.onChanged();
                return this;
            }

            @Override
            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            @Override
            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface BlockBloomFilterPBOrBuilder
    extends MessageOrBuilder {
        public boolean hasLogSpaceBytes();

        public int getLogSpaceBytes();

        public boolean hasBloomData();

        public ByteString getBloomData();

        public boolean hasAlwaysFalse();

        public boolean getAlwaysFalse();

        public boolean hasHashAlgorithm();

        public Hash.HashAlgorithm getHashAlgorithm();

        public boolean hasHashSeed();

        public int getHashSeed();
    }
}

