/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kudu.shaded.io.micrometer.core.instrument.binder.mongodb;

import com.mongodb.event.CommandEvent;
import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import java.util.concurrent.TimeUnit;
import org.apache.kudu.shaded.io.micrometer.core.annotation.Incubating;
import org.apache.kudu.shaded.io.micrometer.core.instrument.MeterRegistry;
import org.apache.kudu.shaded.io.micrometer.core.instrument.Timer;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullApi;
import org.apache.kudu.shaded.io.micrometer.core.lang.NonNullFields;

@NonNullApi
@NonNullFields
@Incubating(since="1.2.0")
public class MongoMetricsCommandListener
implements CommandListener {
    private final Timer.Builder timerBuilder = Timer.builder("mongodb.driver.commands").description("Timer of mongodb commands");
    private final MeterRegistry registry;

    public MongoMetricsCommandListener(MeterRegistry registry) {
        this.registry = registry;
    }

    public void commandStarted(CommandStartedEvent commandStartedEvent) {
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        this.timeCommand((CommandEvent)event, "SUCCESS", event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    public void commandFailed(CommandFailedEvent event) {
        this.timeCommand((CommandEvent)event, "FAILED", event.getElapsedTime(TimeUnit.NANOSECONDS));
    }

    private void timeCommand(CommandEvent event, String status, long elapsedTimeInNanoseconds) {
        this.timerBuilder.tag("command", event.getCommandName()).tag("cluster.id", event.getConnectionDescription().getConnectionId().getServerId().getClusterId().getValue()).tag("server.address", event.getConnectionDescription().getServerAddress().toString()).tag("status", status).register(this.registry).record(elapsedTimeInNanoseconds, TimeUnit.NANOSECONDS);
    }
}

