/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.hdfs;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ServiceDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptorFactory;
import org.apache.hadoop.gateway.topology.Provider;
import org.apache.hadoop.gateway.topology.Service;

public class WebHdfsDeploymentContributor
extends ServiceDeploymentContributorBase {
    private static final String RULES_RESOURCE = WebHdfsDeploymentContributor.class.getName().replace('.', '/') + "/rewrite.xml";
    private static final String WEBHDFS_EXTERNAL_PATH = "/webhdfs/v1";
    private static final String DATANODE_EXTERNAL_PATH = "/webhdfs/data/v1";

    public String getRole() {
        return "WEBHDFS";
    }

    public String getName() {
        return "webhdfs";
    }

    public void contributeService(DeploymentContext context, Service service) throws Exception {
        this.contributeRewriteRules(context, service);
        this.contributeNameNodeResource(context, service);
        this.contributeDataNodeResource(context, service);
    }

    private void contributeRewriteRules(DeploymentContext context, Service service) throws URISyntaxException, IOException {
        UrlRewriteRulesDescriptor serviceRules = this.loadRulesFromClassPath();
        UrlRewriteRulesDescriptor clusterRules = (UrlRewriteRulesDescriptor)context.getDescriptor("rewrite");
        clusterRules.addRules(serviceRules);
    }

    public void contributeNameNodeResource(DeploymentContext context, Service service) throws URISyntaxException {
        ResourceDescriptor rootResource = context.getGatewayDescriptor().addResource();
        rootResource.role(service.getRole());
        rootResource.pattern("/webhdfs/v1/?**");
        this.addWebAppSecFilters(context, service, rootResource);
        this.addAuthenticationFilter(context, service, rootResource);
        ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
        params.add(rootResource.createFilterParam().name("request.url").value(this.getQualifiedName() + "/inbound/namenode/root"));
        this.addRewriteFilter(context, service, rootResource, params);
        this.addIdentityAssertionFilter(context, service, rootResource);
        this.addAuthorizationFilter(context, service, rootResource);
        String dispatchName = this.getDispatchNameForNN(context);
        String dispatchRole = "dispatch";
        this.addDispatchFilter(context, service, rootResource, dispatchRole, dispatchName);
        ResourceDescriptor fileResource = context.getGatewayDescriptor().addResource();
        fileResource.role(service.getRole());
        fileResource.pattern("/webhdfs/v1/**?**");
        this.addWebAppSecFilters(context, service, fileResource);
        this.addAuthenticationFilter(context, service, fileResource);
        params = new ArrayList();
        params.add(fileResource.createFilterParam().name("request.url").value(this.getQualifiedName() + "/inbound/namenode/file"));
        params.add(fileResource.createFilterParam().name("response.headers").value(this.getQualifiedName() + "/outbound/namenode/headers"));
        this.addRewriteFilter(context, service, fileResource, params);
        this.addIdentityAssertionFilter(context, service, fileResource);
        this.addAuthorizationFilter(context, service, fileResource);
        this.addDispatchFilter(context, service, fileResource, dispatchRole, dispatchName);
        ResourceDescriptor homeResource = context.getGatewayDescriptor().addResource();
        homeResource.role(service.getRole());
        homeResource.pattern("/webhdfs/v1/~?**");
        this.addWebAppSecFilters(context, service, homeResource);
        this.addAuthenticationFilter(context, service, homeResource);
        params = new ArrayList();
        params.add(homeResource.createFilterParam().name("request.url").value(this.getQualifiedName() + "/inbound/namenode/home"));
        this.addRewriteFilter(context, service, homeResource, params);
        this.addIdentityAssertionFilter(context, service, homeResource);
        this.addAuthorizationFilter(context, service, homeResource);
        this.addDispatchFilter(context, service, homeResource, dispatchRole, dispatchName);
        ResourceDescriptor homeFileResource = context.getGatewayDescriptor().addResource();
        homeFileResource.role(service.getRole());
        homeFileResource.pattern("/webhdfs/v1/~/**?**");
        this.addWebAppSecFilters(context, service, homeFileResource);
        this.addAuthenticationFilter(context, service, homeFileResource);
        params = new ArrayList();
        params.add(homeFileResource.createFilterParam().name("request.url").value(this.getQualifiedName() + "/inbound/namenode/home/file"));
        params.add(homeFileResource.createFilterParam().name("response.headers").value(this.getQualifiedName() + "/outbound/namenode/headers"));
        this.addRewriteFilter(context, service, homeFileResource, params);
        this.addIdentityAssertionFilter(context, service, homeFileResource);
        this.addAuthorizationFilter(context, service, homeFileResource);
        this.addDispatchFilter(context, service, homeFileResource, dispatchRole, dispatchName);
    }

    public void contributeDataNodeResource(DeploymentContext context, Service service) throws URISyntaxException {
        ResourceDescriptor fileResource = context.getGatewayDescriptor().addResource();
        fileResource.role(service.getRole());
        fileResource.pattern("/webhdfs/data/v1/**?**");
        this.addWebAppSecFilters(context, service, fileResource);
        this.addAuthenticationFilter(context, service, fileResource);
        this.addIdentityAssertionFilter(context, service, fileResource);
        this.addAuthorizationFilter(context, service, fileResource);
        ArrayList<FilterParamDescriptor> params = new ArrayList<FilterParamDescriptor>();
        params.add(fileResource.createFilterParam().name("request.url").value(this.getQualifiedName() + "/inbound/datanode"));
        this.addRewriteFilter(context, service, fileResource, params);
        this.addDispatchFilter(context, service, fileResource, "dispatch", "http-client");
    }

    String getQualifiedName() {
        return this.getRole() + "/" + this.getName();
    }

    UrlRewriteRulesDescriptor loadRulesFromClassPath() throws IOException {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(RULES_RESOURCE);
        InputStreamReader reader = new InputStreamReader(stream);
        UrlRewriteRulesDescriptor rules = UrlRewriteRulesDescriptorFactory.load((String)"xml", (Reader)reader);
        ((Reader)reader).close();
        stream.close();
        return rules;
    }

    private String getDispatchNameForNN(DeploymentContext context) {
        Map params;
        Provider provider = this.getProviderByRole(context, "ha");
        if (provider != null && provider.isEnabled() && (params = provider.getParams()) != null && params.containsKey(this.getRole())) {
            return "ha-hdfs";
        }
        return "hdfs";
    }
}

