/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.html;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.html.HtmlFilterReader;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class HtmlUrlRewriteFilterReader
extends HtmlFilterReader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private Resolver resolver;
    private UrlRewriter rewriter;
    private UrlRewriter.Direction direction;

    public HtmlUrlRewriteFilterReader(Reader reader, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException, ParserConfigurationException {
        super(reader);
        this.resolver = resolver;
        this.rewriter = rewriter;
        this.direction = direction;
    }

    protected String filterValueString(String name, String value, String rule) {
        try {
            Template input = Parser.parse((String)value);
            Template output = this.rewriter.rewrite(this.resolver, input, this.direction, rule);
            if (output != null) {
                value = output.getPattern();
            }
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    @Override
    protected String filterAttribute(String tagName, String attributeName, String attributeValue, String ruleName) {
        return this.filterValueString(attributeName, attributeValue, ruleName);
    }

    @Override
    protected String filterText(String tagName, String text, String ruleName) {
        return this.filterValueString(tagName, text, ruleName);
    }
}

