/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptorFactory;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;

public abstract class UrlRewriteFunctionProcessorFactory {
    private static Map<Class<? extends UrlRewriteFunctionDescriptor>, Map<String, Class<? extends UrlRewriteFunctionProcessor>>> MAP = UrlRewriteFunctionProcessorFactory.loadProcessors();

    private UrlRewriteFunctionProcessorFactory() {
    }

    public static UrlRewriteFunctionProcessor create(String name, UrlRewriteFunctionDescriptor descriptor) throws IllegalAccessException, InstantiationException {
        Map<String, Class<? extends UrlRewriteFunctionProcessor>> typeMap;
        if (descriptor == null) {
            descriptor = UrlRewriteFunctionDescriptorFactory.create(name);
        }
        if ((typeMap = MAP.get(descriptor.getClass())) == null) {
            Class<? extends UrlRewriteFunctionDescriptor> descriptorInterface = UrlRewriteFunctionProcessorFactory.getDescriptorInterface(descriptor);
            typeMap = MAP.get(descriptorInterface);
        }
        if (typeMap == null) {
            throw new IllegalArgumentException(descriptor.getClass().getName());
        }
        Class<? extends UrlRewriteFunctionProcessor> processorClass = typeMap.get(name);
        if (processorClass == null) {
            throw new IllegalArgumentException(name);
        }
        UrlRewriteFunctionProcessor processor = processorClass.newInstance();
        return processor;
    }

    private static Map<Class<? extends UrlRewriteFunctionDescriptor>, Map<String, Class<? extends UrlRewriteFunctionProcessor>>> loadProcessors() {
        HashMap<Class<? extends UrlRewriteFunctionDescriptor>, Map<String, Class<? extends UrlRewriteFunctionProcessor>>> descriptorMap = new HashMap<Class<? extends UrlRewriteFunctionDescriptor>, Map<String, Class<? extends UrlRewriteFunctionProcessor>>>();
        ServiceLoader<UrlRewriteFunctionProcessor> processors = ServiceLoader.load(UrlRewriteFunctionProcessor.class);
        for (UrlRewriteFunctionProcessor processor : processors) {
            Class<? extends UrlRewriteFunctionDescriptor> descriptorInterface = UrlRewriteFunctionProcessorFactory.getDescriptorInterface(processor);
            HashMap typeMap = (HashMap)descriptorMap.get(descriptorInterface);
            if (typeMap == null) {
                typeMap = new HashMap();
                descriptorMap.put(descriptorInterface, typeMap);
            }
            String functionName = processor.name();
            typeMap.put(functionName, processor.getClass());
        }
        return descriptorMap;
    }

    private static Class<? extends UrlRewriteFunctionDescriptor> getDescriptorInterface(UrlRewriteFunctionDescriptor descriptor) {
        Class<? extends UrlRewriteFunctionDescriptor> descriptorClass = null;
        for (Type interfaceType : descriptor.getClass().getGenericInterfaces()) {
            Class genericClass = (Class)interfaceType;
            if (!UrlRewriteFunctionDescriptor.class.isAssignableFrom(genericClass)) continue;
            descriptorClass = UrlRewriteFunctionProcessorFactory.uncheckedDescriptorClassCast(genericClass);
            break;
        }
        return descriptorClass;
    }

    private static Class<? extends UrlRewriteFunctionDescriptor> getDescriptorInterface(UrlRewriteFunctionProcessor processor) {
        Class<? extends UrlRewriteFunctionDescriptor> descriptorClass = null;
        Class<?> processorClass = processor.getClass();
        for (Type interfaceType : processorClass.getGenericInterfaces()) {
            if (!UrlRewriteFunctionProcessor.class.isAssignableFrom((Class)((ParameterizedType)interfaceType).getRawType())) continue;
            ParameterizedType interfaceClass = (ParameterizedType)interfaceType;
            descriptorClass = UrlRewriteFunctionProcessorFactory.uncheckedDescriptorClassCast(interfaceClass.getActualTypeArguments()[0]);
            break;
        }
        return descriptorClass;
    }

    private static Class<? extends UrlRewriteFunctionDescriptor> uncheckedDescriptorClassCast(Type type) {
        return (Class)type;
    }
}

