/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStreamFilter;
import org.apache.hadoop.gateway.util.MimeTypes;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;

public abstract class UrlRewriteStreamFilterFactory {
    private static String DEFAULT_CHARACTER_ENCODING = "ISO-8859-1";
    private static Map<String, Map<String, UrlRewriteStreamFilter>> MAP = UrlRewriteStreamFilterFactory.loadFactories();

    private UrlRewriteStreamFilterFactory() {
    }

    public static InputStream create(MimeType type, String name, InputStream stream, UrlRewriter rewriter, Resolver resolver, UrlRewriter.Direction direction, UrlRewriteFilterContentDescriptor config) throws IOException {
        InputStream filteredStream = null;
        Map<String, UrlRewriteStreamFilter> nameMap = UrlRewriteStreamFilterFactory.getNameMap(type);
        UrlRewriteStreamFilter filter = UrlRewriteStreamFilterFactory.getFilter(nameMap, name);
        String charset = MimeTypes.getCharset((MimeType)type, (String)DEFAULT_CHARACTER_ENCODING);
        if (filter != null) {
            filteredStream = filter.filter(stream, charset, rewriter, resolver, direction, config);
        }
        return filteredStream;
    }

    private static Map<String, Map<String, UrlRewriteStreamFilter>> loadFactories() {
        HashMap<String, Map<String, UrlRewriteStreamFilter>> typeMap = new HashMap<String, Map<String, UrlRewriteStreamFilter>>();
        ServiceLoader<UrlRewriteStreamFilter> filters = ServiceLoader.load(UrlRewriteStreamFilter.class);
        for (UrlRewriteStreamFilter filter : filters) {
            String[] types;
            for (String type : types = filter.getTypes()) {
                LinkedHashMap<String, UrlRewriteStreamFilter> nameMap = (LinkedHashMap<String, UrlRewriteStreamFilter>)typeMap.get(type);
                if (nameMap == null) {
                    nameMap = new LinkedHashMap<String, UrlRewriteStreamFilter>();
                    typeMap.put(type, nameMap);
                }
                for (String name : filter.getNames()) {
                    nameMap.put(name, filter);
                }
            }
        }
        return typeMap;
    }

    private static Map<String, UrlRewriteStreamFilter> getNameMap(MimeType type) {
        if (type == null) {
            type = new MimeType();
        }
        Map<String, UrlRewriteStreamFilter> nameMap = MAP.get(type.getBaseType());
        try {
            if (nameMap == null) {
                type.setPrimaryType("*");
                nameMap = MAP.get(type.getBaseType());
                if (nameMap == null) {
                    type.setSubType("*");
                    nameMap = MAP.get(type.getBaseType());
                    if (nameMap == null) {
                        nameMap = MAP.get(null);
                    }
                }
            }
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(type.toString(), e);
        }
        return nameMap;
    }

    private static UrlRewriteStreamFilter getFilter(Map<String, UrlRewriteStreamFilter> map, String name) {
        UrlRewriteStreamFilter filter = null;
        if (map != null) {
            filter = name == null && !map.isEmpty() ? map.values().iterator().next() : map.get(name);
        }
        return filter;
    }
}

