/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.api;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteRulesDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteResources;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteRulesDescriptorImpl;
import org.apache.hadoop.gateway.filter.rewrite.impl.xml.XmlUrlRewriteRulesExporter;
import org.apache.hadoop.gateway.filter.rewrite.impl.xml.XmlUrlRewriteRulesImporter;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteRulesExporter;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteRulesImporter;
import org.apache.hadoop.gateway.i18n.resources.ResourcesFactory;

public abstract class UrlRewriteRulesDescriptorFactory {
    private static UrlRewriteResources RES = (UrlRewriteResources)ResourcesFactory.get(UrlRewriteResources.class);
    private static Map<String, UrlRewriteRulesImporter> IMPORTERS = UrlRewriteRulesDescriptorFactory.loadImporters();
    private static Map<String, UrlRewriteRulesExporter> EXPORTERS = UrlRewriteRulesDescriptorFactory.loadExporters();

    private UrlRewriteRulesDescriptorFactory() {
    }

    public static UrlRewriteRulesDescriptor create() {
        return new UrlRewriteRulesDescriptorImpl();
    }

    public static UrlRewriteRulesDescriptor load(String format, Reader reader) throws IOException {
        UrlRewriteRulesImporter importer = IMPORTERS.get(format);
        if (importer == null) {
            throw new IllegalArgumentException(RES.noImporterForFormat(format));
        }
        return importer.load(reader);
    }

    public static void store(UrlRewriteRulesDescriptor descriptor, String format, Writer writer) throws IOException {
        UrlRewriteRulesExporter exporter = EXPORTERS.get(format);
        if (exporter == null) {
            throw new IllegalArgumentException(RES.noExporterForFormat(format));
        }
        exporter.store(descriptor, writer);
    }

    private static Map<String, UrlRewriteRulesImporter> loadImporters() {
        ConcurrentHashMap<String, UrlRewriteRulesImporter> map = new ConcurrentHashMap<String, UrlRewriteRulesImporter>();
        map.put("xml", new XmlUrlRewriteRulesImporter());
        return map;
    }

    private static Map<String, UrlRewriteRulesExporter> loadExporters() {
        ConcurrentHashMap<String, UrlRewriteRulesExporter> map = new ConcurrentHashMap<String, UrlRewriteRulesExporter>();
        map.put("xml", new XmlUrlRewriteRulesExporter());
        return map;
    }
}

