/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterApplyDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterBufferDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterDetectDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterGroupDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterPathDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.JsonPath;

class JsonFilterReader
extends Reader {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private static final UrlRewriteFilterPathDescriptor.Compiler<JsonPath.Expression> JPATH_COMPILER = new JsonPathCompiler();
    private static final UrlRewriteFilterPathDescriptor.Compiler<Pattern> REGEX_COMPILER = new RegexCompiler();
    private JsonFactory factory;
    private JsonParser parser;
    private JsonGenerator generator;
    private ObjectMapper mapper;
    private Reader reader;
    private int offset;
    private StringWriter writer;
    private StringBuffer buffer;
    private Stack<Level> stack;
    private Level bufferingLevel;
    private UrlRewriteFilterBufferDescriptor bufferingConfig;
    private UrlRewriteFilterGroupDescriptor config;

    public JsonFilterReader(Reader reader, UrlRewriteFilterContentDescriptor config) throws IOException {
        this.reader = reader;
        this.factory = new JsonFactory();
        this.mapper = new ObjectMapper();
        this.parser = this.factory.createParser(reader);
        this.writer = new StringWriter();
        this.buffer = this.writer.getBuffer();
        this.offset = 0;
        this.generator = this.factory.createGenerator((Writer)this.writer);
        this.stack = new Stack();
        this.bufferingLevel = null;
        this.bufferingConfig = null;
        this.config = config;
    }

    @Override
    public int read(char[] destBuffer, int destOffset, int destCount) throws IOException {
        int count = 0;
        int available = this.buffer.length() - this.offset;
        if (available == 0) {
            JsonToken token = this.parser.nextToken();
            if (token == null) {
                count = -1;
            } else {
                this.processCurrentToken();
                available = this.buffer.length() - this.offset;
            }
        }
        if (available > 0) {
            count = Math.min(destCount, available);
            this.buffer.getChars(this.offset, this.offset + count, destBuffer, destOffset);
            this.offset += count;
            if (this.offset == this.buffer.length()) {
                this.offset = 0;
                this.buffer.setLength(0);
            }
        }
        return count;
    }

    private void processCurrentToken() throws IOException {
        switch (this.parser.getCurrentToken()) {
            case START_OBJECT: {
                this.processStartObject();
                break;
            }
            case END_OBJECT: {
                this.processEndObject();
                break;
            }
            case START_ARRAY: {
                this.processStartArray();
                break;
            }
            case END_ARRAY: {
                this.processEndArray();
                break;
            }
            case FIELD_NAME: {
                this.processFieldName();
                break;
            }
            case VALUE_STRING: {
                this.processValueString();
                break;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                this.processValueNumber();
                break;
            }
            case VALUE_TRUE: 
            case VALUE_FALSE: {
                this.processValueBoolean();
                break;
            }
            case VALUE_NULL: {
                this.processValueNull();
                break;
            }
        }
        this.generator.flush();
    }

    private Level pushLevel(String field, JsonNode node, JsonNode scopeNode, UrlRewriteFilterGroupDescriptor scopeConfig) {
        if (!this.stack.isEmpty()) {
            Level top = this.stack.peek();
            if (scopeNode == null) {
                scopeNode = top.scopeNode;
                scopeConfig = top.scopeConfig;
            }
        }
        Level level = new Level(field, node, scopeNode, scopeConfig);
        this.stack.push(level);
        return level;
    }

    private void processStartObject() throws IOException {
        Level child;
        block8: {
            block9: {
                block7: {
                    if (!this.stack.isEmpty()) break block7;
                    ObjectNode node = this.mapper.createObjectNode();
                    child = this.pushLevel(null, (JsonNode)node, (JsonNode)node, this.config);
                    break block8;
                }
                child = this.stack.peek();
                if (child.node != null) break block9;
                child.node = this.mapper.createObjectNode();
                Level parent = (Level)this.stack.get(this.stack.size() - 2);
                switch (parent.node.asToken()) {
                    case START_ARRAY: {
                        ((ArrayNode)parent.node).add(child.node);
                        break block8;
                    }
                    case START_OBJECT: {
                        ((ObjectNode)parent.node).put(child.field, child.node);
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (child.isArray()) {
                Level parent = child;
                ObjectNode node = this.mapper.createObjectNode();
                child = this.pushLevel(null, (JsonNode)node, null, null);
                ((ArrayNode)parent.node).add(child.node);
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.bufferingLevel == null && !this.startBuffering(child)) {
            this.generator.writeStartObject();
        }
    }

    private void processEndObject() throws IOException {
        Level child = this.stack.pop();
        if (this.bufferingLevel == child) {
            this.filterBufferedNode(child);
            this.mapper.writeTree(this.generator, child.node);
            this.bufferingLevel = null;
            this.bufferingConfig = null;
        } else if (this.bufferingLevel == null) {
            this.generator.writeEndObject();
            if (!this.stack.isEmpty()) {
                Level parent = this.stack.peek();
                switch (parent.node.asToken()) {
                    case START_ARRAY: {
                        ((ArrayNode)parent.node).removeAll();
                        break;
                    }
                    case START_OBJECT: {
                        ((ObjectNode)parent.node).removeAll();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private void processStartArray() throws IOException {
        Level child;
        block8: {
            block9: {
                block7: {
                    if (!this.stack.isEmpty()) break block7;
                    ArrayNode node = this.mapper.createArrayNode();
                    child = this.pushLevel(null, (JsonNode)node, (JsonNode)node, this.config);
                    break block8;
                }
                child = this.stack.peek();
                if (child.node != null) break block9;
                child.node = this.mapper.createArrayNode();
                Level parent = (Level)this.stack.get(this.stack.size() - 2);
                switch (parent.node.asToken()) {
                    case START_ARRAY: {
                        ((ArrayNode)parent.node).add(child.node);
                        break block8;
                    }
                    case START_OBJECT: {
                        ((ObjectNode)parent.node).put(child.field, child.node);
                        break block8;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            if (child.isArray()) {
                Level parent = child;
                child = this.pushLevel(null, (JsonNode)this.mapper.createArrayNode(), null, null);
                ((ArrayNode)parent.node).add(child.node);
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.bufferingLevel == null && !this.startBuffering(child)) {
            this.generator.writeStartArray();
        }
    }

    private void processEndArray() throws IOException {
        Level child = this.stack.pop();
        if (this.bufferingLevel == child) {
            this.filterBufferedNode(child);
            this.mapper.writeTree(this.generator, child.node);
            this.bufferingLevel = null;
            this.bufferingConfig = null;
        } else if (this.bufferingLevel == null) {
            this.generator.writeEndArray();
            if (!this.stack.isEmpty()) {
                Level parent = this.stack.peek();
                switch (parent.node.asToken()) {
                    case START_ARRAY: {
                        ((ArrayNode)parent.node).removeAll();
                        break;
                    }
                    case START_OBJECT: {
                        ((ObjectNode)parent.node).removeAll();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
        }
    }

    private void processFieldName() throws IOException {
        Level child = this.pushLevel(this.parser.getCurrentName(), null, null, null);
        try {
            child.field = this.filterFieldName(child.field);
        }
        catch (Exception e) {
            LOG.failedToFilterFieldName(child.field, e);
        }
        if (this.bufferingLevel == null) {
            this.generator.writeFieldName(child.field);
        }
    }

    private void processValueString() throws IOException {
        String value = null;
        Level parent = this.stack.peek();
        if (parent.isArray()) {
            ArrayNode array = (ArrayNode)parent.node;
            array.add(this.parser.getText());
            if (this.bufferingLevel == null) {
                value = this.filterStreamValue(parent);
                array.set(array.size() - 1, (JsonNode)new TextNode(value));
            } else {
                array.removeAll();
            }
        } else {
            Level child = this.stack.pop();
            parent = this.stack.peek();
            ((ObjectNode)parent.node).put(child.field, this.parser.getText());
            if (this.bufferingLevel == null) {
                child.node = parent.node;
                value = this.filterStreamValue(child);
            }
        }
        if (this.bufferingLevel == null) {
            if (parent.node.isArray()) {
                ((ArrayNode)parent.node).removeAll();
            } else {
                ((ObjectNode)parent.node).removeAll();
            }
            this.generator.writeString(value);
        }
    }

    private void processValueNumber() throws IOException {
        Level parent = this.stack.peek();
        if (parent.isArray()) {
            if (this.bufferingLevel != null) {
                ArrayNode array = (ArrayNode)parent.node;
                array.add(this.parser.getDecimalValue());
            }
        } else {
            Level child = this.stack.pop();
            if (this.bufferingLevel != null) {
                parent = this.stack.peek();
                ObjectNode object = (ObjectNode)parent.node;
                object.put(child.field, this.parser.getDecimalValue());
            }
        }
        if (this.bufferingLevel == null) {
            switch (this.parser.getNumberType()) {
                case INT: {
                    this.generator.writeNumber(this.parser.getIntValue());
                    break;
                }
                case LONG: {
                    this.generator.writeNumber(this.parser.getLongValue());
                    break;
                }
                case BIG_INTEGER: {
                    this.generator.writeNumber(this.parser.getBigIntegerValue());
                    break;
                }
                case FLOAT: {
                    this.generator.writeNumber(this.parser.getFloatValue());
                    break;
                }
                case DOUBLE: {
                    this.generator.writeNumber(this.parser.getDoubleValue());
                    break;
                }
                case BIG_DECIMAL: {
                    this.generator.writeNumber(this.parser.getDecimalValue());
                }
            }
        }
    }

    private void processValueBoolean() throws IOException {
        Level parent = this.stack.peek();
        if (parent.isArray()) {
            ((ArrayNode)parent.node).add(this.parser.getBooleanValue());
            if (this.bufferingLevel == null) {
                ((ArrayNode)parent.node).removeAll();
            }
        } else {
            Level child = this.stack.pop();
            parent = this.stack.peek();
            ((ObjectNode)parent.node).put(child.field, this.parser.getBooleanValue());
            if (this.bufferingLevel == null) {
                ((ObjectNode)parent.node).remove(child.field);
            }
        }
        if (this.bufferingLevel == null) {
            this.generator.writeBoolean(this.parser.getBooleanValue());
        }
    }

    private void processValueNull() throws IOException {
        Level parent = this.stack.peek();
        if (parent.isArray()) {
            ((ArrayNode)parent.node).addNull();
            if (this.bufferingLevel == null) {
                ((ArrayNode)parent.node).removeAll();
            }
        } else {
            Level child = this.stack.pop();
            parent = this.stack.peek();
            ((ObjectNode)parent.node).putNull(child.field);
            if (this.bufferingLevel == null) {
                ((ObjectNode)parent.node).remove(child.field);
            }
        }
        if (this.bufferingLevel == null) {
            this.generator.writeNull();
        }
    }

    protected boolean startBuffering(Level node) {
        boolean buffered = false;
        UrlRewriteFilterGroupDescriptor scope = node.scopeConfig;
        if (scope != null) {
            for (UrlRewriteFilterPathDescriptor selector : scope.getSelectors()) {
                JsonPath.Expression path = selector.compiledPath(JPATH_COMPILER);
                List matches = path.evaluate(node.scopeNode);
                if (matches == null || matches.size() <= 0) continue;
                if (!(selector instanceof UrlRewriteFilterBufferDescriptor)) break;
                this.bufferingLevel = node;
                this.bufferingConfig = (UrlRewriteFilterBufferDescriptor)selector;
                buffered = true;
                break;
            }
        }
        return buffered;
    }

    protected String filterStreamValue(Level node) {
        String value = node.isArray() ? node.node.get(0).asText() : node.node.get(node.field).asText();
        String rule = null;
        UrlRewriteFilterGroupDescriptor scope = node.scopeConfig;
        if (scope != null) {
            for (UrlRewriteFilterPathDescriptor selector : scope.getSelectors()) {
                JsonPath.Match match;
                JsonPath.Expression path = selector.compiledPath(JPATH_COMPILER);
                List matches = path.evaluate(node.scopeNode);
                if (matches == null || matches.size() <= 0 || !(match = (JsonPath.Match)matches.get(0)).getNode().isTextual() || !(selector instanceof UrlRewriteFilterApplyDescriptor)) continue;
                UrlRewriteFilterApplyDescriptor apply = (UrlRewriteFilterApplyDescriptor)selector;
                rule = apply.rule();
                break;
            }
        }
        try {
            value = this.filterValueString(node.field, value, rule);
            if (node.isArray()) {
                ((ArrayNode)node.node).set(0, (JsonNode)new TextNode(value));
            } else {
                ((ObjectNode)node.node).put(node.field, value);
            }
        }
        catch (Exception e) {
            LOG.failedToFilterValue(value, rule, e);
        }
        return value;
    }

    private void filterBufferedNode(Level node) {
        for (UrlRewriteFilterPathDescriptor selector : this.bufferingConfig.getSelectors()) {
            JsonPath.Expression path = selector.compiledPath(JPATH_COMPILER);
            List matches = path.evaluate(node.node);
            for (JsonPath.Match match : matches) {
                if (selector instanceof UrlRewriteFilterApplyDescriptor) {
                    if (!match.getNode().isTextual()) continue;
                    this.filterBufferedValue(match, (UrlRewriteFilterApplyDescriptor)selector);
                    continue;
                }
                if (!(selector instanceof UrlRewriteFilterDetectDescriptor)) continue;
                UrlRewriteFilterDetectDescriptor detectConfig = (UrlRewriteFilterDetectDescriptor)selector;
                JsonPath.Expression detectPath = detectConfig.compiledPath(JPATH_COMPILER);
                List detectMatches = detectPath.evaluate(node.node);
                for (JsonPath.Match detectMatch : detectMatches) {
                    if (!detectMatch.getNode().isTextual()) continue;
                    String detectValue = detectMatch.getNode().asText();
                    Pattern detectPattern = detectConfig.compiledValue(REGEX_COMPILER);
                    if (!detectPattern.matcher(detectValue).matches()) continue;
                    this.filterBufferedValues(node, detectConfig.getSelectors());
                }
            }
        }
    }

    private void filterBufferedValues(Level node, List<UrlRewriteFilterPathDescriptor> selectors) {
        for (UrlRewriteFilterPathDescriptor selector : selectors) {
            JsonPath.Expression path = selector.compiledPath(JPATH_COMPILER);
            List matches = path.evaluate(node.node);
            for (JsonPath.Match match : matches) {
                if (!match.getNode().isTextual() || !(selector instanceof UrlRewriteFilterApplyDescriptor)) continue;
                this.filterBufferedValue(match, (UrlRewriteFilterApplyDescriptor)selector);
            }
        }
    }

    private void filterBufferedValue(JsonPath.Match match, UrlRewriteFilterApplyDescriptor apply) {
        String field = match.getField();
        String value = match.getNode().asText();
        try {
            value = this.filterValueString(field, value, apply.rule());
            ((ObjectNode)match.getParent().getNode()).put(field, value);
        }
        catch (Exception e) {
            LOG.failedToFilterValue(value, apply.rule(), e);
        }
    }

    protected String filterFieldName(String field) {
        return field;
    }

    protected String filterValueString(String name, String value, String rule) {
        return value;
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
        this.writer.close();
        this.parser.close();
        this.reader.close();
    }

    private static class RegexCompiler
    implements UrlRewriteFilterPathDescriptor.Compiler<Pattern> {
        private RegexCompiler() {
        }

        @Override
        public Pattern compile(String expression, Pattern compiled) {
            if (compiled != null) {
                return compiled;
            }
            return Pattern.compile(expression);
        }
    }

    private static class JsonPathCompiler
    implements UrlRewriteFilterPathDescriptor.Compiler<JsonPath.Expression> {
        private JsonPathCompiler() {
        }

        @Override
        public JsonPath.Expression compile(String expression, JsonPath.Expression compiled) {
            return JsonPath.compile((String)expression);
        }
    }

    private static class Level {
        String field;
        JsonNode node;
        JsonNode scopeNode;
        UrlRewriteFilterGroupDescriptor scopeConfig;

        private Level(String field, JsonNode node, JsonNode scopeNode, UrlRewriteFilterGroupDescriptor scopeConfig) {
            this.field = field;
            this.node = node;
            this.scopeNode = scopeNode;
            this.scopeConfig = scopeConfig;
        }

        public boolean isArray() {
            return this.node != null && this.node.isArray();
        }
    }
}

