/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.activation.MimeType;
import javax.servlet.FilterConfig;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.gateway.filter.GatewayResponse;
import org.apache.hadoop.gateway.filter.GatewayResponseWrapper;
import org.apache.hadoop.gateway.filter.ResponseStreamer;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFilterContentDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteServletContextListener;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteServletFilter;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteStreamFilterFactory;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriter;
import org.apache.hadoop.gateway.filter.rewrite.i18n.UrlRewriteMessages;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteResponseStream;
import org.apache.hadoop.gateway.filter.rewrite.impl.UrlRewriteUtil;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.util.Urls;
import org.apache.hadoop.gateway.util.urltemplate.Params;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Resolver;
import org.apache.hadoop.gateway.util.urltemplate.Template;
import org.apache.hadoop.io.IOUtils;

public class UrlRewriteResponse
extends GatewayResponseWrapper
implements Params,
ResponseStreamer {
    private static final UrlRewriteMessages LOG = (UrlRewriteMessages)MessagesFactory.get(UrlRewriteMessages.class);
    private static final int STREAM_BUFFER_SIZE = 4096;
    private static final Set<String> IGNORE_HEADER_NAMES = new HashSet<String>();
    private static final String REQUEST_PARAM_PREFIX = "request.";
    private static final String CLUSTER_PARAM_PREFIX = "cluster.";
    private static final String GATEWAY_PARAM_PREFIX = "gateway.";
    private UrlRewriter rewriter;
    private FilterConfig config;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private ServletOutputStream output;
    private String bodyFilterName;
    private String headersFilterName;
    private UrlRewriteFilterContentDescriptor headersFilterConfig;
    private String cookiesFilterName;
    private UrlRewriteFilterContentDescriptor cookiesFilterConfig;

    public UrlRewriteResponse(FilterConfig config, HttpServletRequest request, HttpServletResponse response) throws IOException {
        super(response);
        this.rewriter = UrlRewriteServletContextListener.getUrlRewriter(config.getServletContext());
        this.config = config;
        this.request = request;
        this.response = response;
        this.output = null;
        this.bodyFilterName = config.getInitParameter("response.body");
        this.headersFilterName = config.getInitParameter("response.headers");
        this.headersFilterConfig = UrlRewriteUtil.getRewriteFilterConfig(this.rewriter.getConfig(), this.headersFilterName, UrlRewriteServletFilter.HEADERS_MIME_TYPE);
        this.cookiesFilterName = config.getInitParameter("response.cookies");
        this.cookiesFilterConfig = UrlRewriteUtil.getRewriteFilterConfig(this.rewriter.getConfig(), this.cookiesFilterName, UrlRewriteServletFilter.COOKIES_MIME_TYPE);
    }

    protected boolean ignoreHeader(String name) {
        return IGNORE_HEADER_NAMES.contains(name);
    }

    private String rewriteValue(String value, String rule) {
        try {
            Template input = Parser.parse((String)value);
            Template output = this.rewriter.rewrite((Resolver)this, input, UrlRewriter.Direction.OUT, rule);
            if (output != null) {
                value = output.getPattern();
            }
        }
        catch (URISyntaxException e) {
            LOG.failedToParseValueForUrlRewrite(value);
        }
        return value;
    }

    public void setHeader(String name, String value) {
        if (!this.ignoreHeader(name)) {
            value = this.rewriteValue(value, UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name));
            super.setHeader(name, value);
        }
    }

    public void addHeader(String name, String value) {
        if (!this.ignoreHeader(name)) {
            String rule = UrlRewriteUtil.pickFirstRuleWithEqualsIgnoreCasePathMatch(this.headersFilterConfig, name);
            value = this.rewriteValue(value, rule);
            super.addHeader(name, value);
        }
    }

    public OutputStream getRawOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public void streamResponse(InputStream input, OutputStream output) throws IOException {
        MimeType mimeType = this.getMimeType();
        UrlRewriteFilterContentDescriptor filterContentConfig = UrlRewriteUtil.getRewriteFilterConfig(this.rewriter.getConfig(), this.bodyFilterName, mimeType);
        InputStream filteredInput = UrlRewriteStreamFilterFactory.create(mimeType, null, input, this.rewriter, (Resolver)this, UrlRewriter.Direction.OUT, filterContentConfig);
        IOUtils.copyBytes((InputStream)filteredInput, (OutputStream)output, (int)4096);
        output.close();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = new UrlRewriteResponseStream((GatewayResponse)this);
        }
        return this.output;
    }

    public Set<String> getNames() {
        return Collections.emptySet();
    }

    public List<String> resolve(String name) {
        if (name.startsWith(REQUEST_PARAM_PREFIX)) {
            return Arrays.asList(this.getRequestParam(name.substring(REQUEST_PARAM_PREFIX.length())));
        }
        if (name.startsWith(GATEWAY_PARAM_PREFIX)) {
            return Arrays.asList(this.getGatewayParam(name.substring(GATEWAY_PARAM_PREFIX.length())));
        }
        if (name.startsWith(CLUSTER_PARAM_PREFIX)) {
            return Arrays.asList(this.getClusterParam(name.substring(GATEWAY_PARAM_PREFIX.length())));
        }
        return Arrays.asList(this.config.getInitParameter(name));
    }

    private String getGatewayParam(String name) {
        if ("url".equals(name)) {
            return this.request.getScheme() + "://" + this.request.getServerName() + ":" + this.request.getLocalPort() + this.request.getContextPath();
        }
        if ("address".equals(name)) {
            return this.request.getServerName() + ":" + this.request.getLocalPort();
        }
        if ("path".equals(name)) {
            return this.request.getContextPath();
        }
        return null;
    }

    private String getClusterParam(String name) {
        if ("name".equals(name)) {
            return this.config.getServletContext().getServletContextName();
        }
        return null;
    }

    private String getRequestParam(String name) {
        if ("host".equals(name)) {
            return this.request.getServerName();
        }
        if ("port".equals(name)) {
            return Integer.toString(this.request.getLocalPort());
        }
        if ("scheme".equals(name)) {
            return this.request.getScheme();
        }
        if ("context-path".equals(name)) {
            return Urls.stripLeadingSlash((String)this.request.getContextPath());
        }
        this.config.getServletContext().getServletContextName();
        return null;
    }

    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException();
    }

    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException();
    }

    static {
        IGNORE_HEADER_NAMES.add("Content-Length");
    }
}

