/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.filter.rewrite.api;

import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteFunctionDescriptor;

public abstract class UrlRewriteFunctionDescriptorFactory {
    private static Map<String, Class<? extends UrlRewriteFunctionDescriptor>> MAP = UrlRewriteFunctionDescriptorFactory.loadDescriptors();

    private UrlRewriteFunctionDescriptorFactory() {
    }

    public static <T extends UrlRewriteFunctionDescriptor<?>> T create(String name) {
        try {
            Class<? extends UrlRewriteFunctionDescriptor> descriptorClass = MAP.get(name);
            return (T)descriptorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(name);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(name);
        }
    }

    private static Map<String, Class<? extends UrlRewriteFunctionDescriptor>> loadDescriptors() {
        HashMap<String, Class<? extends UrlRewriteFunctionDescriptor>> map = new HashMap<String, Class<? extends UrlRewriteFunctionDescriptor>>();
        ServiceLoader<UrlRewriteFunctionDescriptor> descriptors = ServiceLoader.load(UrlRewriteFunctionDescriptor.class);
        for (UrlRewriteFunctionDescriptor descriptor : descriptors) {
            String functionName = descriptor.name();
            Class<?> descriptorClass = descriptor.getClass();
            map.put(functionName, descriptorClass);
        }
        return map;
    }

    public static Set<String> getNames() {
        return MAP.keySet();
    }
}

