/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.encrypturi.impl;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.gateway.encrypturi.EncryptStepContextParams;
import org.apache.hadoop.gateway.encrypturi.api.EncryptUriDescriptor;
import org.apache.hadoop.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepProcessor;
import org.apache.hadoop.gateway.filter.rewrite.spi.UrlRewriteStepStatus;
import org.apache.hadoop.gateway.services.GatewayServices;
import org.apache.hadoop.gateway.services.security.CryptoService;
import org.apache.hadoop.gateway.services.security.EncryptionResult;
import org.apache.hadoop.gateway.util.urltemplate.Evaluator;
import org.apache.hadoop.gateway.util.urltemplate.Expander;
import org.apache.hadoop.gateway.util.urltemplate.Params;
import org.apache.hadoop.gateway.util.urltemplate.Parser;
import org.apache.hadoop.gateway.util.urltemplate.Template;

public class EncryptUriProcessor
implements UrlRewriteStepProcessor<EncryptUriDescriptor> {
    private String clusterName;
    private CryptoService cryptoService;
    private String template;
    private String param;

    public String getType() {
        return "encrypt";
    }

    public void initialize(UrlRewriteEnvironment environment, EncryptUriDescriptor descriptor) throws Exception {
        this.clusterName = (String)environment.getAttribute("org.apache.hadoop.gateway.gateway.cluster");
        GatewayServices services = (GatewayServices)environment.getAttribute("org.apache.hadoop.gateway.gateway.services");
        this.cryptoService = (CryptoService)services.getService("CryptoService");
        this.template = descriptor.getTemplate();
        this.param = descriptor.getParam();
    }

    public UrlRewriteStepStatus process(UrlRewriteContext context) throws Exception {
        Template uri;
        String resolvedTemplate;
        if (!(this.param == null || this.param.isEmpty() || this.template == null || this.template.isEmpty() || (resolvedTemplate = Expander.expandToString((Template)(uri = Parser.parse((String)this.template)), (Params)context.getParameters(), (Evaluator)context.getEvaluator())) == null || resolvedTemplate.isEmpty())) {
            String endcoedUrl = this.encode(resolvedTemplate);
            EncryptStepContextParams params = new EncryptStepContextParams();
            params.addParam(this.param, Arrays.asList(endcoedUrl));
            context.addParameters((Params)params);
            return UrlRewriteStepStatus.SUCCESS;
        }
        return UrlRewriteStepStatus.FAILURE;
    }

    public void destroy() {
    }

    private String encode(String string) throws UnsupportedEncodingException {
        EncryptionResult result = this.cryptoService.encryptForCluster(this.clusterName, "encryptQueryString", string.getBytes("UTF-8"));
        string = Base64.encodeBase64URLSafeString((byte[])result.toByteAray());
        return string;
    }
}

