/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.ha.provider.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.hadoop.gateway.ha.provider.HaDescriptor;
import org.apache.hadoop.gateway.ha.provider.HaServiceConfig;
import org.apache.hadoop.gateway.ha.provider.impl.HaDescriptorConstants;
import org.apache.hadoop.gateway.ha.provider.impl.HaDescriptorFactory;
import org.apache.hadoop.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HaDescriptorManager
implements HaDescriptorConstants {
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);

    public static void store(HaDescriptor descriptor, Writer writer) throws IOException {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.setXmlStandalone(true);
            Element root = document.createElement("ha");
            document.appendChild(root);
            List<HaServiceConfig> serviceConfigs = descriptor.getServiceConfigs();
            if (serviceConfigs != null && !serviceConfigs.isEmpty()) {
                for (HaServiceConfig config : serviceConfigs) {
                    Element serviceElement = document.createElement("service");
                    serviceElement.setAttribute("name", config.getServiceName());
                    serviceElement.setAttribute("maxFailoverAttempts", Integer.toString(config.getMaxFailoverAttempts()));
                    serviceElement.setAttribute("failoverSleep", Integer.toString(config.getFailoverSleep()));
                    serviceElement.setAttribute("maxRetryAttempts", Integer.toString(config.getMaxRetryAttempts()));
                    serviceElement.setAttribute("retrySleep", Integer.toString(config.getRetrySleep()));
                    serviceElement.setAttribute("enabled", Boolean.toString(config.isEnabled()));
                    root.appendChild(serviceElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            transformerFactory.setAttribute("indent-number", 2);
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("standalone", "yes");
            transformer.setOutputProperty("indent", "yes");
            StreamResult result = new StreamResult(writer);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            LOG.failedToWriteHaDescriptor(e);
            throw new IOException(e);
        }
        catch (TransformerException e) {
            LOG.failedToWriteHaDescriptor(e);
            throw new IOException(e);
        }
    }

    public static HaDescriptor load(InputStream inputStream) throws IOException {
        HaDescriptor descriptor = HaDescriptorFactory.createDescriptor();
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document document = builder.parse(inputStream);
            NodeList nodeList = document.getElementsByTagName("service");
            if (nodeList != null && nodeList.getLength() > 0) {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Element element = (Element)nodeList.item(i);
                    HaServiceConfig config = HaDescriptorFactory.createServiceConfig(element.getAttribute("name"), element.getAttribute("enabled"), element.getAttribute("maxFailoverAttempts"), element.getAttribute("failoverSleep"), element.getAttribute("maxRetryAttempts"), element.getAttribute("retrySleep"));
                    descriptor.addServiceConfig(config);
                }
            }
        }
        catch (ParserConfigurationException e) {
            LOG.failedToLoadHaDescriptor(e);
            throw new IOException(e);
        }
        catch (SAXException e) {
            LOG.failedToLoadHaDescriptor(e);
            throw new IOException(e);
        }
        return descriptor;
    }
}

