/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.gateway.ha.deploy;

import java.io.IOException;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.gateway.deploy.DeploymentContext;
import org.apache.hadoop.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.hadoop.gateway.descriptor.FilterParamDescriptor;
import org.apache.hadoop.gateway.descriptor.ResourceDescriptor;
import org.apache.hadoop.gateway.ha.provider.HaDescriptor;
import org.apache.hadoop.gateway.ha.provider.HaServiceConfig;
import org.apache.hadoop.gateway.ha.provider.HaServletContextListener;
import org.apache.hadoop.gateway.ha.provider.impl.HaDescriptorFactory;
import org.apache.hadoop.gateway.ha.provider.impl.HaDescriptorManager;
import org.apache.hadoop.gateway.ha.provider.impl.i18n.HaMessages;
import org.apache.hadoop.gateway.i18n.messages.MessagesFactory;
import org.apache.hadoop.gateway.topology.Provider;
import org.apache.hadoop.gateway.topology.Service;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;

public class HaProviderDeploymentContributor
extends ProviderDeploymentContributorBase {
    private static final String PROVIDER_ROLE_NAME = "ha";
    private static final String PROVIDER_IMPL_NAME = "HaProvider";
    private static final String HA_DESCRIPTOR_NAME = "ha.provider.descriptor";
    private static final HaMessages LOG = (HaMessages)MessagesFactory.get(HaMessages.class);

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
        Map params = provider.getParams();
        HaDescriptor descriptor = HaDescriptorFactory.createDescriptor();
        for (Map.Entry entry : params.entrySet()) {
            HaServiceConfig config = HaDescriptorFactory.createServiceConfig((String)entry.getKey(), (String)entry.getValue());
            descriptor.addServiceConfig(config);
        }
        StringWriter writer = new StringWriter();
        try {
            HaDescriptorManager.store(descriptor, writer);
        }
        catch (IOException e) {
            LOG.failedToWriteHaDescriptor(e);
        }
        String asset = writer.toString();
        context.getWebArchive().addAsWebInfResource((Asset)new StringAsset(asset), "ha.xml");
        context.addDescriptor(HA_DESCRIPTOR_NAME, (Object)descriptor);
    }

    public void finalizeContribution(DeploymentContext context) {
        if (context.getDescriptor(HA_DESCRIPTOR_NAME) != null) {
            context.getWebAppDescriptor().createListener().listenerClass(HaServletContextListener.class.getName());
            context.getWebAppDescriptor().createContextParam().paramName("haDescriptorLocation").paramValue("/WEB-INF/ha.xml");
        }
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }
}

