/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.i18n.resources;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.knox.gateway.i18n.resources.Resource;
import org.apache.knox.gateway.i18n.resources.Resources;

public class ResourcesInvoker
implements InvocationHandler {
    private static ResourceBundle MISSING_BUNDLE = new ListResourceBundle(){

        @Override
        protected Object[][] getContents() {
            return null;
        }
    };
    private Class bundleClass;
    private String bundleName;
    private ConcurrentHashMap<Locale, ResourceBundle> bundles;

    public ResourcesInvoker(Class<?> bundleClass) {
        this.bundleClass = bundleClass;
        this.bundleName = ResourcesInvoker.calcBundleName(bundleClass);
        this.bundles = new ConcurrentHashMap();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return this.getText(method, args);
    }

    protected final String getText(Method method, Object[] args) {
        String pattern = this.getPattern(method);
        MessageFormat messageFormat = new MessageFormat(pattern, Locale.ROOT);
        return messageFormat.format(args);
    }

    protected final String getPattern(Method method) {
        String pattern = this.getBundlePattern(method);
        if (pattern == null && ((pattern = this.getAnnotationPattern(method)) == null || "{}".equals(pattern))) {
            pattern = ResourcesInvoker.getDefaultPattern(method);
        }
        return pattern;
    }

    protected String getAnnotationPattern(Method method) {
        String pattern = null;
        Resource anno = method.getAnnotation(Resource.class);
        if (anno != null) {
            pattern = anno.text();
        }
        return pattern;
    }

    protected final String getBundlePattern(Method method) {
        String pattern = null;
        ResourceBundle bundle = this.findBundle();
        if (bundle != null && bundle.containsKey(method.getName())) {
            pattern = bundle.getString(method.getName());
        }
        return pattern;
    }

    protected static String getDefaultPattern(Method method) {
        String suffix;
        String prefix = method.getName();
        int params = method.getParameterTypes().length;
        switch (params) {
            case 0: {
                suffix = "";
                break;
            }
            case 1: {
                suffix = "(\"{0}\")";
                break;
            }
            case 2: {
                suffix = "(\"{0}\",\"{1}\")";
                break;
            }
            case 3: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\")";
                break;
            }
            case 4: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\")";
                break;
            }
            case 5: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\")";
                break;
            }
            case 6: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\")";
                break;
            }
            case 7: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\",\"{6}\")";
                break;
            }
            case 8: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\",\"{6}\",\"{7}\")";
                break;
            }
            case 9: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\",\"{6}\",\"{7}\",\"{8}\")";
                break;
            }
            case 10: {
                suffix = "(\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\",\"{6}\",\"{7}\",\"{8}\",\"{9}\")";
                break;
            }
            default: {
                suffix = ResourcesInvoker.createDefaultPatternSuffix(params);
            }
        }
        return String.valueOf(prefix) + suffix;
    }

    private static String createDefaultPatternSuffix(int size) {
        StringBuilder builder = new StringBuilder(1 + size * 7);
        builder.append('(');
        int i = 0;
        while (i < size) {
            if (i > 0) {
                builder.append(',');
            }
            builder.append("\"{").append(i).append("}\"");
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }

    private static String calcBundleName(Class<?> clazz) {
        String bundle = null;
        Resources anno = clazz.getAnnotation(Resources.class);
        if (anno != null && "".equals(bundle = anno.bundle())) {
            bundle = null;
        }
        if (bundle == null) {
            bundle = clazz.getCanonicalName().replace('.', '/');
        }
        return bundle;
    }

    protected String getBundleName() {
        return this.bundleName;
    }

    protected final ResourceBundle findBundle() {
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = this.bundles.get(locale);
        if (MISSING_BUNDLE.equals(bundle)) {
            bundle = null;
        } else if (bundle == null) {
            try {
                bundle = ResourceBundle.getBundle(this.getBundleName(), locale, this.bundleClass.getClassLoader());
                this.bundles.put(locale, bundle);
            }
            catch (MissingResourceException e) {
                this.bundles.put(locale, MISSING_BUNDLE);
            }
        }
        return bundle;
    }
}

