/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.s3a;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.AWSCredentialProviderList;
import org.apache.hadoop.fs.s3a.auth.MarshalledCredentials;
import org.apache.hadoop.fs.s3a.auth.delegation.AbstractS3ATokenIdentifier;
import org.apache.hadoop.io.Text;
import org.apache.knox.gateway.cloud.idbroker.s3a.AuthResponseAWSMessage;
import org.apache.knox.gateway.cloud.idbroker.s3a.IDBDelegationTokenBinding;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBClient;
import org.apache.knox.gateway.cloud.idbroker.s3a.S3AIDBProperty;
import org.apache.knox.gateway.shell.CloudAccessBrokerSession;

public class TestIDBDelegationTokenBinding
extends IDBDelegationTokenBinding {
    private Path testTokenPath;
    private boolean getTestToken;

    public TestIDBDelegationTokenBinding() {
    }

    public TestIDBDelegationTokenBinding(String name, Text kind) {
        super(name, kind);
    }

    @Override
    public AWSCredentialProviderList deployUnbonded() throws IOException {
        this.loadTestToken();
        return super.deployUnbonded();
    }

    @Override
    public AWSCredentialProviderList bindToTokenIdentifier(AbstractS3ATokenIdentifier retrievedIdentifier) throws IOException {
        this.loadTestToken();
        return super.bindToTokenIdentifier(retrievedIdentifier);
    }

    private void loadTestToken() {
        LOG.warn("This implementation of the IDBDelegationTokenBinding is for testing purposes only");
        Configuration configuration = this.getConfig();
        String propertyValue = configuration.getTrimmed(S3AIDBProperty.IDBROKER_TEST_TOKEN_PATH.getPropertyName());
        if (StringUtils.isNotEmpty((CharSequence)propertyValue)) {
            Path path = Paths.get(propertyValue, new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("The specified path does not exist, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isRegularFile(path, new LinkOption[0])) {
                LOG.warn("The specified path is not a file, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else if (!Files.isReadable(path)) {
                LOG.warn("The specified file is not readable, a test token will not be used: {}", (Object)path.toAbsolutePath());
                this.testTokenPath = null;
            } else {
                this.testTokenPath = path;
                LOG.warn("Using test access token from {}", (Object)this.testTokenPath.toAbsolutePath());
            }
        } else {
            LOG.warn("A file for a test token was not specified, a test token will not be used");
            this.testTokenPath = null;
        }
        this.getTestToken = this.testTokenPath != null;
    }

    @Override
    protected MarshalledCredentials fetchMarshalledAWSCredentials(S3AIDBClient client, CloudAccessBrokerSession dtSession) throws IOException {
        MarshalledCredentials testToken;
        if (this.getTestToken) {
            testToken = this.readTestToken(client);
            this.getTestToken = false;
        } else {
            testToken = null;
        }
        if (testToken == null) {
            LOG.warn("This implementation of the AbfsIDBIntegration is for testing purposes only - using REAL access token");
            return super.fetchMarshalledAWSCredentials(client, dtSession);
        }
        LOG.warn("This implementation of the AbfsIDBIntegration is for testing purposes only - using TEST access token");
        return testToken;
    }

    private MarshalledCredentials readTestToken(S3AIDBClient s3AIDBClient) throws IOException {
        AuthResponseAWSMessage responseMessage;
        if (this.testTokenPath != null) {
            try (InputStream inputStream = Files.newInputStream(this.testTokenPath, new OpenOption[0]);){
                responseMessage = (AuthResponseAWSMessage)AuthResponseAWSMessage.serializer().fromJsonStream(inputStream);
            }
        } else {
            responseMessage = null;
        }
        if (responseMessage != null) {
            return s3AIDBClient.responseToMarshalledCredentials(responseMessage);
        }
        return null;
    }
}

