/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

public class OAuthPayload
implements Writable,
Serializable {
    private static final long serialVersionUID = 174663489540834820L;
    private String token = "";
    private long expiration;

    public OAuthPayload() {
    }

    public OAuthPayload(String token, long expiration) {
        this.token = token;
        this.expiration = expiration;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void write(DataOutput dataOutput) throws IOException {
        Text.writeString((DataOutput)dataOutput, (String)this.token);
        dataOutput.writeLong(this.expiration);
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.token = Text.readString((DataInput)dataInput);
        this.expiration = dataInput.readLong();
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty credentials";
        }
        int len = this.token.length();
        int end = len > 8 ? 8 : 1;
        return String.format(Locale.ROOT, "short-lived credentials (token='%s')%s", this.token.substring(0, end) + "...", this.expiration == 0L ? "" : ", expiring on " + new Date(this.expiration));
    }

    public boolean isEmpty() {
        return !StringUtils.isNotEmpty((CharSequence)this.token);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthPayload that = (OAuthPayload)o;
        return this.expiration == that.expiration && Objects.equals(this.token, that.token);
    }

    public int hashCode() {
        return Objects.hash(this.token, this.expiration);
    }
}

