/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.cloud.idbroker.common;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.knox.gateway.cloud.idbroker.common.KnoxToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnoxTokenMonitor {
    protected static final Logger LOG = LoggerFactory.getLogger(KnoxTokenMonitor.class);
    private static final MonitorThreadFactory threadFactory = new MonitorThreadFactory();
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    private ScheduledFuture<?> scheduledMonitor;

    public void monitorKnoxToken(KnoxToken knoxToken, long knoxTokenExpirationOffsetSeconds, GetKnoxTokenCommand command) {
        if (this.scheduledMonitor != null) {
            LOG.debug("Stopping previously scheduled KnoxTokenMonitor");
            this.scheduledMonitor.cancel(false);
        }
        if (knoxToken != null) {
            long delaySeconds;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Token expires in {} seconds:\n\tNow: {}\n\tExpiry: {}", new Object[]{knoxToken.getExpiry() - Instant.now().getEpochSecond(), Instant.now().toString(), Instant.ofEpochSecond(knoxToken.getExpiry()).toString()});
            }
            if ((delaySeconds = knoxToken.getExpiry() - Instant.now().getEpochSecond() - knoxTokenExpirationOffsetSeconds) < 0L) {
                delaySeconds = 0L;
            }
            LOG.debug("Starting KnoxTokenMonitor in {} seconds and running every {} seconds after", (Object)delaySeconds, (Object)knoxTokenExpirationOffsetSeconds);
            this.scheduledMonitor = this.executor.scheduleAtFixedRate(new Monitor(knoxToken, knoxTokenExpirationOffsetSeconds, command), delaySeconds, knoxTokenExpirationOffsetSeconds, TimeUnit.SECONDS);
        }
    }

    public void shutdown() {
        LOG.debug("Shutting down KnoxTokenMonitor");
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(20L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Failed to properly shutdown executor", (Throwable)e);
        }
        if (this.executor.isShutdown()) {
            LOG.debug("KnoxTokenMonitor has been shutdown.");
        }
    }

    static class MonitorThreadFactory
    implements ThreadFactory {
        private static final String PREFIX = "KnoxTokenMonitor-";
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        MonitorThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, PREFIX + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    public static interface GetKnoxTokenCommand {
        public void execute(KnoxToken var1) throws IOException;
    }

    private class Monitor
    implements Runnable {
        private final KnoxToken knoxToken;
        private final long knoxTokenExpirationOffsetSeconds;
        private final GetKnoxTokenCommand command;

        Monitor(KnoxToken knoxToken, long knoxTokenExpirationOffsetSeconds, GetKnoxTokenCommand command) {
            this.knoxToken = knoxToken;
            this.knoxTokenExpirationOffsetSeconds = knoxTokenExpirationOffsetSeconds;
            this.command = command;
        }

        @Override
        public void run() {
            LOG.debug("Renewing the Knox delegation token, if necessary...");
            if (this.command == null) {
                LOG.warn("Cannot renew the Knox delegation token, the GetKnoxTokenCommand has not been set.");
            } else if (this.knoxToken != null && this.knoxToken.isAboutToExpire(this.knoxTokenExpirationOffsetSeconds)) {
                try {
                    LOG.debug("The Knox delegation token is expired or is close to expiration. Renewing....");
                    this.command.execute(this.knoxToken);
                }
                catch (Exception e) {
                    LOG.error("Failed to renew the Knox delegation token", (Throwable)e);
                }
            }
        }
    }
}

